/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements.config;

import cc.polyfrost.oneconfig.config.annotations.Switch;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.gui.animations.Animation;
import cc.polyfrost.oneconfig.gui.animations.ColorAnimation;
import cc.polyfrost.oneconfig.gui.animations.EaseInOutQuad;
import cc.polyfrost.oneconfig.gui.animations.EaseOutBump;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.config.Preferences;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import java.lang.reflect.Field;

public class ConfigSwitch
extends BasicOption {
    private ColorAnimation color;
    private Animation animation;

    public ConfigSwitch(Field field, Object parent, String name, String description2, String category, String subcategory, int size) {
        super(field, parent, name, description2, category, subcategory, size);
    }

    public static ConfigSwitch create(Field field, Object parent) {
        Switch options = field.getAnnotation(Switch.class);
        return new ConfigSwitch(field, parent, options.name(), options.description(), options.category(), options.subcategory(), options.size());
    }

    @Override
    public void draw(long vg, int x, int y, InputHandler inputHandler) {
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        boolean toggled = false;
        try {
            toggled = (Boolean)this.get();
            if (this.animation == null) {
                this.animation = new EaseInOutQuad(0, 0.0f, 1.0f, !toggled);
                this.color = new ColorAnimation(toggled ? ColorPalette.PRIMARY : ColorPalette.SECONDARY);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        float percentOn = this.animation.get();
        int x2 = x + 3 + (int)(percentOn * 18.0f);
        boolean hovered = inputHandler.isAreaHovered(x, y, 42.0f, 32.0f);
        if (!this.isEnabled()) {
            nanoVGHelper.setAlpha(vg, 0.5f);
        }
        nanoVGHelper.drawRoundedRect(vg, x, y + 4, 42.0f, 24.0f, this.color.getColor(hovered, hovered && Platform.getMousePlatform().isButtonDown(0)), 12.0f);
        nanoVGHelper.drawRoundedRect(vg, x2, y + 7, 18.0f, 18.0f, Colors.WHITE, 9.0f);
        nanoVGHelper.drawText(vg, this.name, x + 50, y + 17, this.nameColor, 14.0f, Fonts.MEDIUM);
        if (inputHandler.isAreaClicked(x, y, 42.0f, 32.0f) && this.isEnabled()) {
            toggled = !toggled;
            try {
                this.set(toggled);
            }
            catch (IllegalAccessException e) {
                System.err.println("failed to write config value: class=" + this + " fieldWatching=" + this.field + " valueWrite=" + toggled);
                e.printStackTrace();
            }
        }
        if (toggled == this.animation.isReversed()) {
            this.animation = Preferences.toggleSwitchBounce ? new EaseOutBump(200, 0.0f, 1.0f, !toggled) : new EaseInOutQuad(150, 0.0f, 1.0f, !toggled);
            this.color.setPalette(toggled ? ColorPalette.PRIMARY : ColorPalette.SECONDARY);
        }
        nanoVGHelper.setAlpha(vg, 1.0f);
    }

    @Override
    protected float getNameX(int x) {
        return x + 50;
    }

    @Override
    public int getHeight() {
        return 32;
    }
}

