/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements.config;

import cc.polyfrost.oneconfig.config.annotations.Slider;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.gui.animations.Animation;
import cc.polyfrost.oneconfig.gui.animations.DummyAnimation;
import cc.polyfrost.oneconfig.gui.animations.EaseInOutCubic;
import cc.polyfrost.oneconfig.gui.animations.EaseInOutQuart;
import cc.polyfrost.oneconfig.gui.animations.EaseOutExpo;
import cc.polyfrost.oneconfig.gui.elements.IFocusable;
import cc.polyfrost.oneconfig.gui.elements.text.NumberInputField;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.config.Preferences;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.MathUtils;
import java.lang.reflect.Field;

public class ConfigSlider
extends BasicOption
implements IFocusable {
    private static final int STEP_POPUP_DURATION = 400;
    private static final int INDICATOR_POPUP_DURATION = 200;
    private static final float STEP_HEIGHT_TOTAL = 16.0f;
    private static final float STEP_HEIGHT_HOVER = 10.0f;
    private static final float STEP_HEIGHT_DRAG = 16.0f;
    private static final float TOUCH_TARGET_TOTAL = 16.0f;
    private static final float TOUCH_TARGET_HOVER = 16.0f;
    private static final float TOUCH_TARGET_DRAG = 10.0f;
    private final NumberInputField inputField;
    private final float min;
    private final float max;
    private final int step;
    private final boolean instant;
    private boolean isFloat = true;
    private boolean dragging = false;
    private boolean mouseWasDown = false;
    private Animation stepsAnimation;
    private Animation targetAnimation;
    private Animation stepSlideAnimation;
    private float animationStart;
    private float lastSliderTarget = 1.0f;
    private boolean animReset;
    private float lastX = -1.0f;

    public ConfigSlider(Field field, Object parent, String name, String description2, String category, String subcategory, float min2, float max, int step) {
        this(field, parent, name, description2, category, subcategory, min2, max, step, false);
    }

    public ConfigSlider(Field field, Object parent, String name, String description2, String category, String subcategory, float min2, float max, int step, boolean instant) {
        super(field, parent, name, description2, category, subcategory, 2);
        this.min = min2;
        this.max = max;
        this.step = step;
        this.instant = instant;
        this.inputField = new NumberInputField(84, 32, 0.0f, min2, max, step == 0 ? 1.0f : (float)step);
        this.stepsAnimation = new DummyAnimation(0.0f);
        this.targetAnimation = new DummyAnimation(0.0f);
        this.stepSlideAnimation = new DummyAnimation(1.0f);
    }

    public static ConfigSlider create(Field field, Object parent) {
        Slider slider = field.getAnnotation(Slider.class);
        return new ConfigSlider(field, parent, slider.name(), slider.description(), slider.category(), slider.subcategory(), slider.min(), slider.max(), slider.step(), slider.instant());
    }

    @Override
    public void draw(long vg, int x, int y, InputHandler inputHandler) {
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        int xCoordinate = 0;
        float value = 0.0f;
        boolean hovered = inputHandler.isAreaHovered(x + 352, y, 512.0f, 32.0f) && this.isEnabled();
        this.inputField.disable(!this.isEnabled());
        if (!this.isEnabled()) {
            nanoVGHelper.setAlpha(vg, 0.5f);
        }
        boolean isMouseDown = Platform.getMousePlatform().isButtonDown(0);
        if (hovered && isMouseDown && !this.mouseWasDown) {
            this.dragging = true;
        }
        boolean startedDragging = !this.mouseWasDown && isMouseDown;
        this.mouseWasDown = isMouseDown;
        if (this.dragging) {
            xCoordinate = (int)MathUtils.clamp(inputHandler.mouseX(), x + 352, x + 864);
            if (this.step > 0) {
                xCoordinate = this.getStepCoordinate(xCoordinate, x);
            }
            value = MathUtils.map(xCoordinate, x + 352, x + 864, this.min, this.max);
        } else if (this.inputField.isToggled() || this.inputField.arrowsClicked()) {
            value = this.inputField.getCurrentValue();
            xCoordinate = (int)MathUtils.clamp(MathUtils.map(value, this.min, this.max, x + 352, x + 864), x + 352, x + 864);
        }
        if (this.dragging && inputHandler.isClicked() || this.inputField.isToggled() || this.inputField.arrowsClicked()) {
            this.dragging = false;
            if (this.step > 0) {
                xCoordinate = this.getStepCoordinate(xCoordinate, x);
                value = MathUtils.map(xCoordinate, x + 352, x + 864, this.min, this.max);
            }
            this.setValue(value);
        } else if (this.dragging && this.instant) {
            this.setValue(value);
        }
        float stepPercent = this.stepsAnimation.get();
        float targetPercent = this.targetAnimation.get();
        if (this.isEnabled()) {
            if (this.dragging && startedDragging) {
                this.stepsAnimation = new EaseOutExpo(400, stepPercent, 1.0f, false);
                this.targetAnimation = new EaseOutExpo(200, targetPercent, 0.625f, false);
                this.animReset = true;
            } else if (!this.dragging && hovered) {
                if (this.targetAnimation.getEnd() != 1.0f) {
                    this.stepsAnimation = new EaseOutExpo(400, stepPercent, 0.625f, false);
                    this.targetAnimation = new EaseInOutQuart(200, targetPercent, 1.0f, false);
                    this.animReset = true;
                }
            } else if (!this.dragging && this.animReset) {
                this.stepsAnimation = new EaseOutExpo(400, stepPercent, 0.0f, false);
                this.targetAnimation = new EaseOutExpo(200, targetPercent, 0.0f, false);
                this.animReset = false;
            }
        }
        if (!this.dragging && !this.inputField.isToggled()) {
            try {
                Object object = this.get();
                if (object instanceof Integer) {
                    this.isFloat = false;
                }
                value = this.isFloat ? ((Float)object).floatValue() : (float)((Integer)object).intValue();
                xCoordinate = (int)MathUtils.clamp(MathUtils.map(value, this.min, this.max, x + 352, x + 864), x + 352, x + 864);
            }
            catch (IllegalAccessException object) {
                // empty catch block
            }
        }
        if (!this.inputField.isToggled()) {
            this.inputField.setCurrentValue(value);
        }
        if (this.stepSlideAnimation.isFinished() && this.lastSliderTarget != -1.0f && this.lastSliderTarget != (float)xCoordinate && (!this.dragging || startedDragging || this.step > 0) && this.lastX == (float)x) {
            this.animationStart = this.lastSliderTarget;
            this.stepSlideAnimation = new EaseInOutCubic((int)Preferences.trackerResponseDuration, 0.0f, 1.0f, false);
        }
        float progress = this.stepSlideAnimation.get();
        this.lastSliderTarget = xCoordinate;
        this.lastX = x;
        xCoordinate = (int)((float)xCoordinate * progress + this.animationStart * (1.0f - progress));
        float radius = 4.0f;
        if (this.step > 0) {
            radius *= 1.0f - Math.min(stepPercent, 0.625f) * 16.0f / 10.0f;
        }
        nanoVGHelper.drawText(vg, this.name, x, y + 17, this.nameColor, 14.0f, Fonts.MEDIUM);
        nanoVGHelper.drawRoundedRect(vg, x + 352, y + 13, 512.0f, 4.0f, Colors.GRAY_300, radius);
        nanoVGHelper.drawRoundedRect(vg, x + 352, y + 13 - 1, xCoordinate - x - 352, 6.0f, Colors.PRIMARY_500, 4.0f);
        if (this.step > 0 && stepPercent > 0.05f) {
            float stepOffset = stepPercent * 16.0f;
            for (float i = (float)(x + 354); i <= (float)(x + 864); i += 512.0f / ((this.max - this.min) / (float)this.step)) {
                int color = (float)xCoordinate > i - 2.0f ? Colors.PRIMARY_500 : Colors.GRAY_300;
                nanoVGHelper.drawRoundedRect(vg, i - 2.0f, (float)(y + 16 - 1) - stepOffset / 2.0f, 4.0f, stepOffset, color, 2.0f);
            }
        }
        nanoVGHelper.drawRoundedRect(vg, xCoordinate - 12, y + 4, 24.0f, 24.0f, Colors.WHITE, 12.0f);
        if (targetPercent > 0.02f) {
            nanoVGHelper.drawRoundedRect(vg, (float)xCoordinate - 8.0f * targetPercent, (float)(y + 16) - 8.0f * targetPercent, 16.0f * targetPercent, 16.0f * targetPercent, Colors.PRIMARY_500, 12.0f);
        }
        this.inputField.draw(vg, x + 892, y, inputHandler);
        nanoVGHelper.setAlpha(vg, 1.0f);
    }

    private int getStepCoordinate(int xCoordinate, int x) {
        Integer nearest = null;
        for (float i = (float)(x + 352); i <= (float)(x + 864); i += 512.0f / ((this.max - this.min) / (float)this.step)) {
            if (nearest != null && !(Math.abs((float)xCoordinate - i) < (float)Math.abs(xCoordinate - nearest))) continue;
            nearest = (int)i;
        }
        return nearest == null ? 0 : nearest;
    }

    private void setValue(float value) {
        try {
            if (this.isFloat) {
                this.set(Float.valueOf(value));
            } else {
                this.set(Math.round(value));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public void keyTyped(char key, int keyCode) {
        this.inputField.keyTyped(key, keyCode);
    }

    @Override
    public int getHeight() {
        return 32;
    }

    @Override
    public boolean hasFocus() {
        return this.inputField.isToggled();
    }
}

