/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements.config;

import cc.polyfrost.oneconfig.config.annotations.Number;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.gui.elements.IFocusable;
import cc.polyfrost.oneconfig.gui.elements.text.NumberInputField;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import java.lang.reflect.Field;

public class ConfigNumber
extends BasicOption
implements IFocusable {
    private final NumberInputField inputField;
    private boolean isFloat = true;
    private final int size;

    public ConfigNumber(Field field, Object parent, String name, String description2, String category, String subcategory, float min2, float max, int step, int size) {
        super(field, parent, name, description2, category, subcategory, size);
        this.inputField = new NumberInputField(84, 32, 0.0f, min2, max, step);
        this.size = size;
    }

    public static ConfigNumber create(Field field, Object parent) {
        Number slider = field.getAnnotation(Number.class);
        return new ConfigNumber(field, parent, slider.name(), slider.description(), slider.category(), slider.subcategory(), slider.min(), slider.max(), slider.step(), slider.size());
    }

    @Override
    public void draw(long vg, int x, int y, InputHandler inputHandler) {
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        float value = 0.0f;
        this.inputField.disable(!this.isEnabled());
        if (!this.isEnabled()) {
            nanoVGHelper.setAlpha(vg, 0.5f);
        }
        if (this.inputField.isToggled() || this.inputField.arrowsClicked()) {
            value = this.inputField.getCurrentValue();
        }
        if (this.inputField.isToggled() || this.inputField.arrowsClicked()) {
            this.setValue(value);
        }
        if (!this.inputField.isToggled()) {
            try {
                Object object = this.get();
                if (object instanceof Integer) {
                    this.isFloat = false;
                }
                value = this.isFloat ? ((Float)object).floatValue() : (float)((Integer)object).intValue();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (!this.inputField.isToggled()) {
            this.inputField.setCurrentValue(value);
        }
        nanoVGHelper.drawText(vg, this.name, x, y + 17, this.nameColor, 14.0f, Fonts.MEDIUM);
        this.inputField.draw(vg, x + (this.size == 1 ? 396 : 892), y, inputHandler);
        nanoVGHelper.setAlpha(vg, 1.0f);
    }

    private void setValue(float value) {
        try {
            if (this.isFloat) {
                this.set(Float.valueOf(value));
            } else {
                this.set(Math.round(value));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public void keyTyped(char key, int keyCode) {
        this.inputField.keyTyped(key, keyCode);
    }

    @Override
    public int getHeight() {
        return 32;
    }

    @Override
    protected boolean shouldDrawDescription() {
        return super.shouldDrawDescription() && !this.inputField.isToggled();
    }

    @Override
    public boolean hasFocus() {
        return this.inputField.isToggled();
    }
}

