/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements.config;

import cc.polyfrost.oneconfig.config.annotations.KeyBind;
import cc.polyfrost.oneconfig.config.core.OneKeyBind;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.events.event.RawMouseEvent;
import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.gui.elements.BasicButton;
import cc.polyfrost.oneconfig.gui.elements.IFocusable;
import cc.polyfrost.oneconfig.internal.assets.SVGs;
import cc.polyfrost.oneconfig.libs.eventbus.Subscribe;
import cc.polyfrost.oneconfig.libs.universal.UKeyboard;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import java.lang.reflect.Field;

public class ConfigKeyBind
extends BasicOption
implements IFocusable {
    private final BasicButton button = new BasicButton(256, 32, "", SVGs.KEYSTROKE, null, 3, ColorPalette.SECONDARY);
    private boolean clicked = false;
    private InputHandler inputHandler;

    public ConfigKeyBind(Field field, Object parent, String name, String description2, String category, String subcategory, int size) {
        super(field, parent, name, description2, category, subcategory, size);
        this.button.setToggleable(true);
        EventManager.INSTANCE.register(this);
    }

    @Subscribe
    private void onMouse(RawMouseEvent event) {
        if (this.button.isToggled() && event.state == 1) {
            OneKeyBind keyBind = this.getKeyBind();
            keyBind.addKey(event.button, true);
            this.setKeyBind(keyBind);
        }
    }

    public static ConfigKeyBind create(Field field, Object parent) {
        KeyBind keyBind = field.getAnnotation(KeyBind.class);
        return new ConfigKeyBind(field, parent, keyBind.name(), keyBind.description(), keyBind.category(), keyBind.subcategory(), keyBind.size());
    }

    @Override
    public void draw(long vg, int x, int y, InputHandler inputHandler) {
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        this.inputHandler = inputHandler;
        if (!this.isEnabled()) {
            nanoVGHelper.setAlpha(vg, 0.5f);
        }
        nanoVGHelper.drawText(vg, this.name, x, y + 17, this.nameColor, 14.0f, Fonts.MEDIUM);
        OneKeyBind keyBind = this.getKeyBind();
        String text = keyBind.getDisplay();
        this.button.disable(!this.isEnabled());
        if (this.button.isToggled()) {
            inputHandler.blockAllInput();
            if (text.equals("")) {
                text = "Recording... (ESC to clear)";
            }
            if (!this.clicked) {
                keyBind.clearKeys();
                this.setKeyBind(keyBind);
                this.clicked = true;
            } else if (keyBind.getSize() == 0 || keyBind.isActive()) {
                OneConfigGui.INSTANCE.allowClose = false;
            } else {
                this.button.setToggled(false);
                this.clicked = false;
                OneConfigGui.INSTANCE.allowClose = true;
                inputHandler.stopBlockingInput();
            }
        } else if (text.equals("")) {
            text = "NONE";
        }
        this.button.setText(text);
        this.button.draw(vg, x + (this.size == 1 ? 224 : 736), y, inputHandler);
        nanoVGHelper.setAlpha(vg, 1.0f);
    }

    @Override
    public void keyTyped(char key, int keyCode) {
        if (!this.button.isToggled()) {
            return;
        }
        OneKeyBind keyBind = this.getKeyBind();
        if (keyCode == UKeyboard.KEY_ESCAPE) {
            keyBind.clearKeys();
            this.button.setToggled(false);
            OneConfigGui.INSTANCE.allowClose = true;
            this.clicked = false;
            this.inputHandler.stopBlockingInput();
        } else {
            keyBind.addKey(keyCode);
        }
        this.setKeyBind(keyBind);
    }

    private OneKeyBind getKeyBind() {
        OneKeyBind keyBind = new OneKeyBind();
        try {
            this.field.setAccessible(true);
            keyBind = (OneKeyBind)this.get();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return keyBind;
    }

    private void setKeyBind(OneKeyBind keyBind) {
        try {
            this.set(keyBind);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public int getHeight() {
        return 32;
    }

    @Override
    public boolean hasFocus() {
        return this.clicked;
    }
}

