/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements.config;

import cc.polyfrost.oneconfig.config.annotations.DualOption;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.gui.animations.Animation;
import cc.polyfrost.oneconfig.gui.animations.EaseOutExpo;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import java.lang.reflect.Field;

public class ConfigDualOption
extends BasicOption {
    private final String left;
    private final String right;
    private Animation posAnimation;

    public ConfigDualOption(Field field, Object parent, String name, String description2, String category, String subcategory, int size, String left, String right) {
        super(field, parent, name, description2, category, subcategory, size);
        this.left = left;
        this.right = right;
    }

    public static ConfigDualOption create(Field field, Object parent) {
        DualOption dualOption = field.getAnnotation(DualOption.class);
        return new ConfigDualOption(field, parent, dualOption.name(), dualOption.description(), dualOption.category(), dualOption.subcategory(), dualOption.size(), dualOption.left(), dualOption.right());
    }

    @Override
    public int getHeight() {
        return 32;
    }

    @Override
    public void draw(long vg, int x, int y, InputHandler inputHandler) {
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        boolean toggled = false;
        try {
            toggled = (Boolean)this.get();
            if (this.posAnimation == null) {
                this.posAnimation = new EaseOutExpo(0, 228.0f, 356.0f, !toggled);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (!this.isEnabled()) {
            nanoVGHelper.setAlpha(vg, 0.5f);
        }
        boolean hoveredLeft = inputHandler.isAreaHovered(x + 226, y, 128.0f, 32.0f) && this.isEnabled();
        boolean hoveredRight = inputHandler.isAreaHovered(x + 354, y, 128.0f, 32.0f) && this.isEnabled();
        nanoVGHelper.drawText(vg, this.name, x, y + 16, this.nameColor, 14.0f, Fonts.MEDIUM);
        nanoVGHelper.drawRoundedRect(vg, x + 226, y, 256.0f, 32.0f, Colors.GRAY_600, 12.0f);
        nanoVGHelper.drawRoundedRect(vg, (float)x + this.posAnimation.get(), y + 2, 124.0f, 28.0f, Colors.PRIMARY_600, 10.0f);
        if (!hoveredLeft && this.isEnabled()) {
            nanoVGHelper.setAlpha(vg, 0.8f);
        }
        nanoVGHelper.drawText(vg, this.left, (float)(x + 290) - nanoVGHelper.getTextWidth(vg, this.left, 12.0f, Fonts.MEDIUM) / 2.0f, y + 17, Colors.WHITE, 12.0f, Fonts.MEDIUM);
        if (this.isEnabled()) {
            nanoVGHelper.setAlpha(vg, 1.0f);
        }
        if (!hoveredRight && this.isEnabled()) {
            nanoVGHelper.setAlpha(vg, 0.8f);
        }
        nanoVGHelper.drawText(vg, this.right, (float)(x + 418) - nanoVGHelper.getTextWidth(vg, this.right, 12.0f, Fonts.MEDIUM) / 2.0f, y + 17, Colors.WHITE, 12.0f, Fonts.MEDIUM);
        nanoVGHelper.setAlpha(vg, 1.0f);
        if ((hoveredLeft && toggled || hoveredRight && !toggled) && inputHandler.isClicked()) {
            toggled = !toggled;
            try {
                this.set(toggled);
            }
            catch (IllegalAccessException e) {
                System.err.println("failed to write config value: class=" + this + " fieldWatching=" + this.field + " valueWrite=" + toggled);
                e.printStackTrace();
            }
        }
        if (toggled == this.posAnimation.isReversed()) {
            this.posAnimation = new EaseOutExpo(300, 228.0f, 356.0f, !toggled);
        }
    }
}

