/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements.config;

import cc.polyfrost.oneconfig.config.annotations.Dropdown;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.gui.animations.Animation;
import cc.polyfrost.oneconfig.gui.animations.ColorAnimation;
import cc.polyfrost.oneconfig.gui.animations.EaseOutQuad;
import cc.polyfrost.oneconfig.gui.elements.text.TextInputField;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.assets.SVGs;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.renderer.scissor.Scissor;
import cc.polyfrost.oneconfig.renderer.scissor.ScissorHelper;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.collections.ArraysKt;

public class ConfigDropdown
extends BasicOption {
    private final String[] originalOptions;
    private final List<String> options;
    private final ColorAnimation backgroundColor = new ColorAnimation(ColorPalette.SECONDARY);
    private final ColorAnimation atomColor = new ColorAnimation(new ColorPalette(Colors.PRIMARY_600, Colors.PRIMARY_500, Colors.PRIMARY_500));
    private final ColorAnimation colorAnimation = new ColorAnimation(new ColorPalette(Colors.GRAY_400_80, Colors.GRAY_400, Colors.GRAY_400), 200);
    private final TextInputField textInputField;
    private boolean opened = false;
    private Scissor inputScissor = null;
    private Animation scrollAnimation = null;
    private float scrollTarget = 0.0f;
    private long scrollTime = 0L;
    private boolean mouseWasDown = false;
    private boolean dragging = false;
    private float yStart = 0.0f;
    private float scroll = 0.0f;
    private InputHandler inputHandler;

    public ConfigDropdown(Field field, Object parent, String name, String description2, String category, String subcategory, int size, String[] options) {
        super(field, parent, name, description2, category, subcategory, size);
        this.originalOptions = options;
        this.options = new ArrayList<String>(options.length);
        this.options.addAll(Arrays.asList(options));
        this.textInputField = new TextInputField(size == 1 ? 256 : 640, 32, "Search...", false, false, SVGs.SEARCH_SM, 12.0f);
    }

    public static ConfigDropdown create(Field field, Object parent) {
        Dropdown dropdown = field.getAnnotation(Dropdown.class);
        return new ConfigDropdown(field, parent, dropdown.name(), dropdown.description(), dropdown.category(), dropdown.subcategory(), dropdown.size(), dropdown.options());
    }

    @Override
    public void draw(long vg, int x, int y, InputHandler inputHandler) {
        boolean hovered;
        this.inputHandler = inputHandler;
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        if (!this.isEnabled()) {
            nanoVGHelper.setAlpha(vg, 0.5f);
        }
        nanoVGHelper.drawText(vg, this.name, x, y + 16, this.nameColor, 14.0f, Fonts.MEDIUM);
        if (this.size == 1) {
            hovered = inputHandler.isAreaHovered(x + 224, y, 256.0f, 32.0f) && this.isEnabled();
        } else {
            boolean bl = hovered = inputHandler.isAreaHovered(x + 352, y, 640.0f, 32.0f) && this.isEnabled();
        }
        if (hovered && inputHandler.isClicked() || this.opened && inputHandler.isClicked(!this.dragging) && (this.size == 1 && !inputHandler.isAreaHovered(x + 224, y + 40, 256.0f, this.options.size() * 32, true) || this.size == 2 && !inputHandler.isAreaHovered(x + 352, y + 40, 640.0f, this.options.size() * 32, true))) {
            boolean bl = this.opened = !this.opened;
            if (!this.opened) {
                inputHandler.unblockDWheel();
                inputHandler.stopBlockingInput();
                if (this.inputScissor != null) {
                    inputHandler.stopBlock(this.inputScissor);
                }
            } else {
                this.inputScissor = inputHandler.blockAllInput();
                this.textInputField.onClick();
                this.options.clear();
                for (String option : this.originalOptions) {
                    if (!option.toLowerCase(Locale.ENGLISH).contains(this.textInputField.getInput().toLowerCase(Locale.ENGLISH))) continue;
                    this.options.add(option);
                }
            }
            this.backgroundColor.setPalette(this.opened ? ColorPalette.PRIMARY : ColorPalette.SECONDARY);
        }
        if (this.opened) {
            return;
        }
        int selected = 0;
        try {
            selected = (Integer)this.get();
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (hovered && Platform.getMousePlatform().isButtonDown(0)) {
            nanoVGHelper.setAlpha(vg, 0.8f);
        }
        if (this.size == 1) {
            nanoVGHelper.drawRoundedRect(vg, x + 224, y, 256.0f, 32.0f, this.backgroundColor.getColor(hovered, hovered && Platform.getMousePlatform().isButtonDown(0)), 12.0f);
            nanoVGHelper.drawText(vg, this.originalOptions[selected], x + 236, y + 16, Colors.WHITE_80, 14.0f, Fonts.MEDIUM);
            nanoVGHelper.drawRoundedRect(vg, x + 452, y + 4, 24.0f, 24.0f, this.atomColor.getColor(hovered, false), 8.0f);
            nanoVGHelper.drawSvg(vg, SVGs.DROPDOWN_LIST, (float)(x + 452), (float)(y + 4), 24.0f, 24.0f);
        } else {
            nanoVGHelper.drawRoundedRect(vg, x + 352, y, 640.0f, 32.0f, this.backgroundColor.getColor(hovered, hovered && Platform.getMousePlatform().isButtonDown(0)), 12.0f);
            nanoVGHelper.drawText(vg, this.originalOptions[selected], x + 364, y + 16, Colors.WHITE_80, 14.0f, Fonts.MEDIUM);
            nanoVGHelper.drawRoundedRect(vg, x + 964, y + 4, 24.0f, 24.0f, this.atomColor.getColor(hovered, false), 8.0f);
            nanoVGHelper.drawSvg(vg, SVGs.DROPDOWN_LIST, (float)(x + 964), (float)(y + 4), 24.0f, 24.0f);
        }
        nanoVGHelper.setAlpha(vg, 1.0f);
    }

    @Override
    public void drawLast(long vg, int x, int y, InputHandler inputHandler) {
        super.drawLast(vg, x, y, inputHandler);
        if (!this.opened) {
            this.finishUpAndClose(false);
            return;
        }
        if (this.dragging) {
            inputHandler.blockAllInput();
        }
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        boolean hovered = this.size == 1 ? inputHandler.isAreaHovered(x + 224, y, 256.0f, 32.0f, true) : inputHandler.isAreaHovered(x + 352, y, 640.0f, 32.0f, true);
        this.textInputField.setErrored(this.options.isEmpty());
        if (hovered && Platform.getMousePlatform().isButtonDown(0)) {
            nanoVGHelper.setAlpha(vg, 0.8f);
        }
        if (this.size == 1) {
            this.textInputField.draw(vg, x + 224, y, inputHandler);
        } else {
            this.textInputField.draw(vg, x + 352, y, inputHandler);
        }
        if (this.options.isEmpty()) {
            return;
        }
        if (this.size == 1) {
            nanoVGHelper.setAlpha(vg, 1.0f);
            nanoVGHelper.drawRoundedRect(vg, x + 224, y + 40, 256.0f, Math.min(this.options.size(), 10) * 32 + 8, Colors.GRAY_700, 12.0f);
            nanoVGHelper.drawHollowRoundRect(vg, x + 223, y + 39, 258.0f, Math.min(this.options.size(), 10) * 32 + 10, new Color(204, 204, 204, 77).getRGB(), 12.0f, 1.0f);
            ScissorHelper scissorHelper = ScissorHelper.INSTANCE;
            Scissor scissor = null;
            if (this.options.size() > 10) {
                scissor = scissorHelper.scissor(vg, x + 224, y + 40, 256.0f, 328.0f);
            }
            inputHandler.unblockDWheel();
            this.scroll = this.scrollAnimation == null ? this.scrollTarget : this.scrollAnimation.get();
            float maxHeight = this.options.size() * 32 + 8;
            float scrollWidth = Math.min(this.options.size(), 10) * 32 + 8;
            float scrollBarLength = scrollWidth / maxHeight * scrollWidth;
            float dWheel = (float)inputHandler.getDWheel(true);
            if (dWheel != 0.0f) {
                this.scrollTarget = (float)((double)this.scrollTarget + (double)dWheel * 0.25);
                if (this.scrollTarget > 0.0f) {
                    this.scrollTarget = 0.0f;
                } else if (this.scrollTarget < -maxHeight + scrollWidth) {
                    this.scrollTarget = -maxHeight + scrollWidth;
                }
                this.scrollAnimation = new EaseOutQuad(150, this.scroll, this.scrollTarget, false);
                this.scrollTime = System.currentTimeMillis();
            } else if (this.scrollAnimation != null && this.scrollAnimation.isFinished()) {
                this.scrollAnimation = null;
            }
            float optionY = (float)(y + 44) + this.scroll;
            for (String option : this.options) {
                int color = Colors.WHITE_80;
                boolean optionHovered = inputHandler.isAreaHovered(x + 224, optionY, 252.0f, 32.0f, true);
                if (optionHovered && Platform.getMousePlatform().isButtonDown(0)) {
                    nanoVGHelper.drawRoundedRect(vg, x + 228, optionY + 2.0f, 248.0f, 28.0f, Colors.PRIMARY_700_80, 8.0f);
                } else if (optionHovered) {
                    nanoVGHelper.drawRoundedRect(vg, x + 228, optionY + 2.0f, 248.0f, 28.0f, Colors.PRIMARY_700, 8.0f);
                    color = Colors.WHITE;
                }
                if (optionHovered && inputHandler.isClicked(!this.dragging)) {
                    try {
                        this.set(ArraysKt.indexOf(this.originalOptions, option));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    this.opened = false;
                    this.backgroundColor.setPalette(ColorPalette.SECONDARY);
                    inputHandler.unblockDWheel();
                    if (this.inputScissor != null && !this.dragging) {
                        inputHandler.stopBlock(this.inputScissor);
                    }
                }
                nanoVGHelper.drawText(vg, option, x + 240, optionY + 18.0f, color, 14.0f, Fonts.MEDIUM);
                optionY += 32.0f;
            }
            if (scissor != null) {
                scissorHelper.resetScissor(vg, scissor);
            }
            if (this.dragging && inputHandler.isClicked(true)) {
                this.dragging = false;
                inputHandler.stopBlockingInput();
            }
            if (!(scrollBarLength >= scrollWidth)) {
                boolean scrollTimePeriod;
                float scrollBarY = this.scroll / maxHeight * (scrollWidth - 8.0f) - 45.0f;
                boolean isMouseDown = Platform.getMousePlatform().isButtonDown(0);
                boolean scrollHover = inputHandler.isAreaHovered(x + 476, (float)y - scrollBarY, 12.0f, (int)scrollBarLength - 5, true);
                boolean bl = scrollTimePeriod = System.currentTimeMillis() - this.scrollTime < 1000L;
                if (scrollHover && isMouseDown && !this.mouseWasDown) {
                    this.yStart = inputHandler.mouseY();
                    this.dragging = true;
                }
                this.mouseWasDown = isMouseDown;
                if (this.dragging) {
                    this.scrollTarget = -(inputHandler.mouseY() - this.yStart) * maxHeight / scrollWidth;
                    if (this.scrollTarget > 0.0f) {
                        this.scrollTarget = 0.0f;
                    } else if (this.scrollTarget < -maxHeight + scrollWidth) {
                        this.scrollTarget = -maxHeight + scrollWidth;
                    }
                    this.scrollAnimation = new EaseOutQuad(150, this.scroll, this.scrollTarget, false);
                }
                NanoVGHelper.INSTANCE.drawRoundedRect(vg, x + 476, (float)y - scrollBarY, 4.0f, scrollBarLength - 5.0f, this.colorAnimation.getColor(scrollHover || scrollTimePeriod, this.dragging), 4.0f);
            }
            if (inputHandler.isAreaHovered(x + 224, y + 40, 256.0f, Math.min(this.options.size(), 10) * 32 + 8, true) && this.opened) {
                inputHandler.blockDWheel();
            }
        } else {
            nanoVGHelper.setAlpha(vg, 1.0f);
            nanoVGHelper.drawRoundedRect(vg, x + 352, y + 40, 640.0f, Math.min(this.options.size(), 10) * 32 + 8, Colors.GRAY_700, 12.0f);
            nanoVGHelper.drawHollowRoundRect(vg, x + 351, y + 39, 642.0f, Math.min(this.options.size(), 10) * 32 + 10, new Color(204, 204, 204, 77).getRGB(), 12.0f, 1.0f);
            ScissorHelper scissorHelper = ScissorHelper.INSTANCE;
            Scissor scissor = null;
            if (this.options.size() > 10) {
                scissor = scissorHelper.scissor(vg, x + 352, y + 40, 640.0f, 328.0f);
            }
            inputHandler.unblockDWheel();
            this.scroll = this.scrollAnimation == null ? this.scrollTarget : this.scrollAnimation.get();
            float maxHeight = this.options.size() * 32 + 8;
            float scrollWidth = Math.min(this.options.size(), 10) * 32 + 8;
            float scrollBarLength = scrollWidth / maxHeight * scrollWidth;
            float dWheel = (float)inputHandler.getDWheel(true);
            if (dWheel != 0.0f) {
                this.scrollTarget = (float)((double)this.scrollTarget + (double)dWheel * 0.25);
                if (this.scrollTarget > 0.0f) {
                    this.scrollTarget = 0.0f;
                } else if (this.scrollTarget < -maxHeight + scrollWidth) {
                    this.scrollTarget = -maxHeight + scrollWidth;
                }
                this.scrollAnimation = new EaseOutQuad(150, this.scroll, this.scrollTarget, false);
                this.scrollTime = System.currentTimeMillis();
            } else if (this.scrollAnimation != null && this.scrollAnimation.isFinished()) {
                this.scrollAnimation = null;
            }
            float optionY = (float)(y + 44) + this.scroll;
            for (String option : this.options) {
                int color = Colors.WHITE_80;
                boolean optionHovered = inputHandler.isAreaHovered(x + 352, optionY, 640.0f, 36.0f, true);
                if (optionHovered && Platform.getMousePlatform().isButtonDown(0)) {
                    nanoVGHelper.drawRoundedRect(vg, x + 356, optionY + 2.0f, 632.0f, 28.0f, Colors.PRIMARY_700_80, 8.0f);
                } else if (optionHovered) {
                    nanoVGHelper.drawRoundedRect(vg, x + 356, optionY + 2.0f, 632.0f, 28.0f, Colors.PRIMARY_700, 8.0f);
                    color = Colors.WHITE;
                }
                nanoVGHelper.drawText(vg, option, x + 368, optionY + 18.0f, color, 14.0f, Fonts.MEDIUM);
                if (optionHovered && inputHandler.isClicked(!this.dragging)) {
                    try {
                        this.set(ArraysKt.indexOf(this.originalOptions, option));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                    this.opened = false;
                    this.backgroundColor.setPalette(ColorPalette.SECONDARY);
                    inputHandler.unblockDWheel();
                    if (this.inputScissor != null && !this.dragging) {
                        inputHandler.stopBlock(this.inputScissor);
                    }
                }
                optionY += 32.0f;
            }
            if (scissor != null) {
                scissorHelper.resetScissor(vg, scissor);
            }
            if (this.dragging && inputHandler.isClicked(true)) {
                this.dragging = false;
                inputHandler.stopBlockingInput();
            }
            if (!(scrollBarLength >= scrollWidth)) {
                boolean scrollTimePeriod;
                float scrollBarY = this.scroll / maxHeight * (scrollWidth - 8.0f) - 45.0f;
                boolean isMouseDown = Platform.getMousePlatform().isButtonDown(0);
                boolean scrollHover = inputHandler.isAreaHovered(x + 988, (float)y - scrollBarY, 12.0f, (int)scrollBarLength - 5, true);
                boolean bl = scrollTimePeriod = System.currentTimeMillis() - this.scrollTime < 1000L;
                if (scrollHover && isMouseDown && !this.mouseWasDown) {
                    this.yStart = inputHandler.mouseY();
                    this.dragging = true;
                }
                this.mouseWasDown = isMouseDown;
                if (this.dragging) {
                    this.scrollTarget = -(inputHandler.mouseY() - this.yStart) * maxHeight / scrollWidth;
                    if (this.scrollTarget > 0.0f) {
                        this.scrollTarget = 0.0f;
                    } else if (this.scrollTarget < -maxHeight + scrollWidth) {
                        this.scrollTarget = -maxHeight + scrollWidth;
                    }
                    this.scrollAnimation = new EaseOutQuad(150, this.scroll, this.scrollTarget, false);
                }
                NanoVGHelper.INSTANCE.drawRoundedRect(vg, x + 988, (float)y - scrollBarY, 4.0f, scrollBarLength - 5.0f, this.colorAnimation.getColor(scrollHover || scrollTimePeriod, this.dragging), 4.0f);
            }
            if (inputHandler.isAreaHovered(x + 352, y + 40, 640.0f, Math.min(this.options.size(), 10) * 32 + 8, true) && this.opened) {
                inputHandler.blockDWheel();
            }
        }
        nanoVGHelper.setAlpha(vg, 1.0f);
    }

    @Override
    public void keyTyped(char key, int keyCode) {
        super.keyTyped(key, keyCode);
        this.textInputField.keyTyped(key, keyCode);
        if (this.opened) {
            this.options.clear();
            for (String option : this.originalOptions) {
                if (!option.toLowerCase(Locale.ENGLISH).contains(this.textInputField.getInput().toLowerCase(Locale.ENGLISH))) continue;
                this.options.add(option);
            }
        }
    }

    @Override
    public int getHeight() {
        return 32;
    }

    @Override
    protected boolean shouldDrawDescription() {
        return super.shouldDrawDescription() && !this.opened;
    }

    @Override
    public void finishUpAndClose() {
        super.finishUpAndClose();
        this.finishUpAndClose(true);
    }

    private void finishUpAndClose(boolean unblock) {
        super.finishUpAndClose();
        this.textInputField.setInput("");
        this.scroll = 0.0f;
        this.scrollTarget = 0.0f;
        this.scrollTime = 0L;
        this.scrollAnimation = null;
        if (unblock && this.inputHandler != null) {
            this.inputHandler.unblockDWheel();
            this.inputHandler.stopBlockingInput();
        }
    }
}

