/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements.config;

import cc.polyfrost.oneconfig.config.annotations.Color;
import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.gui.elements.BasicElement;
import cc.polyfrost.oneconfig.gui.elements.ColorSelector;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.assets.Images;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.RenderTickDelay;
import java.lang.reflect.Field;

public class ConfigColorElement
extends BasicOption {
    private final BasicElement element = new BasicElement(64, 32, false);
    private final boolean allowAlpha;
    private ColorSelector colorSelector;
    private boolean open = false;

    public ConfigColorElement(Field field, Object parent, String name, String description2, String category, String subcategory, int size, boolean allowAlpha) {
        super(field, parent, name, description2, category, subcategory, size);
        this.allowAlpha = allowAlpha;
    }

    public static ConfigColorElement create(Field field, Object parent) {
        Color color = field.getAnnotation(Color.class);
        return new ConfigColorElement(field, parent, color.name(), color.description(), color.category(), color.subcategory(), color.size(), color.allowAlpha());
    }

    @Override
    public void draw(long vg, int x, int y, InputHandler inputHandler) {
        OneColor color;
        if (OneConfigGui.INSTANCE == null) {
            return;
        }
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        if (!this.isEnabled()) {
            nanoVGHelper.setAlpha(vg, 0.5f);
        }
        this.element.disable(!this.isEnabled());
        int x1 = this.size == 1 ? x : x + 512;
        try {
            color = (OneColor)this.get();
        }
        catch (IllegalAccessException e) {
            return;
        }
        nanoVGHelper.drawText(vg, this.name, x, y + 16, this.nameColor, 14.0f, Fonts.MEDIUM);
        this.element.update(x1 + 416, y, inputHandler);
        nanoVGHelper.drawHollowRoundRect(vg, x1 + 415, y - 1, 64.0f, 32.0f, Colors.GRAY_300, 12.0f, 2.0f);
        nanoVGHelper.drawRoundImage(vg, Images.ALPHA_GRID.filePath, x1 + 420, y + 4, 56.0f, 24.0f, 8.0f, this.getClass());
        nanoVGHelper.drawRoundedRect(vg, x1 + 420, y + 4, 56.0f, 24.0f, color.getRGB(), 8.0f);
        if (this.element.isClicked() && !this.open) {
            OneColor finalColor = new OneColor(color.getHue(), color.getSaturation(), color.getBrightness(), color.getAlpha(), color.getDataBit() == -1 ? color.getDataBit() : color.getDataBit() * 1000);
            new RenderTickDelay(() -> {
                this.open = true;
                this.colorSelector = new ColorSelector(finalColor, inputHandler.mouseX(), inputHandler.mouseY(), this.allowAlpha, inputHandler);
                OneConfigGui.INSTANCE.initColorSelector(this.colorSelector);
            }, 1);
        }
        if (OneConfigGui.INSTANCE.currentColorSelector != this.colorSelector) {
            this.open = false;
        } else if (this.open) {
            this.setColor(OneConfigGui.INSTANCE.getColor());
        }
        nanoVGHelper.setAlpha(vg, 1.0f);
    }

    protected void setColor(OneColor color) {
        try {
            if (this.field == null) {
                return;
            }
            Object colorField = this.field.get(this.parent);
            if (!(colorField instanceof OneColor)) {
                return;
            }
            if (!color.equals(colorField)) {
                OneColor finalColor = (OneColor)colorField;
                finalColor.setFromOneColor(color);
                finalColor.setChromaSpeed(color.getDataBit());
                this.triggerListeners();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    public int getHeight() {
        return 32;
    }
}

