/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements.config;

import cc.polyfrost.oneconfig.config.annotations.Checkbox;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.gui.animations.Animation;
import cc.polyfrost.oneconfig.gui.animations.ColorAnimation;
import cc.polyfrost.oneconfig.gui.animations.EaseInOutQuad;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.assets.SVGs;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import cc.polyfrost.oneconfig.utils.color.ColorUtils;
import java.awt.Color;
import java.lang.reflect.Field;

public class ConfigCheckbox
extends BasicOption {
    private final ColorAnimation color = new ColorAnimation(ColorPalette.SECONDARY);
    private Animation animation;

    public ConfigCheckbox(Field field, Object parent, String name, String description2, String category, String subcategory, int size) {
        super(field, parent, name, description2, category, subcategory, size);
    }

    public static ConfigCheckbox create(Field field, Object parent) {
        Checkbox checkbox = field.getAnnotation(Checkbox.class);
        return new ConfigCheckbox(field, parent, checkbox.name(), checkbox.description(), checkbox.category(), checkbox.subcategory(), checkbox.size());
    }

    @Override
    public void draw(long vg, int x, int y, InputHandler inputHandler) {
        boolean clicked;
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        if (!this.isEnabled()) {
            nanoVGHelper.setAlpha(vg, 0.5f);
        }
        boolean toggled = false;
        try {
            toggled = (Boolean)this.get();
            if (this.animation == null) {
                this.animation = new EaseInOutQuad(0, 0.0f, 1.0f, !toggled);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        boolean hover = inputHandler.isAreaHovered(x, y + 4, 24.0f, 24.0f);
        boolean bl = clicked = inputHandler.isClicked() && hover;
        if (clicked && this.isEnabled()) {
            toggled = !toggled;
            try {
                this.set(toggled);
            }
            catch (IllegalAccessException e) {
                System.err.println("failed to write config value: class=" + this + " fieldWatching=" + this.field + " valueWrite=" + toggled);
                e.printStackTrace();
            }
        }
        if (toggled == this.animation.isReversed()) {
            this.animation = new EaseInOutQuad(100, 0.0f, 1.0f, !toggled);
        }
        float percentOn = this.animation.get();
        nanoVGHelper.drawText(vg, this.name, x + 32, y + 17, this.nameColor, 14.0f, Fonts.MEDIUM);
        nanoVGHelper.drawRoundedRect(vg, x, y + 4, 24.0f, 24.0f, this.color.getColor(hover, hover && Platform.getMousePlatform().isButtonDown(0)), 6.0f);
        nanoVGHelper.drawHollowRoundRect(vg, x, y + 4, 23.5f, 23.5f, Colors.GRAY_300, 6.0f, 1.0f);
        nanoVGHelper.drawRoundedRect(vg, x, y + 4, 24.0f, 24.0f, ColorUtils.setAlpha(Colors.PRIMARY_500, (int)(percentOn * 255.0f)), 6.0f);
        nanoVGHelper.drawSvg(vg, SVGs.CHECKBOX_TICK, (float)x, (float)(y + 4), 24.0f, 24.0f, new Color(1.0f, 1.0f, 1.0f, percentOn).getRGB());
        if (toggled && hover) {
            nanoVGHelper.drawHollowRoundRect(vg, x - 1, y + 3, 24.0f, 24.0f, Colors.PRIMARY_600, 6.0f, 2.0f);
        }
        nanoVGHelper.setAlpha(vg, 1.0f);
    }

    @Override
    protected float getNameX(int x) {
        return x + 32;
    }

    @Override
    public int getHeight() {
        return 32;
    }
}

