/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements.config;

import cc.polyfrost.oneconfig.config.annotations.Button;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.gui.elements.BasicButton;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

public class ConfigButton
extends BasicOption {
    private final BasicButton button;

    public ConfigButton(Runnable runnable, Object parent, String name, String description2, String category, String subcategory, int size, String text) {
        super(null, parent, name, description2, category, subcategory, size);
        this.button = new BasicButton(size == 1 ? 128 : 256, 32, text, 2, ColorPalette.PRIMARY);
        this.button.setClickAction(runnable);
    }

    public ConfigButton(Field field, Object parent, String name, String description2, String category, String subcategory, int size, String text) {
        super(field, parent, name, description2, category, subcategory, size);
        this.button = new BasicButton(size == 1 ? 128 : 256, 32, text, 2, ColorPalette.PRIMARY);
        this.button.setClickAction(ConfigButton.getRunnableFromField(field, parent));
    }

    public ConfigButton(Method method, Object parent, String name, String description2, String category, String subcategory, int size, String text) {
        super(null, parent, name, description2, category, subcategory, size);
        this.button = new BasicButton(size == 1 ? 128 : 256, 32, text, 2, ColorPalette.PRIMARY);
        this.button.setClickAction(() -> {
            try {
                method.invoke(parent, new Object[0]);
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("wrong number of arguments")) {
                    throw new IllegalArgumentException("Button method " + method.getDeclaringClass().getName() + "." + method.getName() + "(" + Arrays.toString(method.getGenericParameterTypes()) + ") must take no arguments!");
                }
                e.printStackTrace();
            }
        });
    }

    public static ConfigButton create(Field field, Object parent) {
        Button button = field.getAnnotation(Button.class);
        return new ConfigButton(field, parent, button.name(), button.description(), button.category(), button.subcategory(), button.size(), button.text());
    }

    public static ConfigButton create(Method method, Object parent) {
        method.setAccessible(true);
        Button button = method.getAnnotation(Button.class);
        return new ConfigButton(method, parent, button.name(), button.description(), button.category(), button.subcategory(), button.size(), button.text());
    }

    private static Runnable getRunnableFromField(Field field, Object parent) {
        Runnable runnable = () -> {};
        try {
            runnable = (Runnable)field.get(parent);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return runnable;
    }

    @Override
    public void draw(long vg, int x, int y, InputHandler inputHandler) {
        this.button.disable(!this.isEnabled());
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        if (!this.isEnabled()) {
            nanoVGHelper.setAlpha(vg, 0.5f);
        }
        nanoVGHelper.drawText(vg, this.name, x, y + 17, this.nameColor, 14.0f, Fonts.MEDIUM);
        this.button.draw(vg, x + (this.size == 1 ? 352 : 736), y, inputHandler);
        nanoVGHelper.setAlpha(vg, 1.0f);
    }

    @Override
    public int getHeight() {
        return 32;
    }
}

