/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements;

import cc.polyfrost.oneconfig.config.data.Mod;
import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.gui.animations.ColorAnimation;
import cc.polyfrost.oneconfig.gui.elements.BasicButton;
import cc.polyfrost.oneconfig.gui.elements.BasicElement;
import cc.polyfrost.oneconfig.gui.pages.ModConfigPage;
import cc.polyfrost.oneconfig.gui.pages.ModsPage;
import cc.polyfrost.oneconfig.gui.pages.Page;
import cc.polyfrost.oneconfig.gui.pages.SubModsPage;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.assets.SVGs;
import cc.polyfrost.oneconfig.internal.config.OneConfigConfig;
import cc.polyfrost.oneconfig.internal.config.SubMainConfig;
import cc.polyfrost.oneconfig.internal.config.compatibility.forge.ForgeCompat;
import cc.polyfrost.oneconfig.internal.config.core.ConfigCore;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.renderer.scissor.Scissor;
import cc.polyfrost.oneconfig.renderer.scissor.ScissorHelper;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import cc.polyfrost.oneconfig.utils.color.ColorUtils;
import org.jetbrains.annotations.NotNull;

public class ModCard
extends BasicElement {
    private final Mod modData;
    private final BasicButton favoriteButton = new BasicButton(32, 32, SVGs.HEART_OUTLINE, 2, ColorPalette.TERTIARY);
    private final ColorAnimation colorFrame = new ColorAnimation(ColorPalette.SECONDARY);
    private final ColorAnimation colorToggle;
    private boolean active;
    private boolean disabled;
    private boolean favorite;
    private boolean isHoveredMain = false;
    private final ModsPage page;

    public ModCard(@NotNull Mod mod, boolean active, boolean disabled, boolean favorite, ModsPage page) {
        super(244, 119, false);
        this.modData = mod;
        this.active = active;
        this.toggled = active;
        this.colorToggle = new ColorAnimation(active ? ColorPalette.PRIMARY : ColorPalette.SECONDARY);
        this.disabled = disabled;
        this.favorite = favorite;
        this.favoriteButton.setToggled(favorite);
        this.toggled = active;
        this.page = page;
    }

    @Override
    public void draw(long vg, float x, float y, InputHandler inputHandler) {
        boolean isHoveredSecondary;
        super.update(x, y, inputHandler);
        ScissorHelper scissorHelper = ScissorHelper.INSTANCE;
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        String cleanName = this.modData.name.replaceAll("\u00a7.", "");
        Scissor scissor = scissorHelper.scissor(vg, x, y, this.width, this.height);
        this.isHoveredMain = inputHandler.isAreaHovered(x, y, this.width, 87.0f);
        boolean bl = isHoveredSecondary = inputHandler.isAreaHovered(x, y + 87.0f, this.width - 32, 32.0f) && !this.disabled;
        if (this.disabled) {
            nanoVGHelper.setAlpha(vg, 0.5f);
        }
        nanoVGHelper.drawRoundedRectVaried(vg, x, y, this.width, 87.0f, this.colorFrame.getColor(this.isHoveredMain, this.isHoveredMain && Platform.getMousePlatform().isButtonDown(0)), 12.0f, 12.0f, 0.0f, 0.0f);
        nanoVGHelper.drawRoundedRectVaried(vg, x, y + 87.0f, this.width, 32.0f, this.colorToggle.getColor(isHoveredSecondary, isHoveredSecondary && Platform.getMousePlatform().isButtonDown(0)), 0.0f, 0.0f, 12.0f, 12.0f);
        nanoVGHelper.drawLine(vg, x, y + 86.0f, x + (float)this.width, y + 86.0f, 2.0f, Colors.GRAY_300);
        this.drawIcon(nanoVGHelper, vg, x, y, cleanName);
        this.favoriteButton.draw(vg, x + 212.0f, y + 87.0f, inputHandler);
        this.favorite = this.favoriteButton.isToggled();
        if (this.favoriteButton.isClicked()) {
            if (this.favorite) {
                OneConfigConfig.favoriteMods.add(this.modData.name);
            } else {
                OneConfigConfig.favoriteMods.remove(this.modData.name);
            }
            ConfigCore.sortMods();
            this.page.reloadMods();
        }
        Scissor scissor2 = scissorHelper.scissor(vg, x, y + 87.0f, this.width - 32, 32.0f);
        nanoVGHelper.drawText(vg, cleanName, x + 12.0f, y + 103.0f, ColorUtils.setAlpha(Colors.WHITE, (int)(this.colorToggle.getAlpha() * 255.0f)), 14.0f, Fonts.MEDIUM);
        scissorHelper.resetScissor(vg, scissor2);
        if (this.favorite) {
            this.favoriteButton.setLeftIcon(SVGs.HEART_FILL);
        } else {
            this.favoriteButton.setLeftIcon(SVGs.HEART_OUTLINE);
        }
        if (this.clicked && this.isHoveredMain && !this.active) {
            this.toggled = false;
        }
        if (this.clicked && this.favoriteButton.hovered) {
            this.toggled = false;
        }
        if (this.clicked && !isHoveredSecondary && this.active) {
            this.toggled = true;
        }
        if (!this.active & this.disabled) {
            this.toggled = false;
        }
        if (this.active != this.toggled) {
            this.active = this.toggled;
            if (this.modData.config.canToggle) {
                this.colorToggle.setPalette(this.active ? ColorPalette.PRIMARY : ColorPalette.SECONDARY);
                this.modData.config.enabled = this.active;
                this.modData.config.save();
            } else {
                this.active = true;
                this.toggled = true;
            }
        }
        nanoVGHelper.setAlpha(vg, 1.0f);
        scissorHelper.resetScissor(vg, scissor);
    }

    protected void drawIcon(NanoVGHelper nanoVGHelper, long vg, float x, float y, String cleanName) {
        int height;
        int width = this.modData.iconWidth == -1 ? 56 : this.modData.iconWidth;
        int n = height = this.modData.iconHeight == -1 ? width : this.modData.iconHeight;
        if (this.modData.modIcon != null) {
            if (this.modData.modIcon.toLowerCase().endsWith(".svg")) {
                nanoVGHelper.drawSvg(vg, this.modData.modIcon, x + 122.0f - (float)width / 2.0f, y + 43.0f - (float)height / 2.0f, (float)width, (float)height);
            } else {
                nanoVGHelper.drawRoundImage(vg, this.modData.modIcon, x + 122.0f - (float)width / 2.0f, y + 43.0f - (float)height / 2.0f, (float)width, (float)height, 12.0f);
            }
        } else {
            nanoVGHelper.drawText(vg, cleanName, x + Math.max(0.0f, 244.0f - nanoVGHelper.getTextWidth(vg, cleanName, 16.0f, Fonts.MINECRAFT_BOLD)) / 2.0f, y + 44.0f, ColorUtils.setAlpha(Colors.WHITE, (int)(this.colorFrame.getAlpha() * 255.0f)), 16.0f, Fonts.MINECRAFT_BOLD);
        }
    }

    @Override
    public void onClick() {
        if (this.isHoveredMain) {
            Runnable runnable;
            if (this.modData instanceof ForgeCompat.ForgeCompatMod && (runnable = ForgeCompat.compatMods.get(this.modData)) != null) {
                runnable.run();
                return;
            }
            if (this.modData.config instanceof SubMainConfig) {
                ModConfigPage page = new ModConfigPage(ConfigCore.getParentMod((Mod)this.modData).defaultPage);
                page.setTitle("Settings");
                ModCard.open(page);
            } else if (ConfigCore.subMods.get(this.modData) != null) {
                ModCard.open(new SubModsPage(this.modData));
            } else {
                ModCard.open(new ModConfigPage(this.modData.defaultPage));
            }
        }
    }

    private static void open(Page page) {
        OneConfigGui.INSTANCE.openPage(page);
    }

    public Mod getModData() {
        return this.modData;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isFavorite() {
        return this.favorite;
    }
}

