/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements;

import cc.polyfrost.oneconfig.gui.animations.ColorAnimation;
import cc.polyfrost.oneconfig.gui.animations.EaseOutQuad;
import cc.polyfrost.oneconfig.gui.elements.BasicButton;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.assets.SVGs;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.asset.SVG;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import java.util.LinkedHashMap;
import java.util.Map;

public class Dropdown
extends BasicButton {
    private final LinkedHashMap<String, ColorAnimation> opts;
    private int selected;
    private float optsWidth = -1.0f;
    private float rotation;
    private final float xPadding;
    private final float fontSize;
    private EaseOutQuad anim = null;
    private InputHandler inputHandler;

    public Dropdown(int width, int size, int xPadding, String[] opts, int selected, ColorPalette palette) {
        super(width, size, (size - 8) / 2, 8, xPadding, opts[selected], null, SVGs.CHEVRON_DOWN, 0, palette);
        this.xPadding = xPadding;
        this.selected = selected;
        this.opts = new LinkedHashMap(opts.length);
        for (String opt : opts) {
            this.opts.put(opt, new ColorAnimation(palette == ColorPalette.TERTIARY ? ColorPalette.SECONDARY : palette));
        }
        this.fontSize = size == 48 ? 20.0f : (float)(size / 2 - 4);
    }

    @Override
    public void draw(long vg, float x, float y, InputHandler inputHandler) {
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        this.inputHandler = inputHandler;
        if (this.optsWidth == -1.0f) {
            for (String s2 : this.opts.keySet()) {
                this.optsWidth = Math.max(this.optsWidth, nanoVGHelper.getTextWidth(vg, s2, this.fontSize, Fonts.REGULAR));
            }
            this.optsWidth = Math.max(this.optsWidth, (float)this.width);
            this.width = (int)this.optsWidth;
        }
        if (this.toggled) {
            inputHandler.stopBlockingInput();
        }
        if (this.opts.size() != 1 && this.anim != null) {
            float val = this.anim.get();
            this.rotation = val / ((float)(this.opts.size() - 1) * this.fontSize * 2.0f) * 180.0f;
            nanoVGHelper.drawRoundedRect(vg, x, y + (float)this.height, this.optsWidth, val, this.colorPalette == ColorPalette.TERTIARY ? ColorPalette.SECONDARY.getNormalColor() : this.currentColor, 8.0f);
            if (this.anim.isFinished() && !this.anim.isReversed() && this.toggled) {
                float i = y + (float)this.height;
                int index2 = 0;
                for (Map.Entry<String, ColorAnimation> entry : this.opts.entrySet()) {
                    String s3 = entry.getKey();
                    ColorAnimation anim = entry.getValue();
                    if (index2 == this.selected) {
                        ++index2;
                        continue;
                    }
                    boolean hovered = inputHandler.isAreaHovered(x, i, this.optsWidth, 24.0f);
                    boolean clicked = hovered && inputHandler.isClicked(true);
                    nanoVGHelper.drawRoundedRect(vg, x, i, this.optsWidth, this.fontSize * 2.0f, anim.getColor(hovered, clicked), 8.0f);
                    nanoVGHelper.drawText(vg, s3, x + this.xPadding, i + this.fontSize, Colors.WHITE_90, this.fontSize, Fonts.REGULAR);
                    if (clicked) {
                        this.selected = index2;
                        this.onChange(this.selected);
                        this.text = s3;
                        this.toggled = false;
                    }
                    ++index2;
                    i += this.fontSize * 2.0f;
                }
            }
        }
        super.draw(vg, x, y, inputHandler);
        if (this.toggled) {
            inputHandler.blockAllInput();
        }
    }

    @Override
    public void setToggled(boolean toggled) {
        super.setToggled(toggled);
        if (!toggled) {
            this.inputHandler.blockAllInput();
        }
    }

    @Override
    public void drawIcon(long vg, SVG icon, float x, float y, float width, float height, int color) {
        if (this.rotation == 0.0f) {
            super.drawIcon(vg, icon, x, y, width, height, color);
            return;
        }
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        float xx = x + width / 2.0f;
        float yy = y + height / 2.0f;
        nanoVGHelper.translate(vg, xx, yy);
        nanoVGHelper.rotate(vg, this.rotation);
        nanoVGHelper.drawSvg(vg, icon, -(width / 2.0f), -(height / 2.0f), width, height, color);
        nanoVGHelper.rotate(vg, -this.rotation);
        nanoVGHelper.translate(vg, -xx, -yy);
    }

    @Override
    public void update(float x, float y, InputHandler inputHandler) {
        super.update(x, y, inputHandler);
        if (inputHandler.isClicked() && !inputHandler.isAreaHovered(x, y, this.optsWidth, this.height) && this.toggled) {
            this.toggled = false;
            inputHandler.stopBlockingInput();
        }
        if (this.toggled && this.anim == null) {
            this.anim = new EaseOutQuad(200, 0.0f, (float)(this.opts.size() - 1) * this.fontSize * 2.0f, false);
        }
        if (this.anim != null && this.anim.isFinished() && this.anim.isReversed()) {
            this.anim = null;
        }
        if (!this.toggled && this.anim != null && !this.anim.isReversed()) {
            this.anim = new EaseOutQuad(200, 0.0f, (float)(this.opts.size() - 1) * this.fontSize * 2.0f, true);
        }
    }

    public int getSelected() {
        return this.selected;
    }

    public void select(int index2) {
        this.selected = index2;
        this.text = (String)this.opts.keySet().toArray()[index2];
        this.onChange(index2);
    }

    public void onChange(int changedTo) {
    }
}

