/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.elements;

import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.gui.elements.BasicButton;
import cc.polyfrost.oneconfig.gui.elements.BasicElement;
import cc.polyfrost.oneconfig.gui.elements.Dropdown;
import cc.polyfrost.oneconfig.gui.elements.Slider;
import cc.polyfrost.oneconfig.gui.elements.text.TextInputField;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.assets.Images;
import cc.polyfrost.oneconfig.internal.assets.SVGs;
import cc.polyfrost.oneconfig.internal.config.OneConfigConfig;
import cc.polyfrost.oneconfig.libs.universal.UMouse;
import cc.polyfrost.oneconfig.libs.universal.UResolution;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.scissor.Scissor;
import cc.polyfrost.oneconfig.renderer.scissor.ScissorHelper;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import cc.polyfrost.oneconfig.utils.color.ColorUtils;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ColorSelector {
    private OneColor color;
    private static final BasicButton closeBtn = new BasicButton(32, 32, SVGs.X_CLOSE, 2, ColorPalette.TERTIARY_DESTRUCTIVE);
    private final BasicButton faveBtn = new BasicButton(32, 32, SVGs.HEART_OUTLINE, 2, ColorPalette.SECONDARY);
    private final BasicButton recentBtn = new BasicButton(32, 32, SVGs.HISTORY, 2, ColorPalette.SECONDARY){

        @Override
        public void onClick() {
            super.onClick();
            if (((ColorBox)ColorSelector.this.recentColors.get(0)).getColor().equals(ColorSelector.this.color)) {
                return;
            }
            ColorSelector.assignRecentColor(ColorSelector.this.color.clone());
            ColorSelector.this.recentColors.remove(5);
            ColorSelector.this.recentColors.add(0, new ColorBox(ColorSelector.this.color.clone()));
        }
    };
    private static final BasicButton pickerBtn = new BasicButton(32, 32, SVGs.PICKER, 2, ColorPalette.TERTIARY);
    private final Dropdown modeDropdown = new Dropdown(128, 36, 18, new String[]{"Solid Color", "Chroma"}, 0, ColorPalette.TERTIARY){

        @Override
        public void onChange(int changedTo) {
            switch (changedTo) {
                default: {
                    ColorSelector.this.picker = new SolidColorPicker();
                    break;
                }
                case 1: {
                    ColorSelector.this.picker = new ChromaColorPicker();
                }
            }
        }
    };
    private final Dropdown inputTypeDropdown = new Dropdown(90, 36, 20, new String[]{"HEX", "HSBA"}, 0, ColorPalette.TERTIARY){

        @Override
        public void onChange(int changedTo) {
            switch (changedTo) {
                default: {
                    ColorSelector.this.colorInput = new HexInput();
                    break;
                }
                case 1: {
                    ColorSelector.this.colorInput = new HSBAInput();
                }
            }
        }
    };
    private final ArrayList<ColorBox> favoriteColors = new ArrayList(6);
    private final ArrayList<ColorBox> recentColors = new ArrayList(6);
    private float x;
    private float y;
    private float dragX;
    private float dragY;
    @NotNull
    private ColorInput colorInput;
    @NotNull
    private ColorPicker picker;
    private static float width = 296.0f;
    private static float height = 398.0f;
    private boolean pickerIsActive;
    private boolean mouseWasDown;
    private boolean dragging;
    private final boolean hasAlpha;
    private Scissor inputScissor;
    private final InputHandler inputHandler;

    public ColorSelector(OneColor color, float mouseX, float mouseY, boolean hasAlpha, InputHandler inputHandler) {
        this.inputHandler = inputHandler;
        for (OneColor oo : OneConfigConfig.recentColors) {
            this.recentColors.add(new ColorBox(oo));
        }
        for (OneColor o : OneConfigConfig.favoriteColors) {
            this.favoriteColors.add(new ColorBox(o));
        }
        while (this.favoriteColors.size() < 6) {
            this.favoriteColors.add(new ColorBox(new OneColor(0, 0, 0, 0)));
        }
        while (this.recentColors.size() < 6) {
            this.recentColors.add(new ColorBox(new OneColor(0, 0, 0, 0)));
        }
        this.color = color;
        this.hasAlpha = hasAlpha;
        if (color.getDataBit() != -1) {
            this.modeDropdown.select(1);
        } else {
            this.picker = new SolidColorPicker();
        }
        this.x = mouseX - width / 2.0f;
        this.y = Math.max(0.0f, mouseY - height);
        this.colorInput = new HexInput();
    }

    public void draw(long vg) {
        boolean hovered;
        if (this.inputScissor != null) {
            this.inputHandler.stopBlock(this.inputScissor);
        }
        if (ColorSelector.pickerBtn.toggled) {
            this.inputHandler.blockAllInput();
            int color = NanoVGHelper.INSTANCE.readPixels((int)UMouse.Raw.getX(), UResolution.getViewportHeight() - (int)UMouse.Raw.getY(), 1, 1)[0];
            NanoVGHelper.INSTANCE.drawRoundedRect(vg, this.inputHandler.mouseX() - 16.0f, this.inputHandler.mouseY() - 33.0f, 32.0f, 32.0f, -1, 16.0f);
            NanoVGHelper.INSTANCE.drawRoundedRect(vg, this.inputHandler.mouseX() - 15.0f, this.inputHandler.mouseY() - 32.0f, 30.0f, 30.0f, color, 15.0f);
            if (this.inputHandler.isClicked(true)) {
                this.__setColor(new OneColor(color));
                ColorSelector.pickerBtn.toggled = false;
                this.inputHandler.stopBlockingInput();
            }
            return;
        }
        Scissor scissor = ScissorHelper.INSTANCE.scissor(vg, this.x - 3.0f, this.y - 3.0f, width + 6.0f, height + 6.0f);
        NanoVGHelper.INSTANCE.drawHollowRoundRect(vg, this.x - 3.0f, this.y - 3.0f, width + 3.0f, height + 3.0f, Colors.GRAY_700, 20.0f, 3.0f);
        NanoVGHelper.INSTANCE.drawRoundedRect(vg, this.x, this.y, width, height, Colors.GRAY_800, 20.0f);
        closeBtn.draw(vg, this.x + 248.0f + 8.0f, this.y + 12.0f, this.inputHandler);
        this.picker.drawAndUpdate(vg, this.x + 16.0f, this.y + 48.0f, this.inputHandler);
        if (this.modeDropdown.getSelected() == 1) {
            this.y += 20.0f;
            this.inputHandler.stopBlockingInput();
        }
        this.colorInput.drawAndUpdate(vg, this.x + 100.0f, this.y + 260.0f, this.inputHandler);
        pickerBtn.draw(vg, this.x + 252.0f, this.y + 260.0f, this.inputHandler);
        this.faveBtn.draw(vg, this.x + 12.0f, this.y + 304.0f, this.inputHandler);
        if (this.faveBtn.isClicked()) {
            this.favoriteColors.remove(5);
            this.favoriteColors.add(0, new ColorBox(this.color.clone()));
        }
        this.recentBtn.draw(vg, this.x + 12.0f, this.y + 348.0f, this.inputHandler);
        for (int i = 0; i < 6; ++i) {
            ColorBox box = this.favoriteColors.get(i);
            box.draw(vg, this.x + 52.0f + (float)(i * 40), this.y + 304.0f, this.inputHandler);
            if (box.isClicked()) {
                this.__setColor(box.getColor().clone());
            }
            ColorBox rBox = this.recentColors.get(i);
            rBox.draw(vg, this.x + 52.0f + (float)(i * 40), this.y + 348.0f, this.inputHandler);
            if (!rBox.isClicked()) continue;
            this.__setColor(rBox.getColor().clone());
        }
        this.inputTypeDropdown.draw(vg, this.x - 2.0f, this.y + 260.0f, this.inputHandler);
        if (this.modeDropdown.getSelected() == 1) {
            this.y -= 20.0f;
        }
        this.modeDropdown.draw(vg, this.x - 2.0f, this.y + 8.0f, this.inputHandler);
        boolean bl = hovered = Platform.getMousePlatform().isButtonDown(0) && this.inputHandler.isAreaHovered(this.x, this.y, width, 48.0f);
        if (hovered && Platform.getMousePlatform().isButtonDown(0) && !this.mouseWasDown) {
            this.dragging = true;
            this.dragX = this.inputHandler.mouseX() - this.x;
            this.dragY = this.inputHandler.mouseY() - this.y;
        }
        if (this.dragging) {
            this.x = this.inputHandler.mouseX() - this.dragX;
            this.y = this.inputHandler.mouseY() - this.dragY;
        }
        this.inputScissor = this.inputHandler.blockInputArea(this.x, this.y, width, height);
        if (closeBtn.isClicked() && !this.pickerIsActive) {
            OneConfigGui.INSTANCE.closeColorSelector();
        }
        ScissorHelper.INSTANCE.resetScissor(vg, scissor);
        if (this.dragging && this.inputHandler.isClicked(true)) {
            this.dragging = false;
        }
        if (this.pickerIsActive && this.inputHandler.isClicked(true)) {
            this.pickerIsActive = false;
        }
        this.mouseWasDown = Platform.getMousePlatform().isButtonDown(0);
    }

    public OneColor getColor() {
        return this.color;
    }

    public void keyTyped(char typedChar, int keyCode) {
        this.colorInput.keyTyped(typedChar, keyCode);
    }

    public void onClose() {
        this.inputHandler.stopBlockingInput();
        int i = 0;
        for (ColorBox box : this.favoriteColors) {
            if (box.isEmpty()) continue;
            ColorSelector.assignFavoriteColor(box.getColor().clone(), i);
            ++i;
        }
        ColorSelector.assignRecentColor(this.color.clone());
        OneConfigConfig.getInstance().save();
    }

    public static void assignRecentColor(OneColor color) {
        if (OneConfigConfig.recentColors.size() == 6) {
            OneConfigConfig.recentColors.remove(5);
            OneConfigConfig.recentColors.add(0, color);
        } else {
            OneConfigConfig.recentColors.add(color);
        }
    }

    public static void assignFavoriteColor(OneColor color, int index2) {
        if (index2 < 0) {
            index2 = 0;
        }
        if (index2 > 5) {
            index2 = 5;
        }
        if (index2 >= OneConfigConfig.favoriteColors.size()) {
            OneConfigConfig.favoriteColors.add(color);
        } else {
            OneConfigConfig.favoriteColors.set(index2, color);
        }
    }

    private void __setColor(OneColor color) {
        if (color.getRGB() == 0) {
            return;
        }
        this.color = color;
        this.picker.onColorChanged();
        this.colorInput.onColorChanged();
    }

    public boolean isAlphaAllowed() {
        return this.hasAlpha;
    }

    static final class ColorBox
    extends BasicElement {
        private OneColor color;

        public ColorBox(OneColor color) {
            super(32, 32, new ColorPalette(color.getRGB(), color.toJavaColor().brighter().getRGB(), ColorUtils.setAlpha(color.getRGB(), (int)((float)color.getAlpha() * 0.8f))), true);
            this.color = color;
        }

        @Override
        public void draw(long vg, float x, float y, InputHandler inputHandler) {
            NanoVGHelper.INSTANCE.drawRoundedRect(vg, x, y, 32.0f, 32.0f, Colors.GRAY_900, 8.0f);
            NanoVGHelper.INSTANCE.drawRoundedRect(vg, x, y, 32.0f, 32.0f, this.color.getRGB(), 8.0f);
            super.update(x, y, inputHandler);
        }

        public OneColor getColor() {
            return this.color;
        }

        public void setColor(OneColor color) {
            this.color = color;
        }

        public boolean isEmpty() {
            return this.color.getRGB() == 0;
        }
    }

    static final class ColorSlider
    extends Slider {
        private int gradColorStart;
        private int gradColorEnd;
        private final boolean img;

        public ColorSlider(int length, float min2, float max, float startValue, int gradColorStart, int gradColorEnd) {
            super(length, min2, max, startValue, 1);
            this.width = 16;
            this.dragPointerSize = this.width;
            if (gradColorEnd == 0 && gradColorStart == 0) {
                this.gradColorStart = 0;
                this.gradColorEnd = 0;
                this.img = true;
            } else {
                this.gradColorStart = gradColorStart;
                this.gradColorEnd = gradColorEnd;
                this.img = false;
            }
        }

        public ColorSlider(int length, float min2, float max, float startValue) {
            this(length, min2, max, startValue, 0, 0);
        }

        @Override
        public void draw(long vg, float x, float y, InputHandler inputHandler) {
            if (!this.disabled) {
                super.update(x, y, inputHandler);
            } else {
                NanoVGHelper.INSTANCE.setAlpha(vg, 0.5f);
            }
            if (this.img) {
                NanoVGHelper.INSTANCE.drawRoundImage(vg, Images.HUE_GRADIENT, x, y, (float)this.width, (float)this.height, 8.0f);
            } else {
                NanoVGHelper.INSTANCE.drawRoundImage(vg, Images.VERTICAL_ALPHA_GRID, x + 1.0f, y + 1.0f, (float)(this.width - 2), (float)(this.height - 2), 8.0f);
                NanoVGHelper.INSTANCE.drawGradientRoundedRect(vg, x, y, this.width, this.height, this.gradColorStart, this.gradColorEnd, 8.0f, NanoVGHelper.GradientDirection.DOWN);
            }
            NanoVGHelper.INSTANCE.drawHollowRoundRect(vg, x, this.currentDragPoint, this.width - 1, this.width - 1, Colors.WHITE, 8.0f, 1.0f);
            NanoVGHelper.INSTANCE.setAlpha(vg, 1.0f);
        }

        public void setGradient(int gradColorStart, int gradColorEnd) {
            if (this.img) {
                return;
            }
            this.gradColorEnd = gradColorEnd;
            this.gradColorStart = gradColorStart;
        }
    }

    private final class ChromaColorPicker
    implements ColorPicker {
        private float cursorX;
        private float cursorY;
        private final ColorSlider alphaSlider;
        private final Slider speedSlider = new Slider(200, 1.0f, 30.0f, 1.0f, 2);

        public ChromaColorPicker() {
            width = 296.0f;
            height = 408.0f;
            this.cursorX = (float)ColorSelector.this.color.getSaturation() / 100.0f * 200.0f;
            this.cursorY = (1.0f - (float)ColorSelector.this.color.getBrightness() / 100.0f) * 200.0f;
            this.alphaSlider = new ColorSlider(200, 0.0f, 255.0f, 255 - ColorSelector.this.color.getAlpha(), Colors.TRANSPARENT, ColorSelector.this.color.getRGBMax(true));
            if (ColorSelector.this.color.getDataBit() == -1) {
                ColorSelector.this.color.setChromaSpeed(30);
            }
            this.speedSlider.setValueInverted(ColorSelector.this.color.getDataBit());
            if (!ColorSelector.this.hasAlpha) {
                this.alphaSlider.disable(true);
            }
        }

        @Override
        public void drawAndUpdate(long vg, float x, float y, InputHandler inputHandler) {
            boolean hovered;
            this.speedSlider.draw(vg, x, y, inputHandler);
            NanoVGHelper.INSTANCE.drawHSBBox(vg, x, y += 20.0f, 200.0f, 200.0f, ColorSelector.this.color.getRGBMax(true));
            this.drawCursor(vg, x + this.cursorX, y + this.cursorY, ColorSelector.this.color.getRGB());
            this.alphaSlider.draw(vg, x + 216.0f, y, inputHandler);
            this.alphaSlider.setGradient(ColorSelector.this.color.getRGBNoAlpha(), Colors.TRANSPARENT);
            if (this.alphaSlider.isDragging() || this.speedSlider.isDragging()) {
                ColorSelector.this.color.setHSBA(ColorSelector.this.color.getHue(), ColorSelector.this.color.getSaturation(), ColorSelector.this.color.getBrightness(), (int)this.alphaSlider.getValueInverted());
                ColorSelector.this.color.setChromaSpeed(Math.round(this.speedSlider.getValueInverted()));
            }
            if (!ColorSelector.this.colorInput.isEditing()) {
                ColorSelector.this.colorInput.onColorChanged();
            }
            boolean bl = hovered = Platform.getMousePlatform().isButtonDown(0) && inputHandler.isAreaHovered(x, y, 200.0f, 200.0f);
            if (hovered && Platform.getMousePlatform().isButtonDown(0) && !ColorSelector.this.mouseWasDown) {
                ColorSelector.this.pickerIsActive = true;
            }
            if (!ColorSelector.this.pickerIsActive || ColorSelector.this.colorInput.isEditing()) {
                return;
            }
            this.cursorX = inputHandler.mouseX() - x;
            this.cursorY = inputHandler.mouseY() - y;
            if (this.cursorX < 0.0f) {
                this.cursorX = 0.0f;
            }
            if (this.cursorY < 0.0f) {
                this.cursorY = 0.0f;
            }
            if (this.cursorX > 200.0f) {
                this.cursorX = 200.0f;
            }
            if (this.cursorY > 200.0f) {
                this.cursorY = 200.0f;
            }
            float progressX = this.cursorX / 200.0f;
            float progressY = Math.abs(this.cursorY / 200.0f - 1.0f);
            ColorSelector.this.color.setHSBA(ColorSelector.this.color.getHue(), Math.round(progressX * 100.0f), Math.round(progressY * 100.0f), (int)this.alphaSlider.getValueInverted());
        }

        @Override
        public void onColorChanged() {
            this.cursorX = (float)ColorSelector.this.color.getSaturation() / 100.0f * 200.0f;
            this.cursorY = (1.0f - (float)ColorSelector.this.color.getBrightness() / 100.0f) * 200.0f;
            this.alphaSlider.setValueInverted(ColorSelector.this.color.getAlpha());
            this.alphaSlider.setGradient(ColorSelector.this.color.getRGBNoAlpha(), Colors.TRANSPARENT);
            this.speedSlider.setValueInverted(ColorSelector.this.color.getDataBit());
        }
    }

    private final class SolidColorPicker
    implements ColorPicker {
        private float cursorX;
        private float cursorY;
        private final ColorSlider alphaSlider;
        private final ColorSlider hueSlider;

        public SolidColorPicker() {
            width = 296.0f;
            height = 398.0f;
            this.cursorX = (float)ColorSelector.this.color.getSaturation() / 100.0f * 200.0f;
            this.cursorY = (1.0f - (float)ColorSelector.this.color.getBrightness() / 100.0f) * 200.0f;
            this.alphaSlider = new ColorSlider(200, 0.0f, 255.0f, 255 - ColorSelector.this.color.getAlpha(), Colors.TRANSPARENT, ColorSelector.this.color.getRGBMax(true));
            this.hueSlider = new ColorSlider(200, 0.0f, 360.0f, 360 - ColorSelector.this.color.getHue());
            ColorSelector.this.color.setChromaSpeed(-1);
            if (!ColorSelector.this.hasAlpha) {
                this.alphaSlider.disable(true);
            }
        }

        @Override
        public void drawAndUpdate(long vg, float x, float y, InputHandler inputHandler) {
            boolean hovered;
            NanoVGHelper.INSTANCE.drawHSBBox(vg, x, y, 200.0f, 200.0f, ColorSelector.this.color.getRGBMax(true));
            this.drawCursor(vg, x + this.cursorX, y + this.cursorY, ColorSelector.this.color.getRGB());
            this.hueSlider.draw(vg, x + 216.0f, y, inputHandler);
            this.alphaSlider.draw(vg, x + 248.0f, y, inputHandler);
            this.alphaSlider.setGradient(ColorSelector.this.color.getRGBNoAlpha(), Colors.TRANSPARENT);
            if (this.hueSlider.isDragging() || this.alphaSlider.isDragging()) {
                ColorSelector.this.color.setHSBA((int)this.hueSlider.getValueInverted(), ColorSelector.this.color.getSaturation(), ColorSelector.this.color.getBrightness(), (int)this.alphaSlider.getValueInverted());
                ColorSelector.this.colorInput.onColorChanged();
            }
            boolean bl = hovered = Platform.getMousePlatform().isButtonDown(0) && inputHandler.isAreaHovered(x, y, 200.0f, 200.0f);
            if (hovered && Platform.getMousePlatform().isButtonDown(0) && !ColorSelector.this.mouseWasDown) {
                ColorSelector.this.pickerIsActive = true;
            }
            if (!ColorSelector.this.pickerIsActive) {
                return;
            }
            this.cursorX = inputHandler.mouseX() - x;
            this.cursorY = inputHandler.mouseY() - y;
            if (this.cursorX < 0.0f) {
                this.cursorX = 0.0f;
            }
            if (this.cursorY < 0.0f) {
                this.cursorY = 0.0f;
            }
            if (this.cursorX > 200.0f) {
                this.cursorX = 200.0f;
            }
            if (this.cursorY > 200.0f) {
                this.cursorY = 200.0f;
            }
            float progressX = this.cursorX / 200.0f;
            float progressY = Math.abs(this.cursorY / 200.0f - 1.0f);
            ColorSelector.this.color.setHSBA((int)this.hueSlider.getValueInverted(), Math.round(progressX * 100.0f), Math.round(progressY * 100.0f), (int)this.alphaSlider.getValueInverted());
        }

        @Override
        public void onColorChanged() {
            this.cursorX = (float)ColorSelector.this.color.getSaturation() / 100.0f * 200.0f;
            this.cursorY = (1.0f - (float)ColorSelector.this.color.getBrightness() / 100.0f) * 200.0f;
            this.alphaSlider.setValueInverted(ColorSelector.this.color.getAlpha());
            this.hueSlider.setValueInverted(ColorSelector.this.color.getHue());
            this.alphaSlider.setGradient(ColorSelector.this.color.getRGBNoAlpha(), Colors.TRANSPARENT);
        }
    }

    static interface ColorPicker {
        public void drawAndUpdate(long var1, float var3, float var4, InputHandler var5);

        public void onColorChanged();

        default public void drawCursor(long vg, float cursorX, float cursorY, int color) {
            NanoVGHelper.INSTANCE.drawRoundedRect(vg, cursorX - 7.0f, cursorY - 7.0f, 14.0f, 14.0f, Colors.WHITE, 14.0f);
            NanoVGHelper.INSTANCE.drawRoundedRect(vg, cursorX - 5.0f, cursorY - 5.0f, 10.0f, 10.0f, color, 10.0f);
        }
    }

    final class HSBAInput
    implements ColorInput {
        final TextInputField[] inputs = new TextInputField[4];
        private boolean editing = false;

        HSBAInput() {
            for (int i = 0; i < this.inputs.length; ++i) {
                final int index2 = i;
                this.inputs[i] = new TextInputField(40, 32, true, 4.0f){

                    @Override
                    public void onClose() {
                        HSBAInput.this.inputs[index2].setInput(ColorSelector.this.color.getHSBA()[index2] + "");
                    }
                };
                this.inputs[i].setBoarderThickness(1.0f);
                this.inputs[i].setInput(ColorSelector.this.color.getHSBA()[i] + "");
            }
            if (!ColorSelector.this.hasAlpha) {
                this.inputs[3].disable(true);
            }
        }

        @Override
        public void drawAndUpdate(long vg, float x, float y, InputHandler inputHandler) {
            this.editing = false;
            for (int i = 0; i < 4; ++i) {
                TextInputField in = this.inputs[i];
                in.setErrored(false);
                in.draw(vg, x - 12.0f + (float)(42 * i), y, inputHandler);
                if (!in.isToggled()) continue;
                this.editing = true;
                ColorSelector.this.color.setHSBA(i, this.parseIntOrElse(in.getInput(), ColorSelector.this.color.getHSBA()[i]));
                ColorSelector.this.picker.onColorChanged();
            }
        }

        @Override
        public void onColorChanged() {
            this.inputs[0].setInput(ColorSelector.this.color.getHue() + "");
            this.inputs[1].setInput(ColorSelector.this.color.getSaturation() + "");
            this.inputs[2].setInput(ColorSelector.this.color.getBrightness() + "");
            this.inputs[3].setInput(ColorSelector.this.color.getAlpha() + "");
        }

        @Override
        public void keyTyped(char typedChar, int keyCode) {
            for (TextInputField i : this.inputs) {
                i.keyTyped(typedChar, keyCode);
            }
        }

        @Override
        public boolean isEditing() {
            return this.editing;
        }

        int parseIntOrElse(String s2, int orElse) {
            try {
                return Integer.parseInt(s2);
            }
            catch (Exception e) {
                return orElse;
            }
        }
    }

    final class HexInput
    implements ColorInput {
        private final TextInputField alphaInput = new TextInputField(56, 32, true, 4.0f){

            @Override
            public void onClose() {
                HexInput.this.alphaInput.setInput(Math.round((float)ColorSelector.this.color.getAlpha() / 2.55f) + "%");
            }
        };
        private final TextInputField hexInput = new TextInputField(80, 32, true, 4.0f){

            @Override
            public void onClose() {
                HexInput.this.hexInput.setInput("#" + ColorSelector.this.color.getHex());
            }
        };
        private boolean editing = false;

        public HexInput() {
            this.hexInput.setBoarderThickness(1.0f);
            this.alphaInput.setBoarderThickness(1.0f);
            this.hexInput.setInput("#" + ColorSelector.this.color.getHex());
            this.alphaInput.setInput(Math.round((float)ColorSelector.this.color.getAlpha() / 2.55f) + "%");
            if (!ColorSelector.this.hasAlpha) {
                this.alphaInput.disable(true);
            }
        }

        @Override
        public void drawAndUpdate(long vg, float x, float y, InputHandler inputHandler) {
            this.hexInput.draw(vg, x, y, inputHandler);
            this.alphaInput.draw(vg, x + 88.0f, y, inputHandler);
            this.hexInput.setErrored(false);
            this.alphaInput.setErrored(false);
            this.editing = false;
            if (this.hexInput.isToggled()) {
                this.editing = true;
                try {
                    ColorSelector.this.color.setColorFromHex(this.hexInput.getInput());
                    ColorSelector.this.picker.onColorChanged();
                }
                catch (Exception e) {
                    this.hexInput.setErrored(true);
                }
            }
            if (this.alphaInput.isToggled()) {
                this.editing = true;
                String s2 = this.alphaInput.getInput().endsWith("%") ? this.alphaInput.getInput().substring(0, this.alphaInput.getInput().length() - 1) : this.alphaInput.getInput();
                try {
                    ColorSelector.this.color.setAlpha(Math.round(Math.max(0.0f, Math.min(Float.parseFloat(s2), 100.0f)) * 2.55f));
                    ColorSelector.this.picker.onColorChanged();
                }
                catch (Exception e) {
                    this.alphaInput.setErrored(true);
                }
            }
        }

        @Override
        public void onColorChanged() {
            this.hexInput.setInput("#" + ColorSelector.this.color.getHex());
            this.alphaInput.setInput(Math.round((float)ColorSelector.this.color.getAlpha() / 2.55f) + "%");
        }

        @Override
        public void keyTyped(char typedChar, int keyCode) {
            this.hexInput.keyTyped(typedChar, keyCode);
            this.alphaInput.keyTyped(typedChar, keyCode);
        }

        @Override
        public boolean isEditing() {
            return this.editing;
        }
    }

    static interface ColorInput {
        public void drawAndUpdate(long var1, float var3, float var4, InputHandler var5);

        public void onColorChanged();

        public void keyTyped(char var1, int var2);

        public boolean isEditing();
    }
}

