/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui.animations;

import cc.polyfrost.oneconfig.gui.animations.Animation;

public class CubicBezier
extends Animation {
    private static final float CubicErrorBound = 0.001f;
    protected final float P0;
    protected final float P1;
    protected final float P2;
    protected final float P3;

    public CubicBezier(float P0, float P1, float P2, float P3, float duration, float start, float end, boolean reverse) {
        super(duration, start, end, reverse);
        this.P0 = P0;
        this.P1 = P1;
        this.P2 = P2;
        this.P3 = P3;
    }

    public CubicBezier(float[] points, float duration, float start, float end, boolean reverse) {
        this(points[0], points[1], points[2], points[3], duration, start, end, reverse);
    }

    @Override
    protected float animate(float x) {
        float start = 0.0f;
        float end = 1.0f;
        float midpoint;
        float estimate;
        while (!(Math.abs(x - (estimate = this.evaluateCubic(this.P0, this.P2, midpoint = (start + end) / 2.0f))) < 0.001f)) {
            if (estimate < x) {
                start = midpoint;
                continue;
            }
            end = midpoint;
        }
        return this.evaluateCubic(this.P1, this.P3, midpoint);
    }

    private float evaluateCubic(float a, float b, float m4) {
        return 3.0f * a * (1.0f - m4) * (1.0f - m4) * m4 + 3.0f * b * (1.0f - m4) * m4 * m4 + m4 * m4 * m4;
    }
}

