/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui;

import cc.polyfrost.oneconfig.gui.animations.Animation;
import cc.polyfrost.oneconfig.gui.animations.DummyAnimation;
import cc.polyfrost.oneconfig.gui.animations.EaseOutExpo;
import cc.polyfrost.oneconfig.gui.elements.BasicButton;
import cc.polyfrost.oneconfig.gui.pages.CreditsPage;
import cc.polyfrost.oneconfig.gui.pages.ModConfigPage;
import cc.polyfrost.oneconfig.gui.pages.ModsPage;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.assets.SVGs;
import cc.polyfrost.oneconfig.internal.config.Preferences;
import cc.polyfrost.oneconfig.internal.gui.HudGui;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import cc.polyfrost.oneconfig.utils.gui.GuiUtils;
import java.util.ArrayList;
import java.util.List;

public class SideBar {
    private final List<BasicButton> buttons = new ArrayList<BasicButton>(){
        {
            int width = 192;
            this.add(new BasicButton(width, 36, "Credits", SVGs.COPYRIGHT_FILL, null, 0, ColorPalette.TERTIARY));
            this.add(new BasicButton(width, 36, "Mods", SVGs.FADERS_HORIZONTAL_BOLD, null, 0, ColorPalette.PRIMARY));
            this.add(new BasicButton(width, 36, "Profiles", SVGs.USERS_02, null, 0, ColorPalette.TERTIARY));
            this.add(new BasicButton(width, 36, "Themes", SVGs.BRUSH, null, 0, ColorPalette.TERTIARY));
            this.add(new BasicButton(width, 36, "Preferences", SVGs.SETTINGS_02, null, 0, ColorPalette.TERTIARY));
        }
    };
    private final BasicButton hudButton = new BasicButton(192, 36, "Edit HUD", SVGs.LAYOUT_ALT, null, 0, ColorPalette.TERTIARY);
    private final BasicButton closeButton = new BasicButton(192, 36, "Close", SVGs.X_CLOSE, null, 0, ColorPalette.TERTIARY_DESTRUCTIVE);
    private int selected = 1;
    private Animation moveAnimation = null;
    private Animation sizeAnimation = null;
    private int y;
    private int sidebarY;

    public SideBar() {
        this.buttons.get(0).setClickAction(new CreditsPage());
        this.buttons.get(1).setClickAction(new ModsPage());
        this.buttons.get(4).setClickAction(new ModConfigPage(Preferences.getInstance().mod.defaultPage, true));
        this.hudButton.setClickAction(() -> GuiUtils.displayScreen((Object)new HudGui()));
        this.closeButton.setClickAction(GuiUtils::closeScreen);
        for (BasicButton button : this.buttons) {
            if (button.hasClickAction()) continue;
            button.disable(true);
        }
    }

    public void draw(long vg, int x, int y, InputHandler inputHandler) {
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        this.y = y;
        for (BasicButton button : this.buttons) {
            if (!button.isClicked()) continue;
            this.moveSideBar(button, false);
            break;
        }
        if (this.moveAnimation != null) {
            nanoVGHelper.drawRoundedRect(vg, x + 16, (float)y + this.moveAnimation.get() - (this.sizeAnimation.get() - 36.0f) / 2.0f, 192.0f, this.sizeAnimation.get(0.0f), Colors.PRIMARY_600, 12.0f);
            if (this.moveAnimation.isFinished() && this.sizeAnimation.isFinished()) {
                this.moveAnimation = null;
                this.sizeAnimation = null;
                this.buttons.get(this.selected).setColorPalette(ColorPalette.PRIMARY);
            }
        }
        this.sidebarY = y + 44;
        this.buttons.get(0).draw(vg, x + 16, this.calcAndIncrementLn(this.sidebarY), inputHandler);
        nanoVGHelper.drawText(vg, "MOD CONFIG", x + 16, this.calcAndIncrementLn(this.sidebarY + 26), Colors.WHITE_50, 12.0f, Fonts.SEMIBOLD);
        this.sidebarY -= 26;
        this.buttons.get(1).draw(vg, x + 16, this.calcAndIncrementLn(this.sidebarY), inputHandler);
        this.buttons.get(2).draw(vg, x + 16, this.calcAndIncrementLn(this.sidebarY), inputHandler);
        nanoVGHelper.drawText(vg, "PERSONALIZATION", x + 16, this.calcAndIncrementLn(this.sidebarY + 26), Colors.WHITE_50, 12.0f, Fonts.SEMIBOLD);
        this.sidebarY -= 26;
        this.buttons.get(3).draw(vg, x + 16, this.calcAndIncrementLn(this.sidebarY), inputHandler);
        this.buttons.get(4).draw(vg, x + 16, this.calcAndIncrementLn(this.sidebarY), inputHandler);
        this.sidebarY = 0;
        this.hudButton.draw(vg, x + 16, y + 704, inputHandler);
        this.closeButton.draw(vg, x + 16, y + 748, inputHandler);
    }

    public void pageOpened(String page) {
        this.pageOpened(page, false);
    }

    public void pageOpened(String page, boolean instant) {
        for (BasicButton button : this.buttons) {
            if (!button.getText().equalsIgnoreCase(page)) continue;
            this.moveSideBar(button, instant);
            return;
        }
    }

    private void moveSideBar(BasicButton button) {
        this.moveSideBar(button, false);
    }

    private void moveSideBar(BasicButton button, boolean instant) {
        if (button.equals(this.buttons.get(this.selected))) {
            return;
        }
        this.buttons.get(this.selected).setColorPalette(ColorPalette.TERTIARY);
        this.moveAnimation = instant ? new DummyAnimation(button.y - (float)this.y) : new EaseOutExpo(300, this.buttons.get((int)this.selected).y - (float)this.y, button.y - (float)this.y, false);
        this.sizeAnimation = new DummyAnimation(36.0f);
        this.selected = this.buttons.indexOf(button);
    }

    private int calcAndIncrementLn(int n) {
        this.sidebarY = n + 36;
        return this.sidebarY;
    }
}

