/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.gui;

import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.config.elements.OptionPage;
import cc.polyfrost.oneconfig.config.elements.OptionSubcategory;
import cc.polyfrost.oneconfig.events.EventManager;
import cc.polyfrost.oneconfig.events.event.RenderEvent;
import cc.polyfrost.oneconfig.events.event.Stage;
import cc.polyfrost.oneconfig.gui.GuiNotifications;
import cc.polyfrost.oneconfig.gui.SideBar;
import cc.polyfrost.oneconfig.gui.animations.Animation;
import cc.polyfrost.oneconfig.gui.animations.DummyAnimation;
import cc.polyfrost.oneconfig.gui.animations.EaseInBack;
import cc.polyfrost.oneconfig.gui.animations.EaseOutExpo;
import cc.polyfrost.oneconfig.gui.elements.BasicElement;
import cc.polyfrost.oneconfig.gui.elements.ColorSelector;
import cc.polyfrost.oneconfig.gui.elements.IFocusable;
import cc.polyfrost.oneconfig.gui.elements.text.TextInputField;
import cc.polyfrost.oneconfig.gui.pages.ModConfigPage;
import cc.polyfrost.oneconfig.gui.pages.ModsPage;
import cc.polyfrost.oneconfig.gui.pages.Page;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.internal.assets.SVGs;
import cc.polyfrost.oneconfig.internal.config.OneConfigConfig;
import cc.polyfrost.oneconfig.internal.config.Preferences;
import cc.polyfrost.oneconfig.libs.eventbus.Subscribe;
import cc.polyfrost.oneconfig.libs.universal.UKeyboard;
import cc.polyfrost.oneconfig.libs.universal.UResolution;
import cc.polyfrost.oneconfig.platform.Platform;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.renderer.scissor.Scissor;
import cc.polyfrost.oneconfig.renderer.scissor.ScissorHelper;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.MathUtils;
import cc.polyfrost.oneconfig.utils.color.ColorPalette;
import cc.polyfrost.oneconfig.utils.gui.GuiUtils;
import cc.polyfrost.oneconfig.utils.gui.OneUIScreen;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OneConfigGui
extends OneUIScreen {
    private static final InputHandler DUMMY_HANDLER = new InputHandler();
    public static OneConfigGui INSTANCE;
    private final SideBar sideBar = new SideBar();
    private final TextInputField textInputField = new TextInputField(248, 40, "Search...", false, false, SVGs.SEARCH_SM, 12.0f);
    private final ArrayList<Page> previousPages = new ArrayList();
    private final ArrayList<Page> nextPages = new ArrayList();
    private final BasicElement backArrow = new BasicElement(40, 40, ColorPalette.TERTIARY, true);
    private final BasicElement forwardArrow = new BasicElement(40, 40, ColorPalette.TERTIARY, true);
    public ColorSelector currentColorSelector;
    public boolean allowClose = true;
    protected Page currentPage;
    protected Page prevPage;
    private Animation pageAnimation;
    private long lastClosedTime = -1L;
    private Animation containerAnimation = new DummyAnimation(0.0f);
    public boolean isClosed = true;
    private boolean shouldDisplayHud = false;
    public float transparencyFactor = 0.0f;
    public float animationScaleFactor = 0.0f;
    private boolean isDrawing;

    public OneConfigGui() {
        if (INSTANCE != null) {
            EventManager.INSTANCE.unregister(INSTANCE);
        }
        INSTANCE = this;
        EventManager.INSTANCE.register(INSTANCE);
    }

    public OneConfigGui(Page page) {
        this();
        this.currentPage = page;
    }

    @Override
    public void initScreen(int width, int height) {
        super.initScreen(width, height);
        if (this.currentPage == null) {
            this.currentPage = new ModsPage();
            this.currentPage.parents.add(this.currentPage);
        }
        this.handleOpeningPage();
        if (Preferences.guiOpenAnimation) {
            this.shouldDisplayHud = false;
        }
    }

    private void handleOpeningPage() {
        boolean instant = !Preferences.showPageAnimationOnOpen;
        switch (Preferences.openingBehavior) {
            case 0: {
                if (this.currentPage instanceof ModsPage) break;
                this.previousPages.clear();
                this.openPage((Page)new ModsPage(), false, instant);
                break;
            }
            case 1: {
                ModConfigPage modConfigPage;
                OptionPage preferencesPage = Preferences.getInstance().mod.defaultPage;
                if (this.currentPage instanceof ModConfigPage && (modConfigPage = (ModConfigPage)this.currentPage).getPage() == preferencesPage) break;
                this.previousPages.clear();
                this.openPage((Page)new ModConfigPage(Preferences.getInstance().mod.defaultPage, true), false, instant);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.currentPage instanceof ModsPage) break;
                long current = System.currentTimeMillis();
                long diff = current - this.lastClosedTime;
                if (this.lastClosedTime == -1L || diff <= (long)Preferences.timeUntilReset * 1000L) break;
                this.previousPages.clear();
                this.openPage((Page)new ModsPage(), false, instant);
            }
        }
    }

    @Override
    public void draw(long vg, float partialTicks, InputHandler inputHandler) {
        boolean renderedInHud;
        this.isDrawing = true;
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        ScissorHelper scissorHelper = ScissorHelper.INSTANCE;
        boolean bl = renderedInHud = inputHandler == null;
        if (Preferences.guiOpenAnimation) {
            int animationTime = (int)(Preferences.animationTime * 1000.0f);
            if (renderedInHud && Preferences.guiClosingAnimation && this.shouldDisplayHud) {
                if (this.containerAnimation.getEnd() != 0.0f) {
                    switch (Preferences.animationType) {
                        case 0: {
                            this.containerAnimation = new EaseOutExpo(animationTime, MathUtils.clamp(this.animationScaleFactor - 0.9f, 0.0f, 0.1f), 0.0f, false);
                            break;
                        }
                        case 1: {
                            this.containerAnimation = new EaseInBack(animationTime, MathUtils.clamp(this.animationScaleFactor, 0.0f, 1.0f), 0.0f, false);
                        }
                    }
                }
            } else if (!renderedInHud && this.isClosed) {
                boolean forceFinished = this.containerAnimation.isFinished() && this.containerAnimation.getEnd() != 0.0f;
                switch (Preferences.animationType) {
                    case 0: {
                        this.containerAnimation = new EaseOutExpo(animationTime, MathUtils.clamp(forceFinished ? 0.1f : this.animationScaleFactor - 0.9f, 0.0f, 0.1f), 0.1f, false);
                        break;
                    }
                    case 1: {
                        this.containerAnimation = new EaseOutExpo(animationTime, MathUtils.clamp(forceFinished ? 1.0f : this.animationScaleFactor, 0.0f, 1.0f), 1.0f, false);
                    }
                }
                this.isClosed = false;
            }
        }
        float animationValue = Math.max(0.0f, Preferences.guiOpenAnimation ? this.containerAnimation.get() : 1.0f);
        switch (Preferences.animationType) {
            case 0: {
                this.animationScaleFactor = MathUtils.clamp(0.9f + animationValue, 0.9f, 1.0f);
                this.transparencyFactor = MathUtils.clamp(animationValue * 10.0f, 0.0f, 1.0f);
                break;
            }
            case 1: {
                this.animationScaleFactor = this.transparencyFactor = animationValue;
            }
        }
        nanoVGHelper.setAlpha(vg, this.transparencyFactor);
        if (OneConfigConfig.australia) {
            nanoVGHelper.translate(vg, UResolution.getWindowWidth(), UResolution.getWindowHeight());
            nanoVGHelper.rotate(vg, 180.0);
        }
        if (inputHandler == null) {
            inputHandler = DUMMY_HANDLER;
        }
        float scale = OneConfigGui.getScaleFactor() * this.animationScaleFactor;
        int x = (int)(((float)UResolution.getWindowWidth() - 1280.0f * scale) / 2.0f / scale);
        int y = (int)(((float)UResolution.getWindowHeight() - 800.0f * scale) / 2.0f / scale);
        nanoVGHelper.scale(vg, scale, scale);
        inputHandler.scale(scale, scale);
        nanoVGHelper.drawDropShadow(vg, x, y, 1280.0f, 800.0f, 64.0f, 0.0f, 20.0f);
        Scissor mainPanel = scissorHelper.scissor(vg, x, y, 224.0f, 800.0f);
        nanoVGHelper.drawRoundedRect(vg, x, y, 244.0f, 800.0f, Colors.GRAY_800_95, 20.0f);
        scissorHelper.resetScissor(vg, mainPanel);
        Scissor contentPanel = scissorHelper.scissor(vg, x + 224, y, 1056.0f, 800.0f);
        nanoVGHelper.drawRoundedRect(vg, x + 224 - 20, y, 1076.0f, 800.0f, Colors.GRAY_800, 20.0f);
        scissorHelper.resetScissor(vg, contentPanel);
        nanoVGHelper.drawLine(vg, x + 224, y + 72, x + 1280, y + 72, 1.0f, Colors.GRAY_700);
        nanoVGHelper.drawLine(vg, x + 224, y, x + 222, y + 800, 1.0f, Colors.GRAY_700);
        nanoVGHelper.drawSvg(vg, SVGs.ONECONFIG_FULL_DARK, (float)x + 33.0f, (float)y + 22.0f, 158.0f, 34.0f);
        this.textInputField.draw(vg, x + 1020, y + 16, inputHandler);
        this.sideBar.draw(vg, x, y, inputHandler);
        this.backArrow.update(x + 240, y + 16, inputHandler);
        this.forwardArrow.update(x + 280, y + 16, inputHandler);
        if (this.previousPages.size() == 0) {
            this.backArrow.disable(true);
            nanoVGHelper.setAlpha(vg, 0.5f);
        } else {
            this.backArrow.disable(false);
            if (!this.backArrow.isHovered() || Platform.getMousePlatform().isButtonDown(0)) {
                nanoVGHelper.setAlpha(vg, 0.8f);
            }
        }
        nanoVGHelper.drawSvg(vg, SVGs.ARROW_LEFT, (float)(x + 250), (float)(y + 26), 20.0f, 20.0f, this.backArrow.currentColor);
        nanoVGHelper.setAlpha(vg, 1.0f);
        if (this.nextPages.size() == 0) {
            this.forwardArrow.disable(true);
            nanoVGHelper.setAlpha(vg, 0.5f);
        } else {
            this.forwardArrow.disable(false);
            if (!this.forwardArrow.isHovered() || Platform.getMousePlatform().isButtonDown(0)) {
                nanoVGHelper.setAlpha(vg, 0.8f);
            }
        }
        nanoVGHelper.drawSvg(vg, SVGs.ARROW_RIGHT, (float)(x + 290), (float)(y + 26), 20.0f, 20.0f, this.forwardArrow.currentColor);
        nanoVGHelper.setAlpha(vg, 1.0f);
        this.handleHistoryMovement(this.backArrow.isClicked(), this.forwardArrow.isClicked());
        scissorHelper.scissor(vg, x + 224, y + 72, 1056.0f, 728.0f);
        Scissor blockedClicks = inputHandler.blockInputArea(x, y, 224.0f, 728.0f);
        if (this.prevPage != null && this.pageAnimation != null) {
            float pageProgress = this.pageAnimation.get(GuiUtils.getDeltaTime());
            if (!this.pageAnimation.isReversed()) {
                this.prevPage.scrollWithDraw(vg, (int)((float)x + pageProgress), y + 72, inputHandler);
                this.currentPage.scrollWithDraw(vg, (int)((float)(x - 1904) + pageProgress), y + 72, inputHandler);
            } else {
                this.prevPage.scrollWithDraw(vg, (int)((float)(x - 1904) + pageProgress), y + 72, inputHandler);
                this.currentPage.scrollWithDraw(vg, (int)((float)x + pageProgress), y + 72, inputHandler);
            }
            if (this.pageAnimation.isFinished()) {
                this.prevPage = null;
            }
        } else {
            this.currentPage.scrollWithDraw(vg, x + 224, y + 72, inputHandler);
        }
        scissorHelper.clearScissors(vg);
        inputHandler.stopBlock(blockedClicks);
        float breadcrumbX = x + 336;
        for (int i = 0; i < this.currentPage.parents.size(); ++i) {
            String title = this.currentPage.parents.get(i).getTitle();
            float width = nanoVGHelper.getTextWidth(vg, title, 24.0f, Fonts.SEMIBOLD);
            boolean hovered = inputHandler.isAreaHovered((int)breadcrumbX, y + 24, (int)width, 36.0f);
            int color = Colors.WHITE_60;
            if (i == this.currentPage.parents.size() - 1) {
                color = Colors.WHITE;
            } else if (hovered && !Platform.getMousePlatform().isButtonDown(0)) {
                color = Colors.WHITE_80;
            }
            nanoVGHelper.drawText(vg, title, breadcrumbX, y + 38, color, 24.0f, Fonts.SEMIBOLD);
            if (i != 0) {
                nanoVGHelper.drawSvg(vg, SVGs.CARET_RIGHT, breadcrumbX - 28.0f, (float)(y + 25), 24.0f, 24.0f, color);
            }
            if (hovered && inputHandler.isClicked()) {
                this.openPage(this.currentPage.parents.get(i));
            }
            breadcrumbX += width + 32.0f;
        }
        if (this.currentColorSelector != null) {
            this.currentColorSelector.draw(vg);
        }
        GuiNotifications.INSTANCE.draw(vg, x + 224 + 528, y + 720 + 72, inputHandler);
        nanoVGHelper.resetTransform(vg);
        this.isDrawing = false;
    }

    @Override
    public void onKeyPressed(int keyCode, char typedChar, @Nullable UKeyboard.Modifiers modifiers) {
        UKeyboard.allowRepeatEvents(true);
        try {
            if (this.allowClose) {
                super.onKeyPressed(keyCode, typedChar, modifiers);
            }
            this.textInputField.keyTyped(typedChar, keyCode);
            if (this.currentColorSelector != null) {
                this.currentColorSelector.keyTyped(typedChar, keyCode);
            }
            this.currentPage.keyTyped(typedChar, keyCode);
            if (this.textInputField.isToggled()) {
                return;
            }
            if (this.currentPage instanceof ModConfigPage) {
                ModConfigPage modConfigPage = (ModConfigPage)this.currentPage;
                for (OptionSubcategory subCategory : modConfigPage.getPage().categories.get((Object)modConfigPage.getSelectedCategory()).subcategories) {
                    for (BasicOption option : subCategory.options) {
                        if (!option.isEnabled() || !(option instanceof IFocusable) || !((IFocusable)((Object)option)).hasFocus()) continue;
                        return;
                    }
                }
            }
            if (!TextInputField.isAnySelected()) {
                this.handleHistoryMovement(keyCode == UKeyboard.KEY_LEFT, keyCode == UKeyboard.KEY_RIGHT);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void handleHistoryMovement(boolean back, boolean forward) {
        if (back && forward) {
            return;
        }
        try {
            if (back && this.previousPages.size() > 0) {
                this.nextPages.add(0, this.currentPage);
                this.openPage(this.previousPages.get(0), false);
                this.previousPages.remove(0);
            }
            if (forward && this.nextPages.size() > 0) {
                this.previousPages.add(0, this.currentPage);
                this.openPage(this.nextPages.get(0), new EaseOutExpo((int)Preferences.pageAnimationDuration * 1000, 224.0f, 2128.0f, true), false);
                this.nextPages.remove(0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void openPage(@NotNull Page page) {
        this.openPage(page, true);
    }

    public void openPage(@NotNull Page page, boolean addToPrevious) {
        this.openPage(page, new EaseOutExpo((int)(Preferences.pageAnimationDuration * 1000.0f), 224.0f, 2128.0f, false), addToPrevious);
    }

    private void openPage(@NotNull Page page, boolean addToPrevious, boolean instant) {
        if (instant) {
            this.openPageInstant(page, addToPrevious);
        } else {
            this.openPage(page, addToPrevious);
        }
    }

    private void openPageInstant(@NotNull Page page, boolean addToPrevious) {
        this.openPage(page, new DummyAnimation(2128.0f), addToPrevious);
    }

    public void openPage(@NotNull Page page, Animation animation, boolean addToPrevious) {
        if (!Preferences.showPageAnimations) {
            animation = new DummyAnimation(animation.getEnd());
        }
        if (page == this.currentPage) {
            return;
        }
        this.currentPage.finishUpAndClose();
        this.textInputField.setInput("");
        if (page.parents.size() == 0) {
            page.parents.addAll(this.currentPage.parents);
            if (!page.isBase()) {
                boolean alreadyInParents = false;
                for (int i = 0; i < page.parents.size(); ++i) {
                    Page parent = page.parents.get(i);
                    if (parent != page) continue;
                    alreadyInParents = true;
                    page.parents.subList(i + 1, page.parents.size()).clear();
                    break;
                }
                if (!alreadyInParents) {
                    page.parents.add(page);
                }
            } else {
                page.parents.clear();
                page.parents.add(page);
            }
        }
        this.sideBar.pageOpened(page.parents.get(0).getTitle(), animation instanceof DummyAnimation);
        if (addToPrevious) {
            this.previousPages.add(0, this.currentPage);
            this.nextPages.clear();
        }
        if (this.prevPage == null) {
            this.prevPage = this.currentPage;
        }
        this.currentPage = page;
        this.pageAnimation = animation;
    }

    public void initColorSelector(ColorSelector colorSelector) {
        if (this.currentColorSelector != null) {
            this.closeColorSelector();
        }
        this.currentColorSelector = colorSelector;
    }

    public OneColor closeColorSelector() {
        if (this.currentColorSelector == null) {
            return null;
        }
        this.currentColorSelector.onClose();
        OneColor color = this.currentColorSelector.getColor();
        this.currentColorSelector = null;
        return color;
    }

    public OneColor getColor() {
        if (this.currentColorSelector == null) {
            return null;
        }
        return this.currentColorSelector.getColor();
    }

    public static float getScaleFactor() {
        float scale;
        float f = scale = Preferences.enableCustomScale ? Preferences.customScale : Math.min((float)UResolution.getWindowWidth() / 1920.0f, (float)UResolution.getWindowHeight() / 1080.0f);
        if (scale < 1.0f && !Preferences.enableCustomScale) {
            scale = Math.min(Math.min(1.0f, (float)UResolution.getWindowWidth() / 1280.0f), Math.min(1.0f, (float)UResolution.getWindowHeight() / 800.0f));
        }
        return (float)(Math.floor(scale / 0.05f) * (double)0.05f);
    }

    public String getSearchValue() {
        return this.textInputField.getInput();
    }

    @Override
    public void onScreenClose() {
        this.currentPage.finishUpAndClose();
        this.lastClosedTime = System.currentTimeMillis();
        this.isClosed = true;
        if (Preferences.guiOpenAnimation) {
            if (Preferences.guiClosingAnimation) {
                this.shouldDisplayHud = true;
            } else {
                this.transparencyFactor = 0.0f;
                this.animationScaleFactor = 0.0f;
            }
        }
        super.onScreenClose();
    }

    @Subscribe
    private void onRenderHUD(RenderEvent event) {
        if (!this.shouldDisplayHud || event.stage == Stage.START) {
            return;
        }
        if (Platform.getGuiPlatform().getCurrentScreen() == this) {
            return;
        }
        NanoVGHelper.INSTANCE.setupAndDraw(vg -> this.draw(vg, event.deltaTicks, null));
        if ((double)this.transparencyFactor <= 0.01) {
            this.shouldDisplayHud = false;
        }
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    @Override
    public boolean hasBackgroundBlur() {
        return Preferences.enableBlur;
    }

    public boolean isDrawing() {
        return this.isDrawing;
    }

    public static OneConfigGui create() {
        return INSTANCE == null ? new OneConfigGui() : INSTANCE;
    }

    public static boolean isOpen() {
        return Platform.getGuiPlatform().getCurrentScreen() instanceof OneConfigGui;
    }

    static {
        DUMMY_HANDLER.blockAllInput();
    }
}

