/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.events;

import cc.polyfrost.oneconfig.config.core.exceptions.InvalidTypeException;
import cc.polyfrost.oneconfig.libs.eventbus.EventBus;
import cc.polyfrost.oneconfig.libs.eventbus.exception.ExceptionHandler;
import cc.polyfrost.oneconfig.libs.eventbus.invokers.LMFInvoker;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class EventManager {
    public static final EventManager INSTANCE = new EventManager();
    private static final Logger LOGGER = LogManager.getLogger((String)"OneConfig/EventManager");
    private final EventBus eventBus = new EventBus(new LMFInvoker(), new OneConfigExceptionHandler());
    private final Set<Object> listeners = new HashSet<Object>();

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public void register(Object object) {
        if (this.listeners.add(object)) {
            this.eventBus.register(object);
        } else {
            LOGGER.warn("Attempted to register an already registered listener: " + object);
        }
    }

    public void unregister(Object object) {
        this.listeners.remove(object);
        this.eventBus.unregister(object);
    }

    public void post(Object event) {
        this.eventBus.post(event);
    }

    private static class OneConfigExceptionHandler
    implements ExceptionHandler {
        private OneConfigExceptionHandler() {
        }

        @Override
        public void handle(@NotNull Exception e) {
            if (e instanceof InvalidTypeException) {
                throw (InvalidTypeException)e;
            }
            if (e instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e;
            }
            e.printStackTrace();
        }
    }
}

