/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.config.migration;

import cc.polyfrost.oneconfig.config.migration.JsonName;
import cc.polyfrost.oneconfig.config.migration.Migrator;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonMigrator
implements Migrator {
    protected JsonObject object;
    protected HashMap<String, Object> values = null;

    public JsonMigrator(String filePath) {
        File file = new File(filePath);
        try {
            JsonElement element = new JsonParser().parse((Reader)new FileReader(file));
            this.object = element.isJsonObject() ? element.getAsJsonObject() : null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.object = null;
        }
    }

    @Override
    public Object getValue(Field field, @Nullable String name, @Nullable String category, @Nullable String subcategory) {
        String key;
        if (this.object == null) {
            return null;
        }
        if (this.values == null) {
            this.generateValues();
        }
        if (field.isAnnotationPresent(JsonName.class)) {
            JsonName annotation = field.getAnnotation(JsonName.class);
            key = annotation.value();
        } else {
            key = field.getName();
        }
        return this.values.get(this.parse(key));
    }

    protected String parse(@NotNull String value) {
        if (value.startsWith("/") || value.startsWith(".")) {
            value = value.substring(1);
        }
        return value.replaceAll("/", ".");
    }

    protected void generateValues() {
        this.values = new HashMap();
        if (this.object == null) {
            return;
        }
        if (!this.object.isJsonObject()) {
            return;
        }
        for (Map.Entry master : this.object.entrySet()) {
            if (!((JsonElement)master.getValue()).isJsonObject()) continue;
            this.loopThroughChildren((String)master.getKey(), ((JsonElement)master.getValue()).getAsJsonObject());
        }
    }

    protected void loopThroughChildren(String path, JsonObject in) {
        for (Map.Entry element : in.entrySet()) {
            String thisPath = path + "." + (String)element.getKey();
            if (((JsonElement)element.getValue()).isJsonObject()) {
                this.loopThroughChildren(thisPath, ((JsonElement)element.getValue()).getAsJsonObject());
                continue;
            }
            this.put(thisPath, (JsonElement)element.getValue());
        }
    }

    protected void put(String key, JsonElement val) {
        if (val.isJsonNull()) {
            this.values.put(key, null);
        } else if (val.isJsonPrimitive()) {
            this.values.put(key, this.cast(val.getAsJsonPrimitive()));
        } else if (val.isJsonArray()) {
            JsonArray array = val.getAsJsonArray();
            Iterator iterator2 = array.iterator();
            Object[] objects = new Object[array.size()];
            int i = 0;
            while (iterator2.hasNext()) {
                objects[i] = this.cast(((JsonElement)iterator2.next()).getAsJsonPrimitive());
            }
            this.values.put(key, objects);
        } else {
            this.values.put(key, val);
        }
    }

    private Object cast(JsonPrimitive primitive) {
        if (primitive.isJsonNull()) {
            return null;
        }
        if (primitive.isBoolean()) {
            return primitive.getAsBoolean();
        }
        if (primitive.isNumber()) {
            Number number = primitive.getAsNumber();
            if (number.floatValue() % 1.0f != 0.0f) {
                return Float.valueOf(number.floatValue());
            }
            return number.intValue();
        }
        return primitive.getAsString();
    }
}

