/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.config.migration;

import cc.polyfrost.oneconfig.config.migration.CfgName;
import cc.polyfrost.oneconfig.config.migration.Migrator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CfgMigrator
implements Migrator {
    final String filePath;
    final boolean fileExists;
    HashMap<String, HashMap<String, Object>> values;
    final Pattern stringOrFloatPattern = Pattern.compile("S:(?<name>\\S+)=(?<value>\\S+)");
    final Pattern intPattern = Pattern.compile("I:(?<name>\\S+)=(?<value>\\S+)");
    final Pattern doublePattern = Pattern.compile("D:(?<name>\\S+)=(?<value>\\S+)");
    final Pattern booleanPattern = Pattern.compile("B:(?<name>\\S+)=(?<value>\\S+)");
    final Pattern listPattern = Pattern.compile("S:(?<name>\\S+)\\s<");
    final Pattern categoryPattern = Pattern.compile("(?<name>\\S+)\\s\\Q{");

    public CfgMigrator(String filePath) {
        this.filePath = filePath;
        this.fileExists = new File(filePath).exists();
    }

    @Override
    @Nullable
    public Object getValue(Field field, @NotNull String name, @Nullable String category, @Nullable String subcategory) {
        if (!this.fileExists) {
            return null;
        }
        if (this.values == null) {
            this.generateValues();
        }
        if (field.isAnnotationPresent(CfgName.class)) {
            CfgName annotation = field.getAnnotation(CfgName.class);
            name = annotation.name();
            category = annotation.category();
        }
        name = this.parse(name);
        if (category == null) {
            if (subcategory != null) {
                category = this.parse(subcategory);
            }
        } else {
            category = this.parse(category);
        }
        return this.values.getOrDefault(category, new HashMap()).getOrDefault(name, null);
    }

    protected void generateValues() {
        if (this.values == null) {
            this.values = new HashMap();
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.filePath));){
            String line;
            String currentCategory = null;
            while ((line = reader.readLine()) != null) {
                Matcher booleanMatcher;
                Matcher categoryMatcher = this.categoryPattern.matcher(line);
                if (categoryMatcher.find() && !this.values.containsKey(currentCategory = categoryMatcher.group("name"))) {
                    this.values.put(currentCategory, new HashMap());
                }
                if (currentCategory == null) continue;
                if (line.contains("\"")) {
                    line = line.replaceAll("\"", "").replaceAll(" ", "");
                }
                if ((booleanMatcher = this.booleanPattern.matcher(line)).find()) {
                    this.values.get(currentCategory).put(booleanMatcher.group("name"), Boolean.parseBoolean(booleanMatcher.group("value")));
                    continue;
                }
                Matcher intMatcher = this.intPattern.matcher(line);
                if (intMatcher.find()) {
                    this.values.get(currentCategory).put(intMatcher.group("name"), Integer.parseInt(intMatcher.group("value")));
                    continue;
                }
                Matcher doubleMatcher = this.doublePattern.matcher(line);
                if (doubleMatcher.find()) {
                    this.values.get(currentCategory).put(doubleMatcher.group("name"), Double.parseDouble(doubleMatcher.group("value")));
                    continue;
                }
                Matcher stringOrFloatMatcher = this.stringOrFloatPattern.matcher(line.trim());
                if (stringOrFloatMatcher.matches()) {
                    if (line.contains(".")) {
                        try {
                            this.values.get(currentCategory).put(stringOrFloatMatcher.group("name"), Float.valueOf(Float.parseFloat(stringOrFloatMatcher.group("value"))));
                        }
                        catch (Exception ignored) {
                            this.values.get(currentCategory).put(stringOrFloatMatcher.group("name"), stringOrFloatMatcher.group("value"));
                        }
                    }
                    this.values.get(currentCategory).put(stringOrFloatMatcher.group("name"), stringOrFloatMatcher.group("value"));
                    continue;
                }
                Matcher listMatcher = this.listPattern.matcher(line.trim());
                if (!listMatcher.matches()) continue;
                String name = listMatcher.group("name");
                ArrayList<String> list = new ArrayList<String>();
                while ((line = reader.readLine()) != null && !line.contains(">")) {
                    list.add(line.trim());
                }
                String[] array = new String[list.size()];
                list.toArray(array);
                this.values.get(currentCategory).put(name, array);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NotNull
    protected String parse(@NotNull String value) {
        if (value.contains("\"")) {
            return value.replaceAll("\"", "").replaceAll(" ", "");
        }
        return value;
    }
}

