/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.config.elements;

import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigPageButton;
import cc.polyfrost.oneconfig.internal.assets.Colors;
import cc.polyfrost.oneconfig.renderer.NanoVGHelper;
import cc.polyfrost.oneconfig.renderer.font.Fonts;
import cc.polyfrost.oneconfig.utils.InputHandler;
import cc.polyfrost.oneconfig.utils.SearchUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class OptionSubcategory {
    private final String name;
    public ArrayList<BasicOption> options = new ArrayList();
    public ArrayList<ConfigPageButton> topButtons = new ArrayList();
    public ArrayList<ConfigPageButton> bottomButtons = new ArrayList();
    private List<BasicOption> filteredOptions = new ArrayList<BasicOption>();
    private int drawLastY;
    private final String category;

    public OptionSubcategory(String name, String category) {
        this.name = name;
        this.category = category;
    }

    public int draw(long vg, int x, int y, InputHandler inputHandler) {
        NanoVGHelper nanoVGHelper = NanoVGHelper.INSTANCE;
        String filter2 = OneConfigGui.INSTANCE == null ? "" : OneConfigGui.INSTANCE.getSearchValue().toLowerCase().trim();
        boolean shouldNotFilter = filter2.equals("") || SearchUtils.isSimilar(this.category, filter2) || SearchUtils.isSimilar(this.name, filter2);
        this.filteredOptions = this.options.stream().filter(option -> !option.isHidden() && (shouldNotFilter || SearchUtils.isSimilar(option.name, filter2))).collect(Collectors.toList());
        List filteredTop = this.topButtons.stream().filter(page -> !page.isHidden() && (shouldNotFilter || SearchUtils.isSimilar(page.name, filter2) || SearchUtils.isSimilar(page.description, filter2))).collect(Collectors.toList());
        List filteredBottom = this.bottomButtons.stream().filter(page -> !page.isHidden() && (shouldNotFilter || SearchUtils.isSimilar(page.name, filter2) || SearchUtils.isSimilar(page.description, filter2))).collect(Collectors.toList());
        if (this.filteredOptions.size() == 0 && filteredTop.size() == 0 && filteredBottom.size() == 0) {
            return 0;
        }
        int optionY = y;
        if (!this.name.equals("")) {
            nanoVGHelper.drawText(vg, this.name, x, y + 12, Colors.WHITE_90, 24.0f, Fonts.MEDIUM);
            optionY += 36;
        }
        for (ConfigPageButton page2 : filteredTop) {
            page2.draw(vg, x, optionY, inputHandler);
            optionY += page2.getHeight() + 16;
        }
        if (this.filteredOptions.size() > 0) {
            int backgroundSize = 16;
            for (int i = 0; i < this.filteredOptions.size(); ++i) {
                BasicOption option2 = this.filteredOptions.get(i);
                if (i + 1 < this.filteredOptions.size()) {
                    BasicOption nextOption = this.filteredOptions.get(i + 1);
                    if (option2.size == 1 && nextOption.size == 1) {
                        backgroundSize += Math.max(option2.getHeight(), nextOption.getHeight()) + 16;
                        ++i;
                        continue;
                    }
                }
                backgroundSize += option2.getHeight() + 16;
            }
            nanoVGHelper.drawRoundedRect(vg, x - 16, optionY, 1024.0f, backgroundSize, Colors.GRAY_900, 20.0f);
            optionY += 16;
        }
        this.drawLastY = optionY;
        if (this.filteredOptions.size() > 0) {
            for (int i = 0; i < this.filteredOptions.size(); ++i) {
                BasicOption option3 = this.filteredOptions.get(i);
                option3.draw(vg, x, optionY, inputHandler);
                if (i + 1 < this.filteredOptions.size()) {
                    BasicOption nextOption = this.filteredOptions.get(i + 1);
                    if (option3.size == 1 && nextOption.size == 1) {
                        nextOption.draw(vg, x + 512, optionY, inputHandler);
                        optionY += Math.max(option3.getHeight(), nextOption.getHeight()) + 16;
                        ++i;
                        continue;
                    }
                }
                optionY += option3.getHeight() + 16;
            }
            optionY += 16;
        }
        for (ConfigPageButton page3 : filteredBottom) {
            page3.draw(vg, x, optionY, inputHandler);
            optionY += page3.getHeight() + 16;
        }
        return optionY - y;
    }

    public void drawLast(long vg, int x, InputHandler inputHandler) {
        for (int i = 0; i < this.filteredOptions.size(); ++i) {
            BasicOption option = this.filteredOptions.get(i);
            option.drawLast(vg, x, this.drawLastY, inputHandler);
            if (i + 1 < this.filteredOptions.size()) {
                BasicOption nextOption = this.filteredOptions.get(i + 1);
                if (option.size == 1 && nextOption.size == 1) {
                    nextOption.drawLast(vg, x + 512, this.drawLastY, inputHandler);
                    this.drawLastY += Math.max(option.getHeight(), nextOption.getHeight()) + 16;
                    ++i;
                    continue;
                }
            }
            this.drawLastY += option.getHeight() + 16;
        }
    }

    public String getName() {
        return this.name;
    }
}

