/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.config.core;

import cc.polyfrost.oneconfig.libs.universal.UKeyboard;
import cc.polyfrost.oneconfig.platform.Platform;
import java.util.ArrayList;

public class OneKeyBind {
    protected final ArrayList<Integer> keyBinds = new ArrayList();
    protected transient Runnable runnable;
    protected transient boolean hasRun;

    public OneKeyBind(boolean mouse, int ... keys2) {
        for (int key : keys2) {
            this.keyBinds.add(mouse ? key - 100 : key);
        }
    }

    public OneKeyBind(int ... keys2) {
        this(false, keys2);
    }

    public OneKeyBind() {
    }

    public boolean isActive() {
        if (this.keyBinds.size() == 0) {
            return false;
        }
        for (int keyBind : this.keyBinds) {
            if (UKeyboard.isKeyDown(Platform.getInstance().getMinecraftVersion() >= 11300 && keyBind < 0 ? keyBind + 100 : keyBind)) continue;
            this.hasRun = false;
            return false;
        }
        return true;
    }

    public void run() {
        if (this.runnable == null || this.hasRun) {
            return;
        }
        this.runnable.run();
        this.hasRun = true;
    }

    public String getDisplay() {
        StringBuilder sb = new StringBuilder();
        for (int keyBind : this.keyBinds) {
            if (sb.length() != 0) {
                sb.append(" + ");
            }
            sb.append(Platform.getI18nPlatform().getKeyName(Platform.getInstance().getMinecraftVersion() >= 11300 ? keyBind + 100 : keyBind, -1));
        }
        return sb.toString().trim();
    }

    public void addKey(int key) {
        this.addKey(key, false);
    }

    public void addKey(int key, boolean mouse) {
        if (this.keyBinds.contains(key)) {
            return;
        }
        this.keyBinds.add(mouse ? key - 100 : key);
    }

    public void clearKeys() {
        this.keyBinds.clear();
    }

    public int getSize() {
        return this.keyBinds.size();
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public ArrayList<Integer> getKeyBinds() {
        return this.keyBinds;
    }
}

