/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.config.core;

import cc.polyfrost.oneconfig.config.core.OneColor;
import cc.polyfrost.oneconfig.config.core.OneKeyBind;
import cc.polyfrost.oneconfig.config.core.exceptions.InvalidTypeException;
import cc.polyfrost.oneconfig.config.data.OptionType;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.config.elements.OptionCategory;
import cc.polyfrost.oneconfig.config.elements.OptionPage;
import cc.polyfrost.oneconfig.config.elements.OptionSubcategory;
import cc.polyfrost.oneconfig.config.migration.Migrator;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigButton;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigCheckbox;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigColorElement;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigDropdown;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigDualOption;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigHeader;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigInfo;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigKeyBind;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigNumber;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigSlider;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigSwitch;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigTextBox;
import cc.polyfrost.oneconfig.internal.config.annotations.Option;
import cc.polyfrost.oneconfig.internal.config.profiles.Profiles;
import com.google.gson.FieldAttributes;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class ConfigUtils {
    public static BasicOption getOption(Option option, Field field, Object instance) {
        switch (option.type()) {
            case SWITCH: {
                ConfigUtils.check(OptionType.SWITCH.toString(), field, Boolean.TYPE, Boolean.class);
                return ConfigSwitch.create(field, instance);
            }
            case CHECKBOX: {
                ConfigUtils.check(OptionType.CHECKBOX.toString(), field, Boolean.TYPE, Boolean.class);
                return ConfigCheckbox.create(field, instance);
            }
            case INFO: {
                return ConfigInfo.create(field, instance);
            }
            case HEADER: {
                return ConfigHeader.create(field, instance);
            }
            case COLOR: {
                ConfigUtils.check(OptionType.COLOR.toString(), field, OneColor.class);
                return ConfigColorElement.create(field, instance);
            }
            case DROPDOWN: {
                ConfigUtils.check(OptionType.DROPDOWN.toString(), field, Integer.TYPE, Integer.class);
                return ConfigDropdown.create(field, instance);
            }
            case TEXT: {
                ConfigUtils.check(OptionType.TEXT.toString(), field, String.class);
                return ConfigTextBox.create(field, instance);
            }
            case BUTTON: {
                ConfigUtils.check(OptionType.BUTTON.toString(), field, Runnable.class);
                return ConfigButton.create(field, instance);
            }
            case SLIDER: {
                ConfigUtils.check(OptionType.SLIDER.toString(), field, Integer.TYPE, Float.TYPE, Integer.class, Float.class);
                return ConfigSlider.create(field, instance);
            }
            case NUMBER: {
                ConfigUtils.check(OptionType.NUMBER.toString(), field, Integer.TYPE, Float.TYPE, Integer.class, Float.class);
                return ConfigNumber.create(field, instance);
            }
            case KEYBIND: {
                ConfigUtils.check(OptionType.KEYBIND.toString(), field, OneKeyBind.class);
                return ConfigKeyBind.create(field, instance);
            }
            case DUAL_OPTION: {
                ConfigUtils.check(OptionType.DUAL_OPTION.toString(), field, Boolean.TYPE, Boolean.class);
                return ConfigDualOption.create(field, instance);
            }
        }
        return null;
    }

    public static void check(String type2, Field field, Class<?> ... expectedType) {
        for (Class<?> clazz : expectedType) {
            if (!clazz.isAssignableFrom(field.getType())) continue;
            return;
        }
        throw new InvalidTypeException("Field " + field.getName() + " in config " + field.getDeclaringClass().getName() + " is annotated as a " + type2 + ", but is not of valid type, expected " + Arrays.toString(expectedType) + " (found " + field.getType() + ")");
    }

    public static ArrayList<BasicOption> getClassOptions(Object object) {
        ArrayList<BasicOption> options = new ArrayList<BasicOption>();
        ArrayList<Field> fields2 = ConfigUtils.getClassFields(object.getClass());
        for (Field field : fields2) {
            Option option = ConfigUtils.findAnnotation(field, Option.class);
            if (option == null) continue;
            options.add(ConfigUtils.getOption(option, field, object));
        }
        return options;
    }

    public static ArrayList<Field> getClassFields(Class<?> object) {
        ArrayList<Field> fields2 = new ArrayList<Field>(Arrays.asList(object.getDeclaredFields()));
        Class<?> parentClass = object;
        Class<?> clazz = object;
        while ((clazz = clazz.getSuperclass()) != null && clazz != parentClass) {
            fields2.addAll(Arrays.asList(clazz.getDeclaredFields()));
            parentClass = clazz;
        }
        return fields2;
    }

    public static BasicOption addOptionToPage(OptionPage page, Option option, Field field, Object instance, @Nullable Migrator migrator) {
        Object value;
        BasicOption configOption = ConfigUtils.getOption(option, field, instance);
        if (configOption == null) {
            return null;
        }
        if (migrator != null && (value = migrator.getValue(field, configOption.name, configOption.category, configOption.subcategory)) != null) {
            ConfigUtils.setField(field, value, instance);
        }
        ConfigUtils.getSubCategory((OptionPage)page, (String)configOption.category, (String)configOption.subcategory).options.add(configOption);
        return configOption;
    }

    public static BasicOption addOptionToPage(OptionPage page, Method method, Object instance) {
        ConfigButton configOption = ConfigButton.create(method, instance);
        ConfigUtils.getSubCategory((OptionPage)page, (String)configOption.category, (String)configOption.subcategory).options.add(configOption);
        return configOption;
    }

    public static OptionSubcategory getSubCategory(OptionPage page, String categoryName, String subcategoryName) {
        if (!page.categories.containsKey(categoryName)) {
            page.categories.put(categoryName, new OptionCategory());
        }
        OptionCategory category = page.categories.get(categoryName);
        OptionSubcategory subcategory = category.subcategories.stream().filter(s2 -> s2.getName().equals(subcategoryName)).findFirst().orElse(null);
        if (category.subcategories.size() == 0 || subcategory == null) {
            subcategory = new OptionSubcategory(subcategoryName, categoryName);
            category.subcategories.add(subcategory);
        }
        return subcategory;
    }

    public static <T extends Annotation> T findAnnotation(Field field, Class<T> annotationType) {
        if (field.isAnnotationPresent(annotationType)) {
            return field.getAnnotation(annotationType);
        }
        for (Annotation ann : field.getDeclaredAnnotations()) {
            if (!ann.annotationType().isAnnotationPresent(annotationType)) continue;
            return ann.annotationType().getAnnotation(annotationType);
        }
        return null;
    }

    public static <T extends Annotation> T findAnnotation(Method method, Class<T> annotationType) {
        if (method.isAnnotationPresent(annotationType)) {
            return method.getAnnotation(annotationType);
        }
        for (Annotation ann : method.getDeclaredAnnotations()) {
            if (!ann.annotationType().isAnnotationPresent(annotationType)) continue;
            return ann.annotationType().getAnnotation(annotationType);
        }
        return null;
    }

    public static <T extends Annotation> T findAnnotation(FieldAttributes field, Class<T> annotationType) {
        Annotation annotation = field.getAnnotation(annotationType);
        if (annotation != null) {
            return (T)annotation;
        }
        for (Annotation ann : field.getAnnotations()) {
            if (!ann.annotationType().isAnnotationPresent(annotationType)) continue;
            return ann.annotationType().getAnnotation(annotationType);
        }
        return null;
    }

    public static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationType) {
        if (clazz.isAnnotationPresent(annotationType)) {
            return clazz.getAnnotation(annotationType);
        }
        for (Annotation ann : clazz.getDeclaredAnnotations()) {
            if (!ann.annotationType().isAnnotationPresent(annotationType)) continue;
            return ann.annotationType().getAnnotation(annotationType);
        }
        return null;
    }

    public static Object getField(Field field, Object parent) {
        try {
            field.setAccessible(true);
            return field.get(parent);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static void setField(Field field, Object value, Object parent) {
        try {
            field.setAccessible(true);
            field.set(parent, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getCurrentProfile() {
        return Profiles.getCurrentProfile();
    }

    public static File getProfileDir() {
        return Profiles.getProfileDir();
    }

    public static File getNonSpecificProfileDir() {
        return Profiles.nonProfileSpecificDir;
    }

    public static File getProfileFile(String file) {
        return Profiles.getProfileFile(file);
    }

    public static File getNonProfileSpecificFile(String file) {
        return Profiles.getNonProfileSpecificFile(file);
    }
}

