/*
 * Decompiled with CFR 0.152.
 */
package cc.polyfrost.oneconfig.config;

import cc.polyfrost.oneconfig.config.annotations.Button;
import cc.polyfrost.oneconfig.config.annotations.CustomOption;
import cc.polyfrost.oneconfig.config.annotations.HUD;
import cc.polyfrost.oneconfig.config.annotations.Page;
import cc.polyfrost.oneconfig.config.annotations.SubConfig;
import cc.polyfrost.oneconfig.config.core.ConfigUtils;
import cc.polyfrost.oneconfig.config.core.OneKeyBind;
import cc.polyfrost.oneconfig.config.data.Mod;
import cc.polyfrost.oneconfig.config.data.PageLocation;
import cc.polyfrost.oneconfig.config.elements.BasicOption;
import cc.polyfrost.oneconfig.config.elements.OptionPage;
import cc.polyfrost.oneconfig.config.elements.OptionSubcategory;
import cc.polyfrost.oneconfig.config.gson.InstanceSupplier;
import cc.polyfrost.oneconfig.config.gson.exclusion.NonProfileSpecificExclusionStrategy;
import cc.polyfrost.oneconfig.config.gson.exclusion.ProfileExclusionStrategy;
import cc.polyfrost.oneconfig.gui.OneConfigGui;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigKeyBind;
import cc.polyfrost.oneconfig.gui.elements.config.ConfigPageButton;
import cc.polyfrost.oneconfig.gui.pages.ModConfigPage;
import cc.polyfrost.oneconfig.hud.HUDUtils;
import cc.polyfrost.oneconfig.internal.config.SubMainConfig;
import cc.polyfrost.oneconfig.internal.config.annotations.Option;
import cc.polyfrost.oneconfig.internal.config.core.ConfigCore;
import cc.polyfrost.oneconfig.internal.config.core.KeyBindHandler;
import cc.polyfrost.oneconfig.internal.utils.Deprecator;
import cc.polyfrost.oneconfig.utils.gui.GuiUtils;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class Config {
    public final transient HashMap<String, BasicOption> optionNames = new HashMap();
    protected final transient String configFile;
    protected final transient Gson gson = this.addGsonOptions(new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ProfileExclusionStrategy()})).create();
    protected final transient Gson nonProfileSpecificGson = this.addGsonOptions(new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new NonProfileSpecificExclusionStrategy()})).create();
    public final transient Mod mod;
    public boolean enabled;
    public final boolean canToggle;
    private final transient Logger logger;

    public Config(Mod modData, String configFile, boolean enabled, boolean canToggle) {
        this.configFile = configFile;
        this.mod = modData;
        this.enabled = enabled;
        this.canToggle = canToggle;
        this.logger = LogManager.getLogger(this.getClass());
    }

    public Config(Mod modData, String configFile, boolean enabled) {
        this(modData, configFile, enabled, true);
    }

    public Config(Mod modData, String configFile) {
        this(modData, configFile, true);
    }

    public void initialize() {
        this.logger.trace("Initializing config for {}...", new Object[]{this.mod.name});
        boolean migrate = false;
        File profileFile = ConfigUtils.getProfileFile(this.configFile);
        if (profileFile.exists()) {
            this.load();
        }
        if (!profileFile.exists()) {
            if (this.mod.migrator != null) {
                migrate = true;
            } else {
                this.save();
            }
        }
        this.logger.trace("Should migrate: {}", new Object[]{migrate});
        this.mod.config = this;
        this.generateOptionList(this, this.mod.defaultPage, this.mod, migrate);
        if (migrate) {
            this.save();
        }
        this.logger.trace("Config for {} initialized", new Object[]{this.mod.name});
        ConfigCore.mods.add(this.mod);
    }

    public void reInitialize() {
        this.logger.trace("Reinitializing config for {}...", new Object[]{this.mod.name});
        File profileFile = ConfigUtils.getProfileFile(this.configFile);
        if (profileFile.exists()) {
            this.load();
        }
        if (!profileFile.exists()) {
            this.save();
        }
    }

    public void save() {
        Throwable throwable;
        BufferedWriter writer;
        this.logger.trace("Saving config for {}...", new Object[]{this.mod.name});
        Path profilePath = ConfigUtils.getProfileFile(this.configFile).toPath();
        Path nonProfileSpecificPath = ConfigUtils.getNonProfileSpecificFile(this.configFile).toPath();
        this.logger.trace("Saving to:\n\t{}\n\t{}", new Object[]{profilePath, nonProfileSpecificPath});
        try {
            Files.createDirectories(profilePath.getParent(), new FileAttribute[0]);
            Files.createDirectories(nonProfileSpecificPath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.logger.error("Failed to create directories for config file", (Throwable)e);
        }
        try {
            writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(profilePath, new OpenOption[0]), StandardCharsets.UTF_8));
            throwable = null;
            try {
                writer.write(this.gson.toJson((Object)this));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(nonProfileSpecificPath, new OpenOption[0]), StandardCharsets.UTF_8));
            throwable = null;
            try {
                writer.write(this.nonProfileSpecificGson.toJson((Object)this));
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void load() {
        Serializable file;
        BufferedReader reader;
        this.logger.trace("Loading config for {}...", new Object[]{this.mod.name});
        Path profilePath = ConfigUtils.getProfileFile(this.configFile).toPath();
        Path nonProfileSpecificPath = ConfigUtils.getNonProfileSpecificFile(this.configFile).toPath();
        this.logger.trace("Loading from:\n\t{}\n\t{}", new Object[]{profilePath, nonProfileSpecificPath});
        try {
            reader = new BufferedReader(new InputStreamReader(Files.newInputStream(profilePath, new OpenOption[0]), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                this.gson.fromJson((Reader)reader, this.getClass());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            file = ConfigUtils.getProfileFile(this.configFile);
            ((File)file).renameTo(new File(((File)file).getParentFile(), ((File)file).getName() + ".corrupted"));
        }
        try {
            reader = new BufferedReader(new InputStreamReader(Files.newInputStream(nonProfileSpecificPath, new OpenOption[0]), StandardCharsets.UTF_8));
            file = null;
            try {
                this.nonProfileSpecificGson.fromJson((Reader)reader, this.getClass());
            }
            catch (Throwable throwable) {
                file = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (file != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)file).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            file = ConfigUtils.getNonProfileSpecificFile(this.configFile);
            ((File)file).renameTo(new File(((File)file).getParentFile(), ((File)file).getName() + ".corrupted"));
        }
    }

    protected final void generateOptionList(Object instance, OptionPage page, Mod mod, boolean migrate) {
        this.generateOptionList(instance, instance.getClass(), page, mod, migrate);
    }

    protected final void generateOptionList(Object instance, Class<?> targetClass, OptionPage page, Mod mod, boolean migrate) {
        this.logger.trace("Generating option list for {}... (targetting={})", new Object[]{mod.name, targetClass.getName()});
        Class<?> superclass = targetClass.getSuperclass();
        if (superclass != Object.class) {
            this.generateOptionList(instance, superclass, page, mod, migrate);
        }
        ArrayList<Mod> subMods = new ArrayList<Mod>();
        String pagePath = page.equals(mod.defaultPage) ? "" : page.name + ".";
        for (Field field : targetClass.getDeclaredFields()) {
            Config config;
            BasicOption configOption;
            Option option = ConfigUtils.findAnnotation(field, Option.class);
            CustomOption customOption = ConfigUtils.findAnnotation(field, CustomOption.class);
            String optionName = pagePath + field.getName();
            if (option != null) {
                configOption = ConfigUtils.addOptionToPage(page, option, field, instance, migrate ? mod.migrator : null);
                this.optionNames.put(optionName, configOption);
                continue;
            }
            if (customOption != null) {
                configOption = this.getCustomOption(field, customOption, page, mod, migrate);
                if (configOption == null) continue;
                this.optionNames.put(optionName, configOption);
                continue;
            }
            if (field.isAnnotationPresent(Page.class)) {
                ConfigPageButton button;
                Page optionPage = field.getAnnotation(Page.class);
                OptionSubcategory subcategory = ConfigUtils.getSubCategory(page, optionPage.category(), optionPage.subcategory());
                Object pageInstance = ConfigUtils.getField(field, instance);
                if (pageInstance == null) continue;
                if (pageInstance instanceof cc.polyfrost.oneconfig.gui.pages.Page) {
                    button = new ConfigPageButton(field, instance, optionPage.name(), optionPage.description(), optionPage.category(), optionPage.subcategory(), (cc.polyfrost.oneconfig.gui.pages.Page)pageInstance);
                } else {
                    OptionPage newPage = new OptionPage(optionPage.name(), mod);
                    this.generateOptionList(pageInstance, newPage, mod, migrate);
                    button = new ConfigPageButton(field, instance, optionPage.name(), optionPage.description(), optionPage.category(), optionPage.subcategory(), newPage);
                }
                if (optionPage.location() == PageLocation.TOP) {
                    subcategory.topButtons.add(button);
                    continue;
                }
                subcategory.bottomButtons.add(button);
                continue;
            }
            if (field.isAnnotationPresent(HUD.class)) {
                HUDUtils.addHudOptions(page, field, instance, this);
                continue;
            }
            if (!field.isAnnotationPresent(SubConfig.class) || page != mod.defaultPage || (config = (Config)ConfigUtils.getField(field, instance)) == null) continue;
            subMods.add(config.mod);
        }
        for (AccessibleObject accessibleObject : targetClass.getDeclaredMethods()) {
            Button button = ConfigUtils.findAnnotation((Method)accessibleObject, Button.class);
            String optionName = pagePath + ((Method)accessibleObject).getName();
            if (button == null) continue;
            BasicOption option = ConfigUtils.addOptionToPage(page, (Method)accessibleObject, instance);
            this.optionNames.put(optionName, option);
        }
        if (!subMods.isEmpty()) {
            if (!this.optionNames.isEmpty()) {
                subMods.add(new SubMainConfig().mod);
            }
            ConfigCore.subMods.put(this.mod, subMods);
        }
        this.logger.trace("Finished generating option list for {} (targetting={})", new Object[]{mod.name, targetClass.getName()});
    }

    protected BasicOption getCustomOption(Field field, CustomOption annotation, OptionPage page, Mod mod, boolean migrate) {
        return null;
    }

    protected GsonBuilder addGsonOptions(GsonBuilder builder) {
        return builder.registerTypeAdapter(this.getClass(), new InstanceSupplier<Config>(this)).excludeFieldsWithModifiers(new int[]{128}).setPrettyPrinting();
    }

    public void openGui() {
        if (this.mod == null) {
            return;
        }
        GuiUtils.displayScreen((Object)new OneConfigGui(new ModConfigPage(this.mod.defaultPage)));
    }

    protected final void addDependency(String option, String conditionName, Supplier<Boolean> condition) {
        if (!this.optionNames.containsKey(option)) {
            return;
        }
        this.optionNames.get(option).addDependency(conditionName, condition);
    }

    @Deprecated
    protected final void addDependency(String option, Supplier<Boolean> condition) {
        Deprecator.markDeprecated();
        if (!this.optionNames.containsKey(option)) {
            return;
        }
        this.optionNames.get(option).addDependency(condition);
    }

    protected final void addDependency(String option, String dependentOption) {
        if (!this.optionNames.containsKey(option) || !this.optionNames.containsKey(dependentOption)) {
            return;
        }
        BasicOption optionObj = this.optionNames.get(dependentOption);
        this.optionNames.get(option).addDependency(optionObj.name, () -> {
            try {
                return (boolean)((Boolean)optionObj.get());
            }
            catch (IllegalAccessException ignored) {
                return true;
            }
        });
    }

    @Deprecated
    protected final void addDependency(String option, boolean value) {
        Deprecator.markDeprecated();
        if (!this.optionNames.containsKey(option)) {
            return;
        }
        this.optionNames.get(option).addDependency(() -> value);
    }

    protected final void hideIf(String option, Supplier<Boolean> condition) {
        if (!this.optionNames.containsKey(option)) {
            return;
        }
        this.optionNames.get(option).addHideCondition(condition);
    }

    protected final void hideIf(String option, String dependentOption) {
        if (!this.optionNames.containsKey(option) || !this.optionNames.containsKey(dependentOption)) {
            return;
        }
        this.optionNames.get(option).addHideCondition(() -> {
            try {
                return (boolean)((Boolean)this.optionNames.get(dependentOption).get());
            }
            catch (IllegalAccessException ignored) {
                return true;
            }
        });
    }

    @Deprecated
    protected final void hideIf(String option, boolean value) {
        Deprecator.markDeprecated();
        if (!this.optionNames.containsKey(option)) {
            return;
        }
        this.optionNames.get(option).addHideCondition(() -> value);
    }

    protected final void addListener(String option, Runnable runnable) {
        if (!this.optionNames.containsKey(option)) {
            return;
        }
        this.optionNames.get(option).addListener(runnable);
    }

    protected final void registerKeyBind(OneKeyBind keyBind, Runnable runnable) {
        Field field = null;
        Object instance = null;
        for (BasicOption option : this.optionNames.values()) {
            if (!(option instanceof ConfigKeyBind)) continue;
            try {
                Field f = option.getField();
                OneKeyBind keyBind1 = (OneKeyBind)option.get();
                if (keyBind1 != keyBind) continue;
                field = f;
                instance = option.getParent();
                break;
            }
            catch (IllegalAccessException ignored) {
            }
        }
        keyBind.setRunnable(runnable);
        KeyBindHandler.INSTANCE.addKeyBind(field, instance, keyBind);
    }

    public boolean supportsProfiles() {
        return true;
    }

    @ApiStatus.Experimental
    @Contract(value="null -> null")
    public static Mod register(Mod mod) {
        if (mod == null) {
            return null;
        }
        if (ConfigCore.mods.contains(mod)) {
            return mod;
        }
        ConfigCore.mods.add(mod);
        ConfigCore.sortMods();
        return null;
    }

    public final void preload() {
    }
}

