/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.farm.common.entity.sheep;

import com.animania.Animania;
import com.animania.addons.farm.common.entity.sheep.EntityEweBase;
import com.animania.addons.farm.common.entity.sheep.EntityLambBase;
import com.animania.addons.farm.common.entity.sheep.EntityRamBase;
import com.animania.addons.farm.common.entity.sheep.SheepDorper;
import com.animania.addons.farm.common.entity.sheep.SheepDorset;
import com.animania.addons.farm.common.entity.sheep.SheepFriesian;
import com.animania.addons.farm.common.entity.sheep.SheepJacob;
import com.animania.addons.farm.common.entity.sheep.SheepMerino;
import com.animania.addons.farm.common.entity.sheep.SheepSuffolk;
import com.animania.api.interfaces.AnimaniaType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.stats.StatBase;
import net.minecraft.world.World;

public enum SheepType implements AnimaniaType
{
    DORPER(SheepDorper.EntityRamDorper.class, SheepDorper.EntityEweDorper.class, SheepDorper.EntityLambDorper.class, null, true),
    DORSET(SheepDorset.EntityRamDorset.class, SheepDorset.EntityEweDorset.class, SheepDorset.EntityLambDorset.class, null, true),
    FRIESIAN(SheepFriesian.EntityRamFriesian.class, SheepFriesian.EntityEweFriesian.class, SheepFriesian.EntityLambFriesian.class, null, false),
    JACOB(SheepJacob.EntityRamJacob.class, SheepJacob.EntityEweJacob.class, SheepJacob.EntityLambJacob.class, null, false),
    MERINO(SheepMerino.EntityRamMerino.class, SheepMerino.EntityEweMerino.class, SheepMerino.EntityLambMerino.class, null, false),
    SUFFOLK(SheepSuffolk.EntityRamSuffolk.class, SheepSuffolk.EntityEweSuffolk.class, SheepSuffolk.EntityLambSuffolk.class, null, true);

    private Class male;
    private Class female;
    private Class child;
    private StatBase achievement;
    public boolean isPrime;

    private SheepType(Class male, Class female, Class child, StatBase achievement, boolean prime) {
        this.male = male;
        this.female = female;
        this.child = child;
        this.achievement = achievement;
        this.isPrime = prime;
    }

    public EntityRamBase getMale(World world) {
        Constructor constructor = null;
        try {
            constructor = this.male.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityRamBase male = null;
        try {
            male = (EntityRamBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return male;
    }

    public EntityEweBase getFemale(World world) {
        Constructor constructor = null;
        try {
            constructor = this.female.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityEweBase female = null;
        try {
            female = (EntityEweBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return female;
    }

    public EntityLambBase getChild(World world) {
        Constructor constructor = null;
        try {
            constructor = this.child.getConstructor(World.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        EntityLambBase child = null;
        try {
            child = (EntityLambBase)constructor.newInstance(world);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return child;
    }

    public static SheepType breed(SheepType male, SheepType female) {
        return Animania.RANDOM.nextBoolean() ? male : female;
    }

    public StatBase getAchievement() {
        return this.achievement;
    }

    @Override
    public String getTypeName() {
        return "animania:sheep";
    }
}

