/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.farm.common.entity.horses;

import com.animania.addons.farm.common.entity.horses.EntityAnimaniaHorse;
import com.animania.addons.farm.common.entity.horses.EntityStallionBase;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.IImpregnable;
import com.animania.api.interfaces.IMateable;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.compat.top.providers.entity.TOPInfoProviderMateable;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public class EntityMareBase
extends EntityAnimaniaHorse
implements TOPInfoProviderMateable,
IMateable,
IImpregnable {
    private ResourceLocation resourceLocation;
    private ResourceLocation resourceLocationBlink;
    private static final String[] HORSE_TEXTURES = new String[]{"black", "bw1", "bw2", "grey", "red", "white"};
    public int dryTimerMare;
    protected static final DataParameter<Boolean> PREGNANT = EntityDataManager.func_187226_a(EntityMareBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> HAS_KIDS = EntityDataManager.func_187226_a(EntityMareBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FERTILE = EntityDataManager.func_187226_a(EntityMareBase.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> GESTATION_TIMER = EntityDataManager.func_187226_a(EntityMareBase.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Optional<UUID>> MATE_UNIQUE_ID = EntityDataManager.func_187226_a(EntityMareBase.class, (DataSerializer)DataSerializers.field_187203_m);

    public EntityMareBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.8f, 2.2f);
        this.field_70130_N = 1.8f;
        this.field_70131_O = 2.2f;
        this.field_70138_W = 1.2f;
        this.mateable = true;
        this.gender = EntityGender.FEMALE;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PREGNANT, (Object)false);
        this.field_70180_af.func_187214_a(HAS_KIDS, (Object)false);
        this.field_70180_af.func_187214_a(FERTILE, (Object)true);
        this.field_70180_af.func_187214_a(GESTATION_TIMER, (Object)(AnimaniaConfig.careAndFeeding.gestationTimer + this.field_70146_Z.nextInt(400)));
        this.field_70180_af.func_187214_a(MATE_UNIQUE_ID, (Object)Optional.absent());
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        GenericBehavior.initialSpawnFemale((EntityAnimal)this, EntityAnimaniaHorse.class);
        return livingdata;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    public int getGestation() {
        return this.getIntFromDataManager(GESTATION_TIMER);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.func_70631_g_() && this.func_110257_ck()) {
            if (player.func_70093_af()) {
                this.func_110199_f(player);
                return true;
            }
            return super.func_184645_a(player, hand);
        }
        if (!player.func_70093_af() && stack != null && this.func_110257_ck() && !this.getSleeping() && !this.func_184207_aI() && this.getWatered() && this.getFed()) {
            this.func_110237_h(player);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void setGestation(int gestation) {
        this.field_70180_af.func_187227_b(GESTATION_TIMER, (Object)gestation);
    }

    @Override
    public boolean getPregnant() {
        return this.getBoolFromDataManager(PREGNANT);
    }

    @Override
    public void setPregnant(boolean preggers) {
        if (preggers) {
            this.setGestation(AnimaniaConfig.careAndFeeding.gestationTimer + this.field_70146_Z.nextInt(200));
        }
        this.field_70180_af.func_187227_b(PREGNANT, (Object)preggers);
    }

    @Override
    public DataParameter<Boolean> getFertileParam() {
        return FERTILE;
    }

    @Override
    public DataParameter<Boolean> getHasKidsParam() {
        return HAS_KIDS;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.6;
    }

    public void func_110199_f(EntityPlayer playerEntity) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            this.field_110296_bG.func_110133_a(this.func_70005_c_());
            playerEntity.func_184826_a((AbstractHorse)this, (IInventory)this.field_110296_bG);
        }
    }

    public int func_70646_bf() {
        return super.func_70646_bf();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        return this.func_110257_ck();
    }

    public void func_146082_f(EntityPlayer player) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)18);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187729_cv, 0.2f, 0.8f);
    }

    @Override
    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null && !this.getSleeping()) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i() - 0.05f);
        }
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    @Override
    public ResourceLocation getResourceLocationBlink() {
        return this.resourceLocationBlink;
    }

    @Override
    public void func_70636_d() {
        if (this.getColorNumber() > 5) {
            this.setColorNumber(0);
        }
        GenericBehavior.livingUpdateFemale((EntityAnimal)this, EntityStallionBase.class);
        super.func_70636_d();
    }

    public EntityMareBase createChild(EntityAgeable p_90011_1_) {
        return null;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, Entity entity, IProbeHitEntityData data) {
        if (player.func_70093_af()) {
            if (this.getMateUniqueId() != null) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.mated"));
            }
            if (this.getFertile() && !this.getPregnant()) {
                probeInfo.text(I18n.func_74838_a((String)"text.waila.fertile1"));
            }
            if (this.getPregnant()) {
                if (this.getGestation() > 1) {
                    int bob = this.getGestation();
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1") + " (" + bob + " " + I18n.func_74838_a((String)"text.waila.pregnant2") + ")");
                } else {
                    probeInfo.text(I18n.func_74838_a((String)"text.waila.pregnant1"));
                }
            }
        }
        super.addProbeInfo(mode, probeInfo, player, world, entity, data);
    }

    @Override
    public DataParameter<Integer> getGestationParam() {
        return GESTATION_TIMER;
    }

    @Override
    public DataParameter<Boolean> getPregnantParam() {
        return PREGNANT;
    }

    @Override
    public int getDryTimer() {
        return this.dryTimerMare;
    }

    @Override
    public void setDryTimer(int i) {
        this.dryTimerMare = i;
    }

    @Override
    public DataParameter<Optional<UUID>> getMateUniqueIdParam() {
        return MATE_UNIQUE_ID;
    }
}

