/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.farm.common.entity.chickens;

import com.animania.Animania;
import com.animania.addons.farm.common.entity.chickens.EntityAnimaniaChicken;
import com.animania.addons.farm.common.entity.cows.EntityAnimaniaCow;
import com.animania.addons.farm.common.handler.FarmAddonSoundHandler;
import com.animania.addons.farm.config.FarmConfig;
import com.animania.api.data.EntityGender;
import com.animania.common.handler.AddonInjectionHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.compat.top.providers.entity.TOPInfoProviderBase;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityRoosterBase
extends EntityAnimaniaChicken
implements TOPInfoProviderBase {
    protected static final DataParameter<Integer> CROWTIMER = EntityDataManager.func_187226_a(EntityRoosterBase.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> CROWDURATION = EntityDataManager.func_187226_a(EntityRoosterBase.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityRoosterBase(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 0.8f);
        this.field_70130_N = 0.6f;
        this.field_70131_O = 0.8f;
        this.setTimeUntilNextCrow(this.field_70146_Z.nextInt(200) + 200);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.2f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        if (AnimaniaConfig.gameRules.animalsCanAttackOthers) {
            AddonInjectionHandler.runInjection((String)"extra", (String)"attackFrogs", null, (Object[])new Object[]{this});
        }
        if (FarmConfig.settings.roostersFight) {
            this.field_70715_bh.func_75776_a(8, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityRoosterBase.class, 80, false, true, (Predicate)null));
        }
        this.gender = EntityGender.MALE;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 2.0f);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        AddonInjectionHandler.runInjection((String)"extra", (String)"eatFrogs", null, (Object[])new Object[]{entityIn, this});
        if (entityIn instanceof EntityPlayer) {
            ((EntityLivingBase)entityIn).func_70653_a((Entity)this, 1.0f, this.field_70165_t - entityIn.field_70165_t, this.field_70161_v - entityIn.field_70161_v);
        }
        int i = 3;
        int j = 30;
        int k = i ^ j;
        boolean a = true;
        boolean c = false;
        return flag;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(CROWTIMER, (Object)0);
        this.field_70180_af.func_187214_a(CROWDURATION, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("CrowTime", this.getTimeUntilNextCrow());
        nbttagcompound.func_74768_a("CrowDuration", this.getCrowDuration());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.setTimeUntilNextCrow(nbttagcompound.func_74762_e("CrowTime"));
        this.setCrowDuration(nbttagcompound.func_74762_e("CrowDuration"));
    }

    @Override
    public void func_70636_d() {
        this.field_70887_j = 1000;
        long currentTime = this.field_70170_p.func_72820_D() % 23999L;
        if (this.getTimeUntilNextCrow() > 0) {
            this.setTimeUntilNextCrow(this.getTimeUntilNextCrow() - 1);
        }
        if ((currentTime > 23250L || currentTime < 500L) && this.getTimeUntilNextCrow() == 0) {
            float modular = this.field_70146_Z.nextFloat() * (float)this.field_70146_Z.nextInt(3);
            boolean direction = this.field_70146_Z.nextBoolean();
            modular = direction ? (modular /= 10.0f) : modular / 10.0f * -1.0f;
            this.setCrowDuration(50);
            int crowChooser = this.field_70146_Z.nextInt(3);
            if (crowChooser == 0) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, FarmAddonSoundHandler.chickenCrow1, SoundCategory.PLAYERS, 0.7f, 0.95f + modular);
            } else if (crowChooser == 1) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, FarmAddonSoundHandler.chickenCrow2, SoundCategory.PLAYERS, 0.65f, 0.9f + modular);
            } else if (crowChooser == 2) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, FarmAddonSoundHandler.chickenCrow3, SoundCategory.PLAYERS, 0.6f, 1.05f + modular);
            }
            this.setTimeUntilNextCrow(this.field_70146_Z.nextInt(200) + 200);
            List list = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaCow.class, (double)30.0, (World)this.field_70170_p, (BlockPos)this.func_180425_c());
            for (int i = 0; i < list.size(); ++i) {
                EntityAnimaniaCow entityCow;
                if (!(list.get(i) instanceof EntityAnimaniaCow) || !(entityCow = (EntityAnimaniaCow)list.get(i)).getSleeping() || currentTime <= 24000L) continue;
                entityCow.setSleeping(false);
                entityCow.setSleepTimer(Float.valueOf(0.0f));
            }
        }
        if (this.getCrowDuration() > 0) {
            this.setCrowDuration(this.getCrowDuration() - 1);
        }
        super.func_70636_d();
    }

    public int getCrowDuration() {
        return this.getIntFromDataManager(CROWDURATION);
    }

    public void setCrowDuration(int duration) {
        this.field_70180_af.func_187227_b(CROWDURATION, (Object)duration);
    }

    public int getTimeUntilNextCrow() {
        return this.getIntFromDataManager(CROWTIMER);
    }

    public void setTimeUntilNextCrow(int timer) {
        this.field_70180_af.func_187227_b(CROWTIMER, (Object)timer);
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return Animania.RANDOM.nextBoolean() ? FarmAddonSoundHandler.chickenHurt1 : FarmAddonSoundHandler.chickenHurt2;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return Animania.RANDOM.nextBoolean() ? FarmAddonSoundHandler.chickenDeath1 : FarmAddonSoundHandler.chickenDeath2;
    }

    public void func_70642_aH() {
        SoundEvent soundevent = this.func_184639_G();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP() - 0.3f, this.func_70647_i() - 0.2f);
        }
    }
}

