/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.docdump;

import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.squiddev.plethora.api.meta.IMetaProvider;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.core.collections.SortedMultimap;
import org.squiddev.plethora.core.docdump.DocumentedMetaProvider;
import org.squiddev.plethora.core.docdump.DocumentedMethod;
import org.squiddev.plethora.core.docdump.IDocWriter;

public class JSONWriter
implements IDocWriter {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(Class.class, (src, typeOfSrc, context) -> new JsonPrimitive(src.getName())).create();
    private final JsonWriter writer;
    private final List<DocumentedMethod> methodData;
    private final List<DocumentedMetaProvider> metaData;

    public JSONWriter(OutputStream stream, Multimap<Class<?>, IMethod<?>> methods, SortedMultimap<Class<?>, IMetaProvider<?>> metaProviders) {
        this.writer = new JsonWriter((Writer)new OutputStreamWriter(stream, StandardCharsets.UTF_8));
        this.methodData = new ArrayList<DocumentedMethod>(methods.size());
        ArrayList<DocumentedMethod> methodData = this.methodData;
        for (Map.Entry entry : methods.entries()) {
            methodData.add(new DocumentedMethod((Class)entry.getKey(), (IMethod)entry.getValue()));
        }
        this.metaData = new ArrayList<DocumentedMetaProvider>();
        ArrayList<DocumentedMetaProvider> data = this.metaData;
        for (Map.Entry<Class<?>, Collection<IMetaProvider<?>>> entry : metaProviders.items().entrySet()) {
            for (IMetaProvider<?> provider : entry.getValue()) {
                data.add(new DocumentedMetaProvider(entry.getKey(), provider));
            }
        }
    }

    @Override
    public void write() throws IOException {
        this.writer.beginObject();
        this.writer.name("methods");
        gson.toJson(this.methodData, List.class, this.writer);
        this.writer.name("meta");
        gson.toJson(this.metaData, List.class, this.writer);
        this.writer.endObject();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

