/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core.capabilities;

import com.google.common.collect.MapMaker;
import dan200.computercraft.api.lua.LuaException;
import java.util.Map;
import java.util.concurrent.Callable;
import org.squiddev.plethora.api.method.ICostHandler;
import org.squiddev.plethora.api.method.MethodResult;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.PlethoraCore;

public final class DefaultCostHandler
implements ICostHandler {
    private static final Map<Object, DefaultCostHandler> handlers = new MapMaker().weakKeys().concurrencyLevel(1).makeMap();
    private double value = ConfigCore.CostSystem.initial;

    @Override
    public synchronized double get() {
        return this.value;
    }

    @Override
    public synchronized boolean consume(double amount) {
        if (amount < 0.0) {
            throw new IllegalArgumentException("amount must be >= 0");
        }
        if (ConfigCore.CostSystem.allowNegative ? this.value <= 0.0 : amount > this.value) {
            return false;
        }
        this.value -= amount;
        return true;
    }

    @Override
    public MethodResult await(double amount, MethodResult next) throws LuaException {
        if (this.consume(amount)) {
            return next;
        }
        if (!ConfigCore.CostSystem.allowNegative && amount > ConfigCore.CostSystem.limit || !ConfigCore.CostSystem.awaitRegen) {
            throw new LuaException("Insufficient energy (requires " + amount + ", has " + this.value + ".");
        }
        return MethodResult.awaiting(() -> this.consume(amount), () -> next);
    }

    @Override
    public MethodResult await(double amount, Callable<MethodResult> next) throws LuaException {
        if (this.consume(amount)) {
            try {
                return next.call();
            }
            catch (LuaException e) {
                throw e;
            }
            catch (Exception | LinkageError | VirtualMachineError e) {
                PlethoraCore.LOG.error("Unexpected error", e);
                throw new LuaException("Java Exception Thrown: " + e);
            }
        }
        if (!ConfigCore.CostSystem.allowNegative && amount > ConfigCore.CostSystem.limit || !ConfigCore.CostSystem.awaitRegen) {
            throw new LuaException("Insufficient energy (requires " + amount + ", has " + this.value + ").");
        }
        return MethodResult.awaiting(() -> this.consume(amount), next);
    }

    private synchronized void regen() {
        if (this.value < ConfigCore.CostSystem.limit) {
            this.value = Math.min(ConfigCore.CostSystem.limit, this.value + ConfigCore.CostSystem.regen);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICostHandler get(Object owner) {
        Map<Object, DefaultCostHandler> map = handlers;
        synchronized (map) {
            DefaultCostHandler handler = handlers.get(owner);
            if (handler == null) {
                handler = new DefaultCostHandler();
                handlers.put(owner, handler);
            }
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update() {
        Map<Object, DefaultCostHandler> map = handlers;
        synchronized (map) {
            for (DefaultCostHandler handler : handlers.values()) {
                handler.regen();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Map<Object, DefaultCostHandler> map = handlers;
        synchronized (map) {
            handlers.clear();
        }
    }
}

