/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.core;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.squiddev.plethora.api.IPlayerOwnable;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.TurtleWorldLocation;
import org.squiddev.plethora.api.method.IContextBuilder;
import org.squiddev.plethora.api.method.IContextFactory;
import org.squiddev.plethora.api.method.IMethod;
import org.squiddev.plethora.api.module.IModuleAccess;
import org.squiddev.plethora.api.module.IModuleContainer;
import org.squiddev.plethora.api.module.IModuleHandler;
import org.squiddev.plethora.api.module.SingletonModuleContainer;
import org.squiddev.plethora.api.reference.ConstantReference;
import org.squiddev.plethora.api.reference.IReference;
import org.squiddev.plethora.api.reference.Reference;
import org.squiddev.plethora.core.AttachableWrapperPeripheral;
import org.squiddev.plethora.core.ConfigCore;
import org.squiddev.plethora.core.Context;
import org.squiddev.plethora.core.ContextFactory;
import org.squiddev.plethora.core.MethodRegistry;
import org.squiddev.plethora.core.MethodWrapperPeripheral;
import org.squiddev.plethora.core.UnbakedContext;
import org.squiddev.plethora.core.capabilities.DefaultCostHandler;
import org.squiddev.plethora.core.executor.TaskRunner;

public class TurtleUpgradeModule
implements ITurtleUpgrade {
    private final IModuleHandler handler;
    private final ItemStack stack;
    private final String adjective;

    protected TurtleUpgradeModule(@Nonnull ItemStack stack, @Nonnull IModuleHandler handler, @Nonnull String adjective) {
        this.handler = handler;
        this.stack = stack;
        this.adjective = adjective;
    }

    @Nonnull
    public ResourceLocation getUpgradeID() {
        return this.handler.getModule();
    }

    public int getLegacyUpgradeID() {
        return -1;
    }

    @Nonnull
    public String getUnlocalisedAdjective() {
        return this.adjective;
    }

    @Nonnull
    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Peripheral;
    }

    @Nonnull
    public ItemStack getCraftingItem() {
        return this.stack;
    }

    protected boolean isBlacklisted() {
        String moduleName = this.handler.getModule().toString();
        return ConfigCore.Blacklist.blacklistModulesTurtle.contains(moduleName) || ConfigCore.Blacklist.blacklistModules.contains(moduleName);
    }

    public IPeripheral createPeripheral(final @Nonnull ITurtleAccess turtle, final @Nonnull TurtleSide side) {
        if (this.isBlacklisted()) {
            return null;
        }
        MethodRegistry registry = MethodRegistry.instance;
        TurtleModuleAccess access = new TurtleModuleAccess(turtle, side, this.handler);
        final IModuleContainer container = access.getContainer();
        ConstantReference<IModuleContainer> containerRef = new ConstantReference<IModuleContainer>(){

            @Override
            @Nonnull
            public IModuleContainer get() throws LuaException {
                if (turtle.getUpgrade(side) != TurtleUpgradeModule.this) {
                    throw new LuaException("The upgrade is gone");
                }
                return container;
            }

            @Override
            @Nonnull
            public IModuleContainer safeGet() throws LuaException {
                return this.get();
            }
        };
        IContextFactory factory = ((ContextFactory)((ContextFactory)((ContextFactory)((ContextFactory)ContextFactory.of(container, containerRef).withCostHandler(DefaultCostHandler.get(turtle))).withModules(container, containerRef)).addContext("origin", new TurtlePlayerOwnable(turtle))).addContext("origin", new TurtleWorldLocation(turtle))).addContext("origin", turtle, (IReference)Reference.id(turtle));
        this.handler.getAdditionalContext(access, (IContextBuilder)((Object)factory));
        Pair<List<IMethod<?>>, List<UnbakedContext<?>>> paired = registry.getMethodsPaired((Context<?>)((ContextFactory)factory).getBaked());
        if (((List)paired.getLeft()).isEmpty()) {
            return null;
        }
        AttachableWrapperPeripheral peripheral = new AttachableWrapperPeripheral(this.handler.getModule().toString(), (Object)this, paired, new TaskRunner(), ((ContextFactory)factory).getAttachments());
        access.wrapper = peripheral;
        return peripheral;
    }

    @Nonnull
    public TurtleCommandResult useTool(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side, @Nonnull TurtleVerb verb, @Nonnull EnumFacing direction) {
        return TurtleCommandResult.failure((String)"Cannot use tool");
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Pair<IBakedModel, Matrix4f> getModel(ITurtleAccess turtle, @Nonnull TurtleSide side) {
        float xOffset = side == TurtleSide.Left ? -0.40625f : 0.40625f;
        Matrix4f transform = new Matrix4f(0.0f, 0.0f, 1.0f, -0.5f, 0.0f, 1.0f, 0.0f, -0.5f, -1.0f, 0.0f, 0.0f, 0.5f, 0.0f, 0.0f, 0.0f, 1.0f);
        Pair<IBakedModel, Matrix4f> pair = this.handler.getModel(0.0f);
        transform.mul((Matrix4f)pair.getRight(), transform);
        transform.mul(new Matrix4f(0.8f, 0.0f, 0.0f, 0.5f + xOffset, 0.0f, 0.8f, 0.0f, 0.6f, 0.0f, 0.0f, 0.8f, 0.475f, 0.0f, 0.0f, 0.0f, 1.0f), transform);
        return Pair.of((Object)pair.getLeft(), (Object)transform);
    }

    public void update(@Nonnull ITurtleAccess turtle, @Nonnull TurtleSide side) {
        IPeripheral peripheral = turtle.getPeripheral(side);
        if (peripheral instanceof MethodWrapperPeripheral) {
            ((MethodWrapperPeripheral)peripheral).getRunner().func_73660_a();
        }
    }

    public static class TurtlePlayerOwnable
    implements ConstantReference<TurtlePlayerOwnable>,
    IPlayerOwnable {
        private final ITurtleAccess access;

        public TurtlePlayerOwnable(ITurtleAccess access) {
            this.access = access;
        }

        @Override
        @Nullable
        public GameProfile getOwningProfile() {
            return this.access.getOwningPlayer();
        }

        @Override
        @Nonnull
        public TurtlePlayerOwnable get() {
            return this;
        }

        @Override
        @Nonnull
        public TurtlePlayerOwnable safeGet() {
            return this;
        }
    }

    private static final class TurtleModuleAccess
    implements IModuleAccess {
        private AttachableWrapperPeripheral wrapper;
        private final ITurtleAccess access;
        private final TurtleSide side;
        private final IWorldLocation location;
        private final IModuleContainer container;

        private TurtleModuleAccess(ITurtleAccess access, TurtleSide side, IModuleHandler handler) {
            this.access = access;
            this.side = side;
            this.location = new TurtleWorldLocation(access);
            this.container = new SingletonModuleContainer(handler.getModule());
        }

        @Override
        @Nonnull
        public Object getOwner() {
            return this.access;
        }

        @Override
        @Nonnull
        public IWorldLocation getLocation() {
            return this.location;
        }

        @Override
        @Nonnull
        public IModuleContainer getContainer() {
            return this.container;
        }

        @Override
        @Nonnull
        public NBTTagCompound getData() {
            return this.access.getUpgradeNBTData(this.side);
        }

        @Override
        public void markDataDirty() {
            this.access.updateUpgradeNBTData(this.side);
        }

        @Override
        public void queueEvent(@Nonnull String event, Object ... args) {
            if (this.wrapper != null) {
                this.wrapper.queueEvent(event, args);
            }
        }
    }
}

