/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.plethora.api;

import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import org.squiddev.plethora.api.IWorldLocation;
import org.squiddev.plethora.api.WorldLocation;
import org.squiddev.plethora.api.reference.ConstantReference;

public class TurtleWorldLocation
implements ConstantReference<IWorldLocation>,
IWorldLocation {
    private final ITurtleAccess turtle;

    public TurtleWorldLocation(@Nonnull ITurtleAccess turtle) {
        Objects.requireNonNull(turtle, "entity cannot be null");
        this.turtle = turtle;
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.turtle.getWorld();
    }

    @Override
    @Nonnull
    public BlockPos getPos() {
        return this.turtle.getPosition();
    }

    @Override
    @Nonnull
    public Vec3d getLoc() {
        BlockPos pos = this.turtle.getPosition();
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBounds() {
        BlockPos pos = this.turtle.getPosition();
        return new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1));
    }

    @Override
    @Nonnull
    public IWorldLocation get() {
        return this;
    }

    @Override
    @Nonnull
    public IWorldLocation safeGet() {
        return new WorldLocation(this.getWorld(), this.getLoc());
    }
}

