/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.fyrecraft;

import net.minecraft.world.biome.Biome;
import rtg.api.world.RTGWorld;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.HeightVariation;
import rtg.api.world.terrain.heighteffect.JitterEffect;
import rtg.world.biome.realistic.fyrecraft.RealisticBiomeFYREBase;

public class RealisticBiomeFYRETropicalLakes
extends RealisticBiomeFYREBase {
    public RealisticBiomeFYRETropicalLakes(Biome biome) {
        super(biome);
    }

    @Override
    public void initConfig() {
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPLandOfLakes();
    }

    public static class TerrainBOPLandOfLakes
    extends TerrainBase {
        private float minHeight;
        private float maxHeight;
        private float hillStrength;
        private HeightVariation small;
        private HeightVariation large;
        private JitterEffect largeJitter;
        private JitterEffect smallJitter;

        public TerrainBOPLandOfLakes() {
            super(63.0f);
            this.small = new HeightVariation();
            this.small.height = 2.5f;
            this.small.octave = 1;
            this.small.wavelength = 10.0f;
            this.large = new HeightVariation();
            this.large.height = 5.0f;
            this.large.octave = 2;
            this.large.wavelength = 20.0f;
            this.smallJitter = new JitterEffect();
            this.smallJitter.amplitude = 2.0f;
            this.smallJitter.wavelength = 9.0f;
            this.smallJitter.jittered = this.large.plus(this.small);
            this.largeJitter = new JitterEffect();
            this.largeJitter.amplitude = 4.0f;
            this.largeJitter.wavelength = 18.0f;
            this.largeJitter.jittered = this.smallJitter;
        }

        public TerrainBOPLandOfLakes(float minHeight, float maxHeight, float hillStrength) {
            this.minHeight = minHeight;
            this.maxHeight = maxHeight > this.rollingHillsMaxHeight ? this.rollingHillsMaxHeight : (maxHeight < this.minHeight ? this.rollingHillsMaxHeight : maxHeight);
            this.hillStrength = hillStrength;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return TerrainBOPLandOfLakes.riverized(this.largeJitter.added(rtgWorld, x, y) + this.base, river);
        }
    }
}

