/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.HeightEffect;
import rtg.api.world.terrain.heighteffect.HeightVariation;
import rtg.api.world.terrain.heighteffect.JitterEffect;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;

public class RealisticBiomeBOPDeadSwamp
extends RealisticBiomeBOPBase {
    public static Biome biome = (Biome)BOPBiomes.dead_swamp.orNull();
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeBOPDeadSwamp() {
        super(biome);
    }

    @Override
    public Biome preferredBeach() {
        return biome;
    }

    @Override
    public void initConfig() {
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPDeadSwamp();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPDeadSwamp(this.getConfig(), BOPBlocks.grass.func_176223_P(), BOPBlocks.dirt.func_176223_P(), BOPBlocks.mud.func_176223_P());
    }

    public static class SurfaceBOPDeadSwamp
    extends SurfaceBase {
        private IBlockState mix;
        private float mixHeight;

        public SurfaceBOPDeadSwamp(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mixBlock) {
            super(config, top, filler);
            this.mix = mixBlock;
            this.mixHeight = 0.1f;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(2);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff && k > 64) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / 12.0f, (float)j / 12.0f) > this.mixHeight + (noise[x * 16 + z] - 63.0f) / 10.0f) {
                        primer.func_177855_a(x, k, z, this.mix);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPDeadSwamp
    extends TerrainBase {
        private HeightEffect height;

        public TerrainBOPDeadSwamp() {
            HeightVariation waterLand = new HeightVariation();
            waterLand.height = 2.0f;
            waterLand.wavelength = 40.0f;
            waterLand.octave = 0;
            this.height = new JitterEffect(5.0f, 10.0f, waterLand);
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            return 62.0f + this.height.added(rtgWorld, x, y);
        }
    }
}

