/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.biomesoplenty;

import biomesoplenty.api.biome.BOPBiomes;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.config.BiomeConfig;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.surface.SurfaceBase;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.biomesoplenty.RealisticBiomeBOPBase;

public class RealisticBiomeBOPBrushland
extends RealisticBiomeBOPBase {
    public static Biome biome = (Biome)BOPBiomes.brushland.orNull();
    public static Biome river = Biomes.field_76781_i;

    public RealisticBiomeBOPBrushland() {
        super(biome);
    }

    @Override
    public void initConfig() {
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainBOPBrushland();
    }

    @Override
    public SurfaceBase initSurface() {
        return new SurfaceBOPBrushland(this.getConfig(), RealisticBiomeBOPBrushland.biome.field_76752_A, RealisticBiomeBOPBrushland.biome.field_76753_B, Blocks.field_150354_m.func_176223_P(), 13.0f, 0.27f);
    }

    public static class SurfaceBOPBrushland
    extends SurfaceBase {
        private IBlockState mixBlock;
        private float width;
        private float height;

        public SurfaceBOPBrushland(BiomeConfig config, IBlockState top, IBlockState filler, IBlockState mix, float mixWidth, float mixHeight) {
            super(config, top, filler);
            this.mixBlock = mix;
            this.width = mixWidth;
            this.height = mixHeight;
        }

        @Override
        public void paintTerrain(ChunkPrimer primer, int i, int j, int x, int z, int depth, RTGWorld rtgWorld, float[] noise, float river, Biome[] base) {
            Random rand = rtgWorld.rand();
            SimplexNoise simplex = rtgWorld.simplexInstance(0);
            float c = TerrainBase.calcCliff(x, z, noise);
            boolean cliff = c > 1.4f;
            for (int k = 255; k > -1; --k) {
                Block b = primer.func_177856_a(x, k, z).func_177230_c();
                if (b == Blocks.field_150350_a) {
                    depth = -1;
                    continue;
                }
                if (b != Blocks.field_150348_b) continue;
                ++depth;
                if (cliff) {
                    if (depth > -1 && depth < 2) {
                        if (rand.nextInt(3) == 0) {
                            primer.func_177855_a(x, k, z, this.hcCobble());
                            continue;
                        }
                        primer.func_177855_a(x, k, z, this.hcStone());
                        continue;
                    }
                    if (depth >= 10) continue;
                    primer.func_177855_a(x, k, z, this.hcStone());
                    continue;
                }
                if (depth == 0 && k > 61) {
                    if (simplex.noise2f((float)i / this.width, (float)j / this.width) > this.height) {
                        primer.func_177855_a(x, k, z, this.mixBlock);
                        continue;
                    }
                    primer.func_177855_a(x, k, z, this.topBlock);
                    continue;
                }
                if (depth >= 4) continue;
                primer.func_177855_a(x, k, z, this.fillerBlock);
            }
        }
    }

    public static class TerrainBOPBrushland
    extends TerrainBase {
        private float baseHeight = 76.0f;
        private float hillStrength = 20.0f;

        public TerrainBOPBrushland() {
        }

        public TerrainBOPBrushland(float bh, float hs) {
            this.baseHeight = bh;
            this.hillStrength = hs;
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            this.groundNoise = TerrainBOPBrushland.groundNoise(x, y, this.groundNoiseAmplitudeHills, rtgWorld);
            float m = TerrainBOPBrushland.hills(x, y, this.hillStrength, rtgWorld);
            return TerrainBOPBrushland.riverized(this.baseHeight + this.groundNoise + m, river);
        }
    }
}

