/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.terrain;

import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.ChunkPrimer;
import rtg.api.util.noise.CellularNoise;
import rtg.api.util.noise.ISimplexData2D;
import rtg.api.util.noise.SimplexData2D;
import rtg.api.util.noise.SimplexNoise;
import rtg.api.world.RTGWorld;
import rtg.api.world.terrain.heighteffect.VariableRuggednessEffect;

public abstract class TerrainBase {
    private static final float minimumOceanFloor = 20.01f;
    private static final float minimumDuneHeight = 21.0f;
    protected final float minDuneHeight;
    protected final float groundNoiseAmplitudeHills;
    protected final float groundVariation;
    protected final float rollingHillsMaxHeight;
    protected float base;
    protected float groundNoise;

    public TerrainBase() {
        this(68.0f);
    }

    public TerrainBase(float base) {
        this.base = base;
        this.minDuneHeight = 21.0f;
        this.groundVariation = 2.0f;
        this.groundNoise = this.base;
        this.groundNoiseAmplitudeHills = 6.0f;
        this.rollingHillsMaxHeight = 80.0f;
    }

    public static float blendedHillHeight(float simplex) {
        float result = simplex + 1.0f;
        result = result * result * result + 10.0f;
        result = (float)Math.pow(result, 0.33333333333333);
        result /= 0.46631f;
        return result -= 4.62021f;
    }

    public static float blendedHillHeight(float simplex, float turnAt) {
        float adjusted = 1.0f - (1.0f - simplex) / (1.0f - turnAt);
        return TerrainBase.blendedHillHeight(adjusted);
    }

    public static float above(float limited, float limit) {
        if (limited > limit) {
            return limited - limit;
        }
        return 0.0f;
    }

    public static float unsignedPower(float number, float power) {
        if (number > 0.0f) {
            return (float)Math.pow(number, power);
        }
        return -1.0f * (float)Math.pow(-1.0f * number, power);
    }

    public static float hills(float x, float y, float hillStrength, RTGWorld rtgWorld) {
        float m = rtgWorld.simplexInstance(0).noise2f(x / 150.0f, y / 150.0f);
        m = TerrainBase.blendedHillHeight(m, 0.2f);
        float sm = rtgWorld.simplexInstance(2).noise2f(x / 55.0f, y / 55.0f);
        sm = TerrainBase.blendedHillHeight(sm, 0.2f);
        sm *= sm * m;
        return (m += sm / 3.0f) * hillStrength;
    }

    public static float groundNoise(int x, int y, float amplitude, RTGWorld rtgWorld) {
        float h = TerrainBase.blendedHillHeight(rtgWorld.simplexInstance(0).noise2f((float)x / 49.0f, (float)y / 49.0f), 0.2f) * amplitude;
        h += TerrainBase.blendedHillHeight(rtgWorld.simplexInstance(1).noise2f((float)x / 23.0f, (float)y / 23.0f), 0.2f) * amplitude / 2.0f;
        return h += TerrainBase.blendedHillHeight(rtgWorld.simplexInstance(2).noise2f((float)x / 11.0f, (float)y / 11.0f), 0.2f) * amplitude / 4.0f;
    }

    public static float groundNoise(float x, float y, float amplitude, RTGWorld rtgWorld) {
        float h = TerrainBase.blendedHillHeight(rtgWorld.simplexInstance(0).noise2f(x / 49.0f, y / 49.0f), 0.2f) * amplitude;
        h += TerrainBase.blendedHillHeight(rtgWorld.simplexInstance(1).noise2f(x / 23.0f, y / 23.0f), 0.2f) * amplitude / 2.0f;
        return h += TerrainBase.blendedHillHeight(rtgWorld.simplexInstance(2).noise2f(x / 11.0f, y / 11.0f), 0.2f) * amplitude / 4.0f;
    }

    public static float getTerrainBase() {
        return 68.0f;
    }

    public static float getTerrainBase(float river) {
        return 62.0f + 6.0f * river;
    }

    public static float mountainCap(float m) {
        if (m > 160.0f && (m = 160.0f + (m - 160.0f) * 0.75f) > 180.0f) {
            m = 180.0f + (m - 180.0f) * 0.75f;
        }
        return m;
    }

    public static float riverized(float height, float river) {
        if (height < 62.45f) {
            return height;
        }
        float adjustment = (height - 62.45f) / 10.0f + 0.6f;
        river = TerrainBase.bayesianAdjustment(river, adjustment);
        return 62.45f + (height - 62.45f) * river;
    }

    public static float terrainBeach(int x, int y, RTGWorld rtgWorld, float river, float baseHeight) {
        return TerrainBase.riverized(baseHeight + TerrainBase.groundNoise(x, y, 4.0f, rtgWorld), river);
    }

    public static float terrainBryce(int x, int y, RTGWorld rtgWorld, float river, float height) {
        SimplexNoise simplex = rtgWorld.simplexInstance(0);
        float sn = simplex.noise2f((float)x / 2.0f, (float)y / 2.0f) * 0.5f + 0.5f;
        sn = (float)((double)sn + ((double)simplex.noise2f(x, y) * 0.2 + 0.2));
        sn += simplex.noise2f((float)x / 4.0f, (float)y / 4.0f) * 4.0f + 4.0f;
        float n = height / (sn += simplex.noise2f((float)x / 8.0f, (float)y / 8.0f) * 2.0f + 2.0f) * 2.0f;
        n = sn < 6.0f ? (n += simplex.noise2f((float)x / 64.0f, (float)y / 64.0f) * 4.0f) : 0.0f;
        return TerrainBase.riverized(TerrainBase.getTerrainBase() + n, river);
    }

    public static float terrainCanyon(int x, int y, RTGWorld rtgWorld, float river, float[] height, float border, float strength, int heightLength, boolean booRiver) {
        SimplexNoise simplex = rtgWorld.simplexInstance(0);
        float r = simplex.noise2f((float)x / 100.0f, (float)y / 100.0f) * 50.0f * river;
        r = r < -7.4f ? -7.4f : (r > 7.4f ? 7.4f : r);
        float b = (17.0f + r) * river;
        float hn = simplex.noise2f((float)x / 12.0f, (float)y / 12.0f) * 0.5f;
        float sb = 0.0f;
        if (b > 0.0f) {
            sb = b;
            sb = sb > 7.0f ? 7.0f : sb;
            sb = hn * sb * river;
        }
        b += sb;
        float cTotal = 0.0f;
        for (int i = 0; i < heightLength; i += 2) {
            float cTemp = 0.0f;
            if (b > height[i] && border > 0.6f + height[i] * 0.015f + hn * 0.2f) {
                cTemp = b > height[i] + height[i + 1] ? height[i + 1] : b - height[i];
                cTemp *= strength;
            }
            cTotal += cTemp;
        }
        float bn = 0.0f;
        if (booRiver) {
            if (b < 5.0f) {
                bn = 5.0f - b;
                for (int i = 0; i < 3; ++i) {
                    bn *= bn / 4.5f;
                }
            }
        } else if (b < 5.0f) {
            bn = (simplex.noise2f((float)x / 7.0f, (float)y / 7.0f) * 1.3f + simplex.noise2f((float)x / 15.0f, (float)y / 15.0f) * 2.0f) * (5.0f - b) * 0.2f;
        }
        return TerrainBase.getTerrainBase(river) + (b += cTotal - bn);
    }

    public static float terrainFlatLakes(int x, int y, RTGWorld rtgWorld, float river, float baseHeight) {
        float ruggedNoise = rtgWorld.simplexInstance(1).noise2f((float)x / VariableRuggednessEffect.STANDARD_RUGGEDNESS_WAVELENGTH, (float)y / VariableRuggednessEffect.STANDARD_RUGGEDNESS_WAVELENGTH);
        ruggedNoise = TerrainBase.blendedHillHeight(ruggedNoise);
        float h = TerrainBase.groundNoise(x, y, 2.0f * (ruggedNoise + 1.0f), rtgWorld);
        return TerrainBase.riverized(baseHeight + h, river);
    }

    public static float terrainForest(int x, int y, RTGWorld rtgWorld, float river, float baseHeight) {
        SimplexNoise simplex = rtgWorld.simplexInstance(0);
        double h = simplex.noise2d((double)x / 100.0, (double)y / 100.0) * 8.0;
        h += simplex.noise2d((double)x / 30.0, (double)y / 30.0) * 4.0;
        h += simplex.noise2d((double)x / 15.0, (double)y / 15.0) * 2.0;
        return TerrainBase.riverized(baseHeight + 20.0f + (float)(h += simplex.noise2d((double)x / 7.0, (double)y / 7.0)), river);
    }

    public static float terrainGrasslandFlats(int x, int y, RTGWorld rtgWorld, float river, float mPitch, float baseHeight) {
        SimplexNoise simplex = rtgWorld.simplexInstance(0);
        float h = simplex.noise2f((float)x / 100.0f, (float)y / 100.0f) * 7.0f;
        float m = simplex.noise2f((float)x / 180.0f, (float)y / 180.0f) * 35.0f * river;
        m *= m / mPitch;
        float sm = TerrainBase.blendedHillHeight(simplex.noise2f((float)x / 30.0f, (float)y / 30.0f)) * 8.0f;
        return TerrainBase.riverized(baseHeight + (h += simplex.noise2f((float)x / 20.0f, (float)y / 20.0f) * 2.0f) + (m += (sm *= m / 20.0f > 3.75f ? 3.75f : m / 20.0f)), river);
    }

    public static float terrainGrasslandHills(int x, int y, RTGWorld rtgWorld, float river, float vWidth, float vHeight, float hWidth, float hHeight, float bHeight) {
        float h = rtgWorld.simplexInstance(0).noise2f((float)x / vWidth, (float)y / vWidth);
        h = TerrainBase.blendedHillHeight(h, 0.3f);
        float m = rtgWorld.simplexInstance(1).noise2f((float)x / hWidth, (float)y / hWidth);
        m = TerrainBase.blendedHillHeight(m, 0.3f) * h;
        m *= m;
        h *= vHeight * river;
        return TerrainBase.riverized(bHeight + (h += TerrainBase.groundNoise(x, y, 4.0f, rtgWorld)), river) + (m *= hHeight * river);
    }

    public static float terrainGrasslandMountains(int x, int y, RTGWorld rtgWorld, float river, float hFactor, float mFactor, float baseHeight) {
        SimplexNoise simplex0 = rtgWorld.simplexInstance(0);
        float h = simplex0.noise2f((float)x / 100.0f, (float)y / 100.0f) * hFactor;
        h += simplex0.noise2f((float)x / 20.0f, (float)y / 20.0f) * 2.0f;
        float m = simplex0.noise2f((float)x / 230.0f, (float)y / 230.0f) * mFactor * river;
        m = (m *= m / 35.0f) > 70.0f ? 70.0f + (m - 70.0f) / 2.5f : m;
        float c = rtgWorld.simplexInstance(4).noise3f((float)x / 30.0f, (float)y / 30.0f, 1.0f) * (m * 0.3f);
        float sm = simplex0.noise2f((float)x / 30.0f, (float)y / 30.0f) * 8.0f + simplex0.noise2f((float)x / 8.0f, (float)y / 8.0f);
        m += (sm *= m / 20.0f > 2.5f ? 2.5f : m / 20.0f);
        return TerrainBase.riverized(baseHeight + h + (m += c), river);
    }

    public static float terrainHighland(float x, float y, RTGWorld rtgWorld, float river, float start, float width, float height, float baseAdjust) {
        float h = rtgWorld.simplexInstance(0).noise2f(x / width, y / width) * height * river;
        float f = h = h < start ? start + (h - start) / 4.5f : h;
        if (h < 0.0f) {
            h = 0.0f;
        }
        if (h > 0.0f) {
            float st = h * 1.5f > 15.0f ? 15.0f : h * 1.5f;
            h += rtgWorld.simplexInstance(4).noise3f(x / 70.0f, y / 70.0f, 1.0f) * st;
            h *= river;
        }
        h += TerrainBase.blendedHillHeight(rtgWorld.simplexInstance(0).noise2f(x / 20.0f, y / 20.0f), 0.0f) * 4.0f;
        h += TerrainBase.blendedHillHeight(rtgWorld.simplexInstance(0).noise2f(x / 12.0f, y / 12.0f), 0.0f) * 2.0f;
        if ((h += TerrainBase.blendedHillHeight(rtgWorld.simplexInstance(0).noise2f(x / 5.0f, y / 5.0f), 0.0f) * 1.0f) < 0.0f) {
            h /= 2.0f;
        }
        if (h < -3.0f) {
            h = (h + 3.0f) / 2.0f - 3.0f;
        }
        return TerrainBase.getTerrainBase(river) + (h + baseAdjust) * river;
    }

    public static float terrainLonelyMountain(int x, int y, RTGWorld rtgWorld, float river, float strength, float width, float terrainHeight) {
        SimplexNoise simplex0 = rtgWorld.simplexInstance(0);
        float h = TerrainBase.blendedHillHeight(simplex0.noise2f((float)x / 20.0f, (float)y / 20.0f), 0.0f) * 3.0f;
        h += TerrainBase.blendedHillHeight(simplex0.noise2f((float)x / 7.0f, (float)y / 7.0f), 0.0f) * 1.3f;
        float m = simplex0.noise2f((float)x / width, (float)y / width) * strength * river;
        m = (m *= m / 35.0f) > 70.0f ? 70.0f + (m - 70.0f) / 2.5f : m;
        float st = m * 0.7f;
        st = st > 20.0f ? 20.0f : st;
        float c = rtgWorld.simplexInstance(4).noise3f((float)x / 30.0f, (float)y / 30.0f, 1.0f) * (5.0f + st);
        float sm = simplex0.noise2f((float)x / 30.0f, (float)y / 30.0f) * 8.0f + simplex0.noise2f((float)x / 8.0f, (float)y / 8.0f);
        m += (sm *= (m + 10.0f) / 20.0f > 2.5f ? 2.5f : (m + 10.0f) / 20.0f);
        m += c;
        if (m > 90.0f && (m = 90.0f + (m - 90.0f) * 0.75f) > 110.0f) {
            m = 110.0f + (m - 110.0f) * 0.75f;
        }
        return TerrainBase.riverized(terrainHeight + h + m, river);
    }

    public static float terrainMarsh(int x, int y, RTGWorld rtgWorld, float baseHeight, float river) {
        SimplexNoise simplex = rtgWorld.simplexInstance(0);
        float h = simplex.noise2f((float)x / 130.0f, (float)y / 130.0f) * 20.0f;
        h += simplex.noise2f((float)x / 12.0f, (float)y / 12.0f) * 2.0f;
        float f = h = (h += simplex.noise2f((float)x / 18.0f, (float)y / 18.0f) * 4.0f) < 8.0f ? 0.0f : h - 8.0f;
        if (h == 0.0f) {
            h += simplex.noise2f((float)x / 20.0f, (float)y / 20.0f) + simplex.noise2f((float)x / 5.0f, (float)y / 5.0f);
            h *= 2.0f;
        }
        return TerrainBase.riverized(baseHeight + h, river);
    }

    public static float terrainOcean(int x, int y, RTGWorld rtgWorld, float river, float averageFloor) {
        SimplexNoise simplex = rtgWorld.simplexInstance(0);
        float h = simplex.noise2f((float)x / 300.0f, (float)y / 300.0f) * 8.0f * river;
        h += simplex.noise2f((float)x / 50.0f, (float)y / 50.0f) * 2.0f;
        float floNoise = averageFloor + (h += simplex.noise2f((float)x / 15.0f, (float)y / 15.0f) * 1.0f);
        floNoise = floNoise < 20.01f ? 20.01f : floNoise;
        return floNoise;
    }

    public static float terrainOceanCanyon(int x, int y, RTGWorld rtgWorld, float river, float[] height, float border, float strength, int heightLength, boolean booRiver) {
        float floNoise;
        SimplexNoise simplex = rtgWorld.simplexInstance(0);
        river = (river *= 1.3f) > 1.0f ? 1.0f : river;
        float r = simplex.noise2f((float)x / 100.0f, (float)y / 100.0f) * 50.0f;
        r = r < -7.4f ? -7.4f : (r > 7.4f ? 7.4f : r);
        float b = (17.0f + r) * river;
        float hn = simplex.noise2f((float)x / 12.0f, (float)y / 12.0f) * 0.5f;
        float sb = 0.0f;
        if (b > 0.0f) {
            sb = b;
            sb = sb > 7.0f ? 7.0f : sb;
            sb = hn * sb;
        }
        b += sb;
        float cTotal = 0.0f;
        for (int i = 0; i < heightLength; i += 2) {
            float cTemp = 0.0f;
            if (b > height[i] && border > 0.6f + height[i] * 0.015f + hn * 0.2f) {
                cTemp = b > height[i] + height[i + 1] ? height[i + 1] : b - height[i];
                cTemp *= strength;
            }
            cTotal += cTemp;
        }
        float bn = 0.0f;
        if (booRiver) {
            if (b < 5.0f) {
                bn = 5.0f - b;
                for (int i = 0; i < 3; ++i) {
                    bn *= bn / 4.5f;
                }
            }
        } else if (b < 5.0f) {
            bn = (simplex.noise2f((float)x / 7.0f, (float)y / 7.0f) * 1.3f + simplex.noise2f((float)x / 15.0f, (float)y / 15.0f) * 2.0f) * (5.0f - b) * 0.2f;
        }
        floNoise = (floNoise = 30.0f + (b += cTotal - bn)) < 20.01f ? 20.01f : floNoise;
        return floNoise;
    }

    public static float terrainPlains(int x, int y, RTGWorld rtgWorld, float river, float stPitch, float stFactor, float hPitch, float hDivisor, float baseHeight) {
        SimplexNoise simplex = rtgWorld.simplexInstance(0);
        float st = (simplex.noise2f((float)x / stPitch, (float)y / stPitch) + 0.38f) * stFactor * river;
        st = st < 0.2f ? 0.2f : st;
        float h = simplex.noise2f((float)x / hPitch, (float)y / hPitch) * st * 2.0f;
        h = h > 0.0f ? -h : h;
        h += st;
        h *= h / hDivisor;
        float floNoise = TerrainBase.riverized(baseHeight + (h += st), river);
        return floNoise;
    }

    public static float terrainPlateau(float x, float y, RTGWorld rtgWorld, float river, float[] height, float border, float strength, int heightLength, float selectorWaveLength, boolean isM) {
        SimplexNoise simplex = rtgWorld.simplexInstance(0);
        river = river > 1.0f ? 1.0f : river;
        float border2 = border * 4.0f - 2.5f;
        border2 = border2 > 1.0f ? 1.0f : (border2 < 0.0f ? 0.0f : border2);
        float b = simplex.noise2f(x / 40.0f, y / 40.0f) * 1.5f;
        float sn = simplex.noise2f(x / selectorWaveLength, y / selectorWaveLength) * 0.5f + 0.5f;
        sn *= border2;
        sn *= river;
        sn += simplex.noise2f(x / 4.0f, y / 4.0f) * 0.01f + 0.01f;
        sn += simplex.noise2f(x / 2.0f, y / 2.0f) * 0.01f + 0.01f;
        for (int i = 0; i < heightLength; i += 2) {
            float n = (sn - height[i + 1]) / (1.0f - height[i + 1]);
            n = (n *= strength) < 0.0f ? 0.0f : (n > 1.0f ? 1.0f : n);
            float hn = height[i] * 0.5f * (sn * 2.0f - 0.4f);
            hn = hn < 0.0f ? 0.0f : hn;
            float stepUp = 0.0f;
            if (sn > height[i + 1]) {
                stepUp += height[i] * n;
                if (isM) {
                    stepUp += simplex.noise2f(x / 20.0f, y / 20.0f) * 3.0f * n;
                    stepUp += simplex.noise2f(x / 12.0f, y / 12.0f) * 2.0f * n;
                    stepUp += simplex.noise2f(x / 5.0f, y / 5.0f) * 1.0f * n;
                }
            }
            if (i == 0 && stepUp < hn) {
                b += hn;
            }
            stepUp = stepUp < 0.0f ? 0.0f : stepUp;
            b += stepUp;
        }
        if (isM) {
            b += simplex.noise2f(x / 12.0f, y / 12.0f) * sn;
        }
        return TerrainBase.riverized(TerrainBase.getTerrainBase(), river) + (b /= border);
    }

    public static float terrainPolar(float x, float y, RTGWorld rtgWorld, float river, float stPitch, float stFactor, float hPitch, float hDivisor, float baseHeight) {
        SimplexNoise simplex = rtgWorld.simplexInstance(0);
        float st = (simplex.noise2f(x / stPitch, y / stPitch) + 0.38f) * stFactor * river;
        st = st < 0.1f ? 0.1f : st;
        float h = simplex.noise2f(x / hPitch, y / hPitch) * st * 2.0f;
        h = h > 0.0f ? -h : h;
        h += st;
        h *= h / hDivisor;
        float floNoise = TerrainBase.riverized(baseHeight + (h += st), river);
        return floNoise;
    }

    public static float terrainRollingHills(int x, int y, RTGWorld rtgWorld, float river, float hillStrength, float addedHeight, float groundNoiseAmplitudeHills, float lift) {
        float groundNoise = TerrainBase.groundNoise(x, y, groundNoiseAmplitudeHills, rtgWorld);
        float m = TerrainBase.hills(x, y, hillStrength, rtgWorld);
        float floNoise = addedHeight + groundNoise + m;
        return TerrainBase.riverized(floNoise + lift, river);
    }

    public static float terrainRollingHills(int x, int y, RTGWorld rtgWorld, float river, float hillStrength, float groundNoiseAmplitudeHills, float baseHeight) {
        float groundNoise = TerrainBase.groundNoise(x, y, groundNoiseAmplitudeHills, rtgWorld);
        float m = TerrainBase.hills(x, y, hillStrength, rtgWorld);
        float floNoise = groundNoise + m;
        return TerrainBase.riverized(floNoise + baseHeight, river);
    }

    public static float terrainSwampMountain(int x, int y, RTGWorld rtgWorld, float river, float width, float heigth, float hMax, float hDivisor, float baseHeight) {
        float d;
        SimplexNoise simplex = rtgWorld.simplexInstance(0);
        float h = simplex.noise2f((float)x / width, (float)y / width) * heigth * river;
        float f = h = (h *= h / hDivisor) > hMax ? hMax : h;
        if (h < 14.0f) {
            h += simplex.noise2f((float)x / 25.0f, (float)y / 25.0f) * (14.0f - h) * 0.8f;
        }
        if (h < 6.0f) {
            h = 6.0f - (6.0f - h) * 0.07f + simplex.noise2f((float)x / 20.0f, (float)y / 20.0f) + simplex.noise2f((float)x / 5.0f, (float)y / 5.0f);
        }
        if (h > 10.0f) {
            d = (h - 10.0f) / 2.0f > 8.0f ? 8.0f : (h - 10.0f) / 2.0f;
            h += simplex.noise2f((float)x / 35.0f, (float)y / 35.0f) * d;
            if ((h += simplex.noise2f((float)x / 60.0f, (float)y / 60.0f) * d * 0.5f) > 35.0f) {
                float d2 = (h - 35.0f) / 1.5f > 30.0f ? 30.0f : (h - 35.0f) / 1.5f;
                h += rtgWorld.simplexInstance(4).noise3f((float)x / 25.0f, (float)y / 25.0f, 1.0f) * d2;
            }
        }
        if (h > 2.0f) {
            d = (h - 2.0f) / 2.0f > 4.0f ? 4.0f : (h - 2.0f) / 2.0f;
            h += simplex.noise2f((float)x / 28.0f, (float)y / 28.0f) * d;
            h += simplex.noise2f((float)x / 18.0f, (float)y / 18.0f) * (d / 2.0f);
            h += simplex.noise2f((float)x / 8.0f, (float)y / 8.0f) * (d / 2.0f);
        }
        return TerrainBase.riverized(h + baseHeight, river);
    }

    public static float terrainVolcano(int x, int y, RTGWorld rtgWorld, float border, float baseHeight) {
        SimplexNoise simplex = rtgWorld.simplexInstance(0);
        CellularNoise cellularNoise = rtgWorld.cellularInstance(0);
        float st = 15.0f - (float)(cellularNoise.eval2D((double)x / 500.0, (double)y / 500.0).getShortestDistance() * 42.0) + simplex.noise2f((float)x / 30.0f, (float)y / 30.0f) * 2.0f;
        float h = st < 0.0f ? 0.0f : st;
        h = h < 0.0f ? 0.0f : h;
        if ((h += h * 0.4f * (h * 0.4f * 2.0f)) > 10.0f) {
            float d2 = (h - 10.0f) / 1.5f > 30.0f ? 30.0f : (h - 10.0f) / 1.5f;
            h = (float)((double)h + cellularNoise.eval2D((double)x / 25.0, (double)y / 25.0).getShortestDistance() * (double)d2);
        }
        h += simplex.noise2f((float)x / 18.0f, (float)y / 18.0f) * 3.0f;
        return baseHeight + (h += simplex.noise2f((float)x / 8.0f, (float)y / 8.0f) * 2.0f) * border;
    }

    public static float getRiverStrength(BlockPos blockPos, RTGWorld rtgWorld) {
        int worldX = blockPos.func_177958_n();
        int worldZ = blockPos.func_177952_p();
        double pX = worldX;
        double pZ = worldZ;
        ISimplexData2D jitterData = SimplexData2D.newDisk();
        rtgWorld.simplexInstance(1).multiEval2D((double)worldX / 240.0, (double)worldZ / 240.0, jitterData);
        pX += jitterData.getDeltaX() * rtgWorld.getRiverLargeBendSize();
        pZ += jitterData.getDeltaY() * rtgWorld.getRiverLargeBendSize();
        rtgWorld.simplexInstance(2).multiEval2D((double)worldX / 80.0, (double)worldZ / 80.0, jitterData);
        pX += jitterData.getDeltaX() * rtgWorld.getRiverSmallBendSize();
        pZ += jitterData.getDeltaY() * rtgWorld.getRiverSmallBendSize();
        double riverFactor = rtgWorld.cellularInstance(0).eval2D(pX /= rtgWorld.getRiverSeparation(), pZ /= rtgWorld.getRiverSeparation()).interiorValue();
        riverFactor = TerrainBase.bayesianAdjustment((float)riverFactor, 0.5f);
        if (riverFactor > rtgWorld.getRiverValleyLevel()) {
            return 0.0f;
        }
        return (float)(riverFactor / rtgWorld.getRiverValleyLevel() - 1.0);
    }

    public static float calcCliff(int x, int z, float[] noise) {
        float cliff = 0.0f;
        if (x > 0) {
            cliff = Math.max(cliff, Math.abs(noise[x * 16 + z] - noise[(x - 1) * 16 + z]));
        }
        if (z > 0) {
            cliff = Math.max(cliff, Math.abs(noise[x * 16 + z] - noise[x * 16 + z - 1]));
        }
        if (x < 15) {
            cliff = Math.max(cliff, Math.abs(noise[x * 16 + z] - noise[(x + 1) * 16 + z]));
        }
        if (z < 15) {
            cliff = Math.max(cliff, Math.abs(noise[x * 16 + z] - noise[x * 16 + z + 1]));
        }
        return cliff;
    }

    public static void calcSnowHeight(int x, int y, int z, ChunkPrimer primer, float[] noise) {
        if (y < 254) {
            byte h = (byte)((noise[x * 16 + z] - (float)((int)noise[x * 16 + z])) * 8.0f);
            if (h > 7) {
                primer.func_177855_a(x, y + 2, z, Blocks.field_150431_aC.func_176223_P());
                primer.func_177855_a(x, y + 1, z, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(7)));
            } else if (h > 0) {
                primer.func_177855_a(x, y + 1, z, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(h)));
            }
        }
    }

    public static float bayesianAdjustment(float probability, float multiplier) {
        if (probability >= 1.0f) {
            return probability;
        }
        if (probability <= 0.0f) {
            return probability;
        }
        float newConfidence = probability * multiplier / (1.0f - probability);
        return newConfidence / (1.0f + newConfidence);
    }

    public abstract float generateNoise(RTGWorld var1, int var2, int var3, float var4, float var5);
}

