/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.gen.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenSeaweed
extends WorldGenerator {
    protected IBlockState seaweedBlock;
    protected int height;
    protected ArrayList<Block> validGroundBlocks;

    public WorldGenSeaweed(IBlockState seaweedBlock, int height) {
        this.setSeaweedBlock(seaweedBlock);
        this.setHeight(height);
        this.setValidGroundBlocks(new ArrayList<Block>(Arrays.asList(Blocks.field_150346_d, Blocks.field_150351_n, Blocks.field_150435_aG, Blocks.field_150354_m)));
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (this.canGenerateAt(world, pos)) {
            if (this.seaweedBlock.func_177230_c().func_176196_c(world, pos)) {
                world.func_180501_a(pos, this.seaweedBlock, 2);
            }
            for (int i = 0; i < this.height; ++i) {
                int direction = rand.nextInt(4);
                switch (direction) {
                    case 0: {
                        --x;
                        break;
                    }
                    case 1: {
                        ++x;
                        break;
                    }
                    case 2: {
                        --z;
                        break;
                    }
                    case 3: {
                        ++z;
                        break;
                    }
                }
                BlockPos p = new BlockPos(x, y + i, z);
                IBlockState b = world.func_180495_p(p);
                if (b != Blocks.field_150355_j.func_176223_P() || !this.seaweedBlock.func_177230_c().func_176196_c(world, p)) continue;
                world.func_180501_a(p, this.seaweedBlock, 2);
            }
        }
        return true;
    }

    protected boolean canGenerateAt(World world, BlockPos pos) {
        Block groundBlock = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block belowBlock = world.func_180495_p(pos.func_177979_c(2)).func_177230_c();
        return this.getValidGroundBlocks().contains(groundBlock) && this.getValidGroundBlocks().contains(belowBlock);
    }

    public IBlockState getSeaweedBlock() {
        return this.seaweedBlock;
    }

    public WorldGenSeaweed setSeaweedBlock(IBlockState seaweedBlock) {
        this.seaweedBlock = seaweedBlock;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public WorldGenSeaweed setHeight(int height) {
        this.height = height;
        return this;
    }

    public ArrayList<Block> getValidGroundBlocks() {
        return this.validGroundBlocks;
    }

    public WorldGenSeaweed setValidGroundBlocks(ArrayList<Block> validGroundBlocks) {
        this.validGroundBlocks = validGroundBlocks;
        return this;
    }
}

