/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.util;

public class CircularSearchCreator {
    private boolean active = false;
    private int size;
    private float center;

    public int[] pattern(float maxRadius, int requestedSize) {
        if (this.active) {
            throw new RuntimeException();
        }
        this.active = true;
        this.size = requestedSize;
        this.center = ((float)this.size - 1.0f) / 2.0f;
        int[] result = new int[this.size * this.size];
        boolean[] found = new boolean[this.size * this.size];
        int nextResult = 0;
        int smallerHalfSize = this.size / 2;
        int largerHalfSize = (this.size + 1) / 2;
        for (float radius = 0.0f; radius < maxRadius; radius += 0.01f) {
            int y;
            int x;
            float distance;
            int index;
            int x2;
            int y2;
            for (y2 = 0; y2 < largerHalfSize; ++y2) {
                for (x2 = smallerHalfSize; x2 < this.size; ++x2) {
                    index = x2 * this.size + y2;
                    if (found[index] || (distance = this.distanceFromCenter(x2, y2)) > radius) continue;
                    result[nextResult++] = index;
                    found[index] = true;
                }
            }
            for (x = this.size - 1; x >= smallerHalfSize; --x) {
                for (y = largerHalfSize; y < this.size; ++y) {
                    index = x * this.size + y;
                    if (found[index] || (distance = this.distanceFromCenter(x, y)) > radius) continue;
                    result[nextResult++] = index;
                    found[index] = true;
                }
            }
            for (y2 = this.size - 1; y2 >= largerHalfSize - 1; --y2) {
                for (x2 = smallerHalfSize - 1; x2 > -1; --x2) {
                    index = x2 * this.size + y2;
                    if (found[index] || (distance = this.distanceFromCenter(x2, y2)) > radius) continue;
                    result[nextResult++] = index;
                    found[index] = true;
                }
            }
            for (x = 0; x < smallerHalfSize; ++x) {
                for (y = largerHalfSize - 1; y > -1; --y) {
                    index = x * this.size + y;
                    if (found[index] || (distance = this.distanceFromCenter(x, y)) > radius) continue;
                    result[nextResult++] = index;
                    found[index] = true;
                }
            }
        }
        this.active = false;
        if (nextResult < result.length) {
            int[] newResult = new int[nextResult];
            System.arraycopy(result, 0, newResult, 0, nextResult);
            result = newResult;
        }
        return result;
    }

    private float distanceFromCenter(int x, int y) {
        return (float)Math.sqrt(Math.pow((float)x - this.center, 2.0) + Math.pow((float)y - this.center, 2.0));
    }
}

