/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.thaumicjei.category;

import com.buuz135.thaumicjei.ThaumcraftJEIPlugin;
import com.buuz135.thaumicjei.ingredient.AspectIngredientRender;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;

public class AspectCompoundCategory
implements IRecipeCategory<AspectCompoundWrapper> {
    public static final String UUID = "THAUMCRAFT_ASPECT_COMPOUND";
    private final IGuiHelper helper;

    public AspectCompoundCategory(IGuiHelper helper) {
        this.helper = helper;
    }

    public String getUid() {
        return UUID;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"thaumicjei.category.aspect_compound.title", (Object[])new Object[0]);
    }

    public String getModName() {
        return "ThaumicJEI";
    }

    public IDrawable getBackground() {
        return this.helper.createBlankDrawable(108, 24);
    }

    public void drawExtras(Minecraft minecraft) {
        minecraft.field_71466_p.func_78276_b(TextFormatting.DARK_GRAY + "+", 32, 6, 0);
        minecraft.field_71466_p.func_78276_b(TextFormatting.DARK_GRAY + "=", 68, 6, 0);
    }

    public void setRecipe(IRecipeLayout recipeLayout, AspectCompoundWrapper recipeWrapper, IIngredients ingredients) {
        recipeLayout.getIngredientsGroup(ThaumcraftJEIPlugin.ASPECT_LIST).init(0, false, (IIngredientRenderer)new AspectIngredientRender(), 82, 2, 16, 16, 0, 0);
        recipeLayout.getIngredientsGroup(ThaumcraftJEIPlugin.ASPECT_LIST).set(0, (List)ingredients.getOutputs(ThaumcraftJEIPlugin.ASPECT_LIST).get(0));
        recipeLayout.getIngredientsGroup(ThaumcraftJEIPlugin.ASPECT_LIST).init(1, true, (IIngredientRenderer)new AspectIngredientRender(), 8, 2, 16, 16, 0, 0);
        recipeLayout.getIngredientsGroup(ThaumcraftJEIPlugin.ASPECT_LIST).init(2, true, (IIngredientRenderer)new AspectIngredientRender(), 46, 2, 16, 16, 0, 0);
        recipeLayout.getIngredientsGroup(ThaumcraftJEIPlugin.ASPECT_LIST).set(1, (List)ingredients.getInputs(ThaumcraftJEIPlugin.ASPECT_LIST).get(0));
        recipeLayout.getIngredientsGroup(ThaumcraftJEIPlugin.ASPECT_LIST).set(2, (List)ingredients.getInputs(ThaumcraftJEIPlugin.ASPECT_LIST).get(1));
    }

    public static class AspectCompoundWrapper
    implements IRecipeWrapper {
        private final Aspect aspect;

        public AspectCompoundWrapper(Aspect aspect) {
            this.aspect = aspect;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setOutput(ThaumcraftJEIPlugin.ASPECT_LIST, (Object)new AspectList().add(this.aspect, 1));
            ingredients.setInputs(ThaumcraftJEIPlugin.ASPECT_LIST, Arrays.stream(this.aspect.getComponents()).map(aspect1 -> new AspectList().add(aspect1, 1)).collect(Collectors.toList()));
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            String name = TextFormatting.DARK_GRAY + "" + this.aspect.getName();
            minecraft.field_71466_p.func_78276_b(name, 181 - minecraft.field_71466_p.func_78256_a(name) / 2, 36, 0);
            name = TextFormatting.DARK_GRAY + "" + this.aspect.getComponents()[0].getName();
            minecraft.field_71466_p.func_78276_b(name, 32 - minecraft.field_71466_p.func_78256_a(name) / 2, 36, 0);
            name = TextFormatting.DARK_GRAY + "" + this.aspect.getComponents()[1].getName();
            minecraft.field_71466_p.func_78276_b(name, 109 - minecraft.field_71466_p.func_78256_a(name) / 2, 36, 0);
            GL11.glDisable((int)3042);
            GL11.glPopMatrix();
        }
    }
}

