/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.ranks;

import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.DefaultRankConfigHandler;
import com.feed_the_beast.ftblib.lib.config.IRankConfigHandler;
import com.feed_the_beast.ftblib.lib.config.RankConfigValueInfo;
import com.feed_the_beast.ftbutilities.ranks.Ranks;
import com.mojang.authlib.GameProfile;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.server.permission.DefaultPermissionHandler;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.context.IContext;

public enum FTBUtilitiesPermissionHandler implements IPermissionHandler,
IRankConfigHandler
{
    INSTANCE;


    public void registerNode(String node, DefaultPermissionLevel level, String desc) {
        DefaultPermissionHandler.INSTANCE.registerNode(node, level, desc);
    }

    public Collection<String> getRegisteredNodes() {
        return DefaultPermissionHandler.INSTANCE.getRegisteredNodes();
    }

    public boolean hasPermission(GameProfile profile, String node, @Nullable IContext context) {
        if (context != null && context.getWorld() != null ? context.getWorld().field_72995_K : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(node) == DefaultPermissionLevel.ALL;
        }
        if (profile.getId() == null) {
            if (profile.getName() == null) {
                return false;
            }
            profile = new GameProfile(EntityPlayer.func_175147_b((String)profile.getName()), profile.getName());
        }
        switch (Ranks.INSTANCE.getPermissionResult(profile, node, true)) {
            case ALLOW: {
                return true;
            }
            case DENY: {
                return false;
            }
        }
        return DefaultPermissionHandler.INSTANCE.hasPermission(profile, node, context);
    }

    public String getNodeDescription(String node) {
        return DefaultPermissionHandler.INSTANCE.getNodeDescription(node);
    }

    public void registerRankConfig(RankConfigValueInfo info) {
        DefaultRankConfigHandler.INSTANCE.registerRankConfig(info);
    }

    public Collection<RankConfigValueInfo> getRegisteredConfigs() {
        return DefaultRankConfigHandler.INSTANCE.getRegisteredConfigs();
    }

    public ConfigValue getConfigValue(MinecraftServer server, GameProfile profile, String node) {
        ConfigNull value = ConfigNull.INSTANCE;
        if (Ranks.isActive()) {
            value = Ranks.INSTANCE.getPermission(profile, node, true);
        }
        return value.isNull() ? DefaultRankConfigHandler.INSTANCE.getConfigValue(server, profile, node) : value;
    }

    @Nullable
    public RankConfigValueInfo getInfo(String node) {
        return DefaultRankConfigHandler.INSTANCE.getInfo(node);
    }
}

