/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.world;

import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.utils.IPositionRotateble;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.util.LPSerializable;
import network.rs485.logisticspipes.world.ICoordinates;

public class DoubleCoordinates
implements IPositionRotateble,
ICoordinates,
LPSerializable {
    private double xCoord;
    private double yCoord;
    private double zCoord;

    public DoubleCoordinates() {
        this.setXCoord(0.0);
        this.setYCoord(0.0);
        this.setZCoord(0.0);
    }

    public DoubleCoordinates(double xCoord, double yCoord, double zCoord) {
        this.setXCoord(xCoord);
        this.setYCoord(yCoord);
        this.setZCoord(zCoord);
    }

    public DoubleCoordinates(LPDataInput input) {
        this.read(input);
    }

    public DoubleCoordinates(ICoordinates coords) {
        this(coords.getXDouble(), coords.getYDouble(), coords.getZDouble());
    }

    public DoubleCoordinates(TileEntity tile) {
        this(tile.func_174877_v());
    }

    public DoubleCoordinates(CoreUnroutedPipe pipe) {
        this(pipe.getX(), pipe.getY(), pipe.getZ());
    }

    public DoubleCoordinates(IPipeInformationProvider pipe) {
        this(pipe.getX(), pipe.getY(), pipe.getZ());
    }

    public DoubleCoordinates(CoordinatesPacket packet) {
        this(packet.getPosX(), packet.getPosY(), packet.getPosZ());
    }

    public DoubleCoordinates(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public DoubleCoordinates(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static DoubleCoordinates readFromNBT(String prefix, NBTTagCompound nbt) {
        if (nbt.func_74764_b(prefix + "xPos") && nbt.func_74764_b(prefix + "yPos") && nbt.func_74764_b(prefix + "zPos")) {
            return new DoubleCoordinates(nbt.func_74769_h(prefix + "xPos"), nbt.func_74769_h(prefix + "yPos"), nbt.func_74769_h(prefix + "zPos"));
        }
        return null;
    }

    @Override
    public double getXDouble() {
        return this.getXCoord();
    }

    @Override
    public double getYDouble() {
        return this.getYCoord();
    }

    @Override
    public double getZDouble() {
        return this.getZCoord();
    }

    @Override
    public int getXInt() {
        return (int)this.getXCoord();
    }

    @Override
    public int getYInt() {
        return (int)this.getYCoord();
    }

    @Override
    public int getZInt() {
        return (int)this.getZCoord();
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.getXCoord(), this.getYCoord(), this.getZCoord());
    }

    public TileEntity getTileEntity(IBlockAccess world) {
        return world.func_175625_s(this.getBlockPos());
    }

    public String toString() {
        return "(" + this.getXCoord() + ", " + this.getYCoord() + ", " + this.getZCoord() + ")";
    }

    public String toIntBasedString() {
        return "(" + this.getXCoord() + ", " + this.getYCoord() + ", " + this.getZCoord() + ")";
    }

    public Block getBlock(IBlockAccess world) {
        IBlockState state = this.getBlockState(world);
        return state == null ? null : state.func_177230_c();
    }

    public IBlockState getBlockState(IBlockAccess world) {
        return world.func_180495_p(this.getBlockPos());
    }

    public boolean blockExists(World world) {
        return !world.func_175623_d(this.getBlockPos());
    }

    public double distanceTo(DoubleCoordinates targetPos) {
        return Math.sqrt(Math.pow(targetPos.getXCoord() - this.getXCoord(), 2.0) + Math.pow(targetPos.getYCoord() - this.getYCoord(), 2.0) + Math.pow(targetPos.getZCoord() - this.getZCoord(), 2.0));
    }

    public DoubleCoordinates center() {
        DoubleCoordinates coords = new DoubleCoordinates();
        coords.setXCoord((double)this.getXInt() + 0.5);
        coords.setYCoord((double)this.getYInt() + 0.5);
        coords.setYCoord((double)this.getZInt() + 0.5);
        return this;
    }

    public void writeToNBT(String prefix, NBTTagCompound nbt) {
        nbt.func_74780_a(prefix + "xPos", this.xCoord);
        nbt.func_74780_a(prefix + "yPos", this.yCoord);
        nbt.func_74780_a(prefix + "zPos", this.zCoord);
    }

    public DoubleCoordinates add(DoubleCoordinates toAdd) {
        this.setXCoord(this.getXCoord() + toAdd.getXCoord());
        this.setYCoord(this.getYCoord() + toAdd.getYCoord());
        this.setZCoord(this.getZCoord() + toAdd.getZCoord());
        return this;
    }

    public void setBlockToAir(World world) {
        world.func_175698_g(this.getBlockPos());
    }

    @Override
    public void rotateLeft() {
        double tmp = this.getZCoord();
        this.setZCoord(-this.getXCoord());
        this.setXCoord(tmp);
    }

    @Override
    public void rotateRight() {
        double tmp = this.getXCoord();
        this.setXCoord(-this.getZCoord());
        this.setZCoord(tmp);
    }

    @Override
    public void mirrorX() {
        this.setXCoord(-this.getXCoord());
    }

    @Override
    public void mirrorZ() {
        this.setZCoord(-this.getZCoord());
    }

    public double getLength() {
        return Math.sqrt(this.getXDouble() * this.getXDouble() + this.getYDouble() * this.getYDouble() + this.getZDouble() * this.getZDouble());
    }

    @Override
    public void read(LPDataInput input) {
        this.xCoord = input.readDouble();
        this.yCoord = input.readDouble();
        this.zCoord = input.readDouble();
    }

    @Override
    public void write(LPDataOutput output) {
        output.writeDouble(this.xCoord);
        output.writeDouble(this.yCoord);
        output.writeDouble(this.zCoord);
    }

    public double getXCoord() {
        return this.xCoord;
    }

    public double getYCoord() {
        return this.yCoord;
    }

    public double getZCoord() {
        return this.zCoord;
    }

    public DoubleCoordinates setXCoord(double xCoord) {
        this.xCoord = xCoord;
        return this;
    }

    public DoubleCoordinates setYCoord(double yCoord) {
        this.yCoord = yCoord;
        return this;
    }

    public DoubleCoordinates setZCoord(double zCoord) {
        this.zCoord = zCoord;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoubleCoordinates)) {
            return false;
        }
        DoubleCoordinates other = (DoubleCoordinates)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getXCoord(), other.getXCoord()) != 0) {
            return false;
        }
        if (Double.compare(this.getYCoord(), other.getYCoord()) != 0) {
            return false;
        }
        return Double.compare(this.getZCoord(), other.getZCoord()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof DoubleCoordinates;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        long $xCoord = Double.doubleToLongBits(this.getXCoord());
        result2 = result2 * 59 + (int)($xCoord >>> 32 ^ $xCoord);
        long $yCoord = Double.doubleToLongBits(this.getYCoord());
        result2 = result2 * 59 + (int)($yCoord >>> 32 ^ $yCoord);
        long $zCoord = Double.doubleToLongBits(this.getZCoord());
        result2 = result2 * 59 + (int)($zCoord >>> 32 ^ $zCoord);
        return result2;
    }
}

