/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.util;

import java.util.BitSet;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.functions.Function1;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.utils.item.DictItemIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import network.rs485.logisticspipes.property.IBitSet;
import network.rs485.logisticspipes.util.FuzzyFlag;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J=\u0010\u0003\u001a\u00020\u00042%\u0010\u0005\u001a!\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00040\u0006j\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0007J-\u0010\u0013\u001a!\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00040\u0006j\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\u0011J-\u0010\u0013\u001a!\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00040\u0006j\u0002`\u000b2\u0006\u0010\u0010\u001a\u00020\u0012J\u0016\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0004J\u001e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0004\u00a8\u0006\u001a"}, d2={"Lnetwork/rs485/logisticspipes/util/FuzzyUtil;", "", "()V", "fuzzyMatches", "", "fuzzyFlagger", "Llogisticspipes/kotlin/Function1;", "Lnetwork/rs485/logisticspipes/util/FuzzyFlag;", "Llogisticspipes/kotlin/ParameterName;", "name", "flag", "Lnetwork/rs485/logisticspipes/util/FuzzyFlagger;", "firstItem", "Llogisticspipes/utils/item/ItemIdentifier;", "secondItem", "get", "fuzzyBitSet", "Ljava/util/BitSet;", "Lnetwork/rs485/logisticspipes/property/IBitSet;", "getter", "readFromNBT", "", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "set", "value", "logisticspipes"})
public final class FuzzyUtil {
    public static final FuzzyUtil INSTANCE;

    public final void readFromNBT(@NotNull IBitSet fuzzyBitSet, @NotNull NBTTagCompound tag) {
        Intrinsics.checkNotNullParameter(fuzzyBitSet, "fuzzyBitSet");
        Intrinsics.checkNotNullParameter(tag, "tag");
        FuzzyFlag[] $this$forEach$iv = FuzzyFlag.values();
        boolean $i$f$forEach = false;
        FuzzyFlag[] fuzzyFlagArray = $this$forEach$iv;
        int n = fuzzyFlagArray.length;
        for (int i = 0; i < n; ++i) {
            FuzzyFlag element$iv;
            FuzzyFlag it = element$iv = fuzzyFlagArray[i];
            boolean bl = false;
            fuzzyBitSet.set(it.getBit(), tag.func_74767_n(it.getNbtName()));
        }
    }

    public final void set(@NotNull IBitSet fuzzyBitSet, @NotNull FuzzyFlag flag, boolean value) {
        Intrinsics.checkNotNullParameter(fuzzyBitSet, "fuzzyBitSet");
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        fuzzyBitSet.set(flag.getBit(), value);
    }

    public final void set(@NotNull BitSet fuzzyBitSet, @NotNull FuzzyFlag flag, boolean value) {
        Intrinsics.checkNotNullParameter(fuzzyBitSet, "fuzzyBitSet");
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        fuzzyBitSet.set(flag.getBit(), value);
    }

    public final boolean get(@NotNull IBitSet fuzzyBitSet, @NotNull FuzzyFlag flag) {
        Intrinsics.checkNotNullParameter(fuzzyBitSet, "fuzzyBitSet");
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        return fuzzyBitSet.get(flag.getBit());
    }

    public final boolean get(@NotNull BitSet fuzzyBitSet, @NotNull FuzzyFlag flag) {
        Intrinsics.checkNotNullParameter(fuzzyBitSet, "fuzzyBitSet");
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        return fuzzyBitSet.get(flag.getBit());
    }

    @NotNull
    public final Function1<FuzzyFlag, Boolean> getter(@NotNull IBitSet fuzzyBitSet) {
        Intrinsics.checkNotNullParameter(fuzzyBitSet, "fuzzyBitSet");
        return new Function1<FuzzyFlag, Boolean>(fuzzyBitSet){
            final /* synthetic */ IBitSet $fuzzyBitSet;

            public final boolean invoke(@NotNull FuzzyFlag it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), "it");
                return FuzzyUtil.INSTANCE.get(this.$fuzzyBitSet, it);
            }
            {
                this.$fuzzyBitSet = iBitSet;
                super(1);
            }
        };
    }

    @NotNull
    public final Function1<FuzzyFlag, Boolean> getter(@NotNull BitSet fuzzyBitSet) {
        Intrinsics.checkNotNullParameter(fuzzyBitSet, "fuzzyBitSet");
        return new Function1<FuzzyFlag, Boolean>(fuzzyBitSet){
            final /* synthetic */ BitSet $fuzzyBitSet;

            public final boolean invoke(@NotNull FuzzyFlag it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), "it");
                return FuzzyUtil.INSTANCE.get(this.$fuzzyBitSet, it);
            }
            {
                this.$fuzzyBitSet = bitSet;
                super(1);
            }
        };
    }

    public final boolean fuzzyMatches(@NotNull Function1<? super FuzzyFlag, Boolean> fuzzyFlagger, @NotNull ItemIdentifier firstItem, @NotNull ItemIdentifier secondItem) {
        Intrinsics.checkNotNullParameter(fuzzyFlagger, "fuzzyFlagger");
        Intrinsics.checkNotNullParameter(firstItem, "firstItem");
        Intrinsics.checkNotNullParameter(secondItem, "secondItem");
        boolean useOreCategory = fuzzyFlagger.invoke(FuzzyFlag.USE_ORE_CATEGORY);
        if (fuzzyFlagger.invoke(FuzzyFlag.USE_ORE_DICT).booleanValue() || useOreCategory) {
            DictItemIdentifier firstDictIdent = firstItem.getDictIdentifiers();
            DictItemIdentifier secondDictIdent = secondItem.getDictIdentifiers();
            if (firstDictIdent != null && secondDictIdent != null && firstDictIdent.canMatch(secondDictIdent, true, useOreCategory)) {
                return true;
            }
        }
        ItemStack itemStack = firstItem.makeNormalStack(1);
        Intrinsics.checkNotNullExpressionValue(itemStack, "firstItem.makeNormalStack(1)");
        ItemStack firstStack = itemStack;
        ItemStack itemStack2 = secondItem.makeNormalStack(1);
        Intrinsics.checkNotNullExpressionValue(itemStack2, "secondItem.makeNormalStack(1)");
        ItemStack secondStack = itemStack2;
        if (firstStack.func_77973_b() != secondStack.func_77973_b()) {
            return false;
        }
        if (firstStack.func_77952_i() != secondStack.func_77952_i()) {
            if (firstStack.func_77981_g()) {
                return false;
            }
            if (!fuzzyFlagger.invoke(FuzzyFlag.IGNORE_DAMAGE).booleanValue()) {
                return false;
            }
        }
        if (fuzzyFlagger.invoke(FuzzyFlag.IGNORE_NBT).booleanValue()) {
            return true;
        }
        if (firstStack.func_77942_o() ^ secondStack.func_77942_o()) {
            return false;
        }
        return !firstStack.func_77942_o() && !secondStack.func_77942_o() ? true : ItemStack.func_77970_a((ItemStack)firstStack, (ItemStack)secondStack);
    }

    private FuzzyUtil() {
    }

    static {
        FuzzyUtil fuzzyUtil;
        INSTANCE = fuzzyUtil = new FuzzyUtil();
    }
}

