/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.jvm.functions.Function1;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.math.MathKt;
import logisticspipes.kotlin.ranges.IntRange;
import logisticspipes.kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import network.rs485.logisticspipes.gui.guidebook.GuiGuideBook;
import network.rs485.logisticspipes.gui.guidebook.LPGuiButton;
import network.rs485.logisticspipes.gui.guidebook.SliderButtonKt;
import network.rs485.logisticspipes.util.math.Rectangle;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001BP\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012!\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001a\u001a\u00020\bH\u0002J\b\u0010\u001b\u001a\u00020\u0003H\u0002J\u000e\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u0003J(\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\bH\u0016J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0010H\u0014J \u0010&\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0014J \u0010'\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0018\u0010(\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0010\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0003H\u0002J\b\u0010+\u001a\u00020\rH\u0002J\u0016\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R,\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/SliderButton;", "Lnetwork/rs485/logisticspipes/gui/guidebook/LPGuiButton;", "x", "", "y", "width", "railHeight", "progress", "", "setProgressCallback", "Llogisticspipes/kotlin/Function1;", "Llogisticspipes/kotlin/ParameterName;", "name", "", "(IIIIFLkotlin/jvm/functions/Function1;)V", "dragging", "", "hoveredBar", "initialMouseYOffset", "movementDistance", "getMovementDistance", "()I", "getSetProgressCallback", "()Lkotlin/jvm/functions/Function1;", "sliderButton", "Lnetwork/rs485/logisticspipes/util/math/Rectangle;", "calculateProgressF", "calculateProgressI", "changeProgress", "amount", "drawButton", "mc", "Lnet/minecraft/client/Minecraft;", "mouseX", "mouseY", "partialTicks", "getHoverState", "mouseOver", "mouseDragged", "mousePressed", "mouseReleased", "setProgressI", "progressI", "updateButtonY", "updateSlider", "extraHeight", "newProgress", "logisticspipes"})
public final class SliderButton
extends LPGuiButton {
    private final Rectangle sliderButton;
    private boolean dragging;
    private int initialMouseYOffset;
    private boolean hoveredBar;
    private float progress;
    @NotNull
    private final Function1<Float, Unit> setProgressCallback;

    private final int getMovementDistance() {
        return this.getBody().getRoundedHeight() - this.sliderButton.getRoundedHeight();
    }

    public void func_191745_a(@NotNull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        Intrinsics.checkNotNullParameter(mc, "mc");
        if (!this.field_146125_m) {
            return;
        }
        this.hoveredBar = this.sliderButton.translated(this.getBody()).contains(mouseX, mouseY);
        this.field_146123_n = this.getBody().contains(mouseX, mouseY);
        GuiGuideBook.Companion.drawSliderButton(this.sliderButton.translated(this.getBody()), SliderButtonKt.access$getTexture$p().translated(0, this.func_146114_a(this.hoveredBar) * SliderButtonKt.access$getTexture$p().getRoundedHeight()));
        this.func_146119_b(mc, mouseX, mouseY);
    }

    @Override
    protected int func_146114_a(boolean mouseOver) {
        return this.dragging ? 3 : (!this.field_146124_l ? 2 : (this.hoveredBar ? 1 : 0));
    }

    public void func_146118_a(int mouseX, int mouseY) {
        if (this.dragging) {
            this.dragging = false;
            this.setProgressI(mouseY - this.getBody().getRoundedY() - this.initialMouseYOffset);
            this.initialMouseYOffset = 0;
            this.setProgressCallback.invoke(Float.valueOf(this.progress));
        }
        super.func_146118_a(mouseX, mouseY);
    }

    protected void func_146119_b(@NotNull Minecraft mc, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter(mc, "mc");
        if (this.dragging) {
            this.setProgressI(mouseY - this.getBody().getRoundedY() - this.initialMouseYOffset);
            this.setProgressCallback.invoke(Float.valueOf(this.progress));
        }
    }

    @Override
    public boolean func_146116_c(@NotNull Minecraft mc, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter(mc, "mc");
        if (this.field_146125_m && this.field_146124_l) {
            if (this.hoveredBar) {
                this.dragging = true;
                this.initialMouseYOffset = mouseY - (int)this.sliderButton.translated(this.getBody()).getY0();
                return true;
            }
            if (this.field_146123_n) {
                this.setProgressI(mouseY - this.getBody().getRoundedTop() - this.sliderButton.getRoundedHeight() / 2);
                this.setProgressCallback.invoke(Float.valueOf(this.progress));
            }
        }
        return false;
    }

    private final void updateButtonY() {
        int y = (int)((float)this.getMovementDistance() * this.progress);
        this.sliderButton.setPos(this.sliderButton.getRoundedX(), y);
    }

    @NotNull
    public final SliderButton updateSlider(int extraHeight, float newProgress) {
        if (extraHeight > 0) {
            this.field_146124_l = true;
            this.sliderButton.setPos(0, this.calculateProgressI());
            int possibleHeight = this.getBody().getRoundedHeight() - extraHeight;
            int n = 16;
            this.sliderButton.setSize(this.getBody().getRoundedWidth(), RangesKt.coerceIn(possibleHeight % 2 == 0 ? possibleHeight - 1 : possibleHeight, new IntRange(n, this.getBody().getRoundedHeight())));
            this.progress = newProgress;
            this.updateButtonY();
        } else {
            this.field_146124_l = false;
            this.sliderButton.setPos(0, 0);
            this.sliderButton.setSize(this.getBody().getRoundedWidth(), 16);
            this.progress = 0.0f;
            this.updateButtonY();
        }
        return this;
    }

    private final void setProgressI(int progressI) {
        this.sliderButton.setPos(this.sliderButton.getRoundedX(), RangesKt.coerceIn(progressI, 0, this.getMovementDistance()));
        this.progress = this.calculateProgressF();
    }

    public final void changeProgress(int amount) {
        this.sliderButton.setPos(this.sliderButton.getX0(), RangesKt.coerceIn(this.sliderButton.getY0() + (float)amount, 0.0f, (float)this.getMovementDistance()));
        this.progress = this.calculateProgressF();
        this.setProgressCallback.invoke(Float.valueOf(this.progress));
    }

    private final int calculateProgressI() {
        return MathKt.roundToInt((float)this.getMovementDistance() * this.progress);
    }

    private final float calculateProgressF() {
        return this.sliderButton.getY0() / (float)this.getMovementDistance();
    }

    @NotNull
    public final Function1<Float, Unit> getSetProgressCallback() {
        return this.setProgressCallback;
    }

    public SliderButton(int x, int y, int width, int railHeight, float progress, @NotNull Function1<? super Float, Unit> setProgressCallback) {
        Intrinsics.checkNotNullParameter(setProgressCallback, "setProgressCallback");
        super(0, x, y, width, railHeight);
        this.progress = progress;
        this.setProgressCallback = setProgressCallback;
        this.sliderButton = new Rectangle();
        this.field_73735_i = 31.0f;
    }
}

