/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.gui.extention;

import java.util.ArrayList;
import java.util.List;

public abstract class GuiExtention {
    private boolean extending;
    private int currentW = this.getMinimumWidth();
    private int currentH = this.getMinimumHeight();
    private int currentXPos = 0;
    private int currentYPos = 0;
    private int targetYPos = 0;
    private boolean init = true;
    private long lastTime;
    private List<Integer> slotList = new ArrayList<Integer>();
    private List<Integer> buttonList = new ArrayList<Integer>();

    public abstract int getFinalWidth();

    public abstract int getFinalHeight();

    public abstract void renderForground(int var1, int var2);

    public final void update(int xPos, int yPos) {
        double d = 0.0;
        if (this.lastTime > 0L) {
            long time = System.currentTimeMillis();
            d = (double)(time - this.lastTime) * 1.0 / 5.0;
            if (d < 1.0) {
                d = 0.0;
            } else {
                this.lastTime = time;
            }
            d = Math.min(d, 20.0);
        } else {
            this.lastTime = System.currentTimeMillis();
        }
        this.currentXPos = xPos;
        this.currentYPos = (double)yPos > (double)this.currentYPos + 1.0 * d && !this.init ? (int)((double)this.currentYPos + 2.0 * d) : ((double)yPos < (double)this.currentYPos - 1.0 * d && !this.init ? (int)((double)this.currentYPos - 2.0 * d) : yPos);
        this.targetYPos = yPos;
        this.init = false;
        if (this.extending) {
            this.currentH = this.currentH < this.getFinalHeight() ? (int)((double)this.currentH + 4.0 * d) : this.getFinalHeight();
            this.currentW = this.currentW < this.getFinalWidth() ? (int)((double)this.currentW + 2.0 * d) : this.getFinalWidth();
        } else {
            this.currentH = this.currentH > this.getMinimumHeight() ? (int)((double)this.currentH - 4.0 * d) : this.getMinimumHeight();
            this.currentW = this.currentW > this.getMinimumWidth() ? (int)((double)this.currentW - 2.0 * d) : this.getMinimumWidth();
        }
    }

    public int getMinimumWidth() {
        return 23;
    }

    public int getMinimumHeight() {
        return 26;
    }

    public int getCurrentWidth() {
        return this.currentW;
    }

    public int getCurrentHeight() {
        return this.currentH;
    }

    public boolean isFullyExtended() {
        return this.currentW == this.getFinalWidth() && this.currentH == this.getFinalHeight() && this.targetYPos == this.currentYPos;
    }

    public boolean isFullyRetracted() {
        return this.currentW == this.getMinimumWidth() && this.currentH == this.getMinimumHeight() && this.targetYPos == this.currentYPos;
    }

    public void handleMouseOverAt(int xPos, int yPos) {
    }

    public void registerSlot(int id) {
        this.slotList.add(id);
    }

    public boolean renderSlot(int id) {
        return this.slotList.contains(id);
    }

    public boolean renderSelectSlot(int id) {
        return this.slotList.contains(id);
    }

    public void registerButton(int id) {
        this.buttonList.add(id);
    }

    public boolean renderButton(int id) {
        return this.buttonList.contains(id);
    }

    public boolean isExtending() {
        return this.extending;
    }

    GuiExtention setExtending(boolean extending) {
        this.extending = extending;
        return this;
    }

    public int getCurrentXPos() {
        return this.currentXPos;
    }

    public int getCurrentYPos() {
        return this.currentYPos;
    }
}

