/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.transport;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import javax.annotation.Nonnull;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.blocks.powertile.LogisticsPowerJunctionTileEntity;
import logisticspipes.interfaces.IBufferItems;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IItemAdvancedExistance;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.ISpecialInsertion;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.routing.ITargetSlotInformation;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.pipe.ItemBufferSyncPacket;
import logisticspipes.network.packets.pipe.PipeContentPacket;
import logisticspipes.network.packets.pipe.PipeContentRequest;
import logisticspipes.network.packets.pipe.PipePositionPacket;
import logisticspipes.pipes.PipeItemsFluidSupplier;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ItemRoutingInformation;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.transport.LPItemList;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.SyncList;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import network.rs485.logisticspipes.util.items.ItemStackLoader;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class PipeTransportLogistics {
    private final int _bufferTimeOut = 40;
    public final SyncList<Triplet<ItemIdentifierStack, Pair<Integer, Integer>, LPTravelingItem.LPTravelingItemServer>> _itemBuffer = new SyncList();
    private Chunk chunk;
    public LPItemList items = new LPItemList(this);
    public LogisticsTileGenericPipe container;
    public final boolean isRouted;
    public final int MAX_DESTINATION_UNREACHABLE_BUFFER = 30;

    public PipeTransportLogistics(boolean isRouted) {
        this.isRouted = isRouted;
    }

    public void initialize() {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            this.chunk = this.getWorld().func_175726_f(this.container.func_174877_v());
            ItemBufferSyncPacket packet = PacketHandler.getPacket(ItemBufferSyncPacket.class);
            packet.setTilePos(this.container);
            this._itemBuffer.setPacketType(packet, this.getWorld().field_73011_w.getDimension(), this.container.getX(), this.container.getZ());
        }
    }

    public void markChunkModified(TileEntity tile) {
        if (tile != null && this.chunk != null && (this.container.func_174877_v().func_177958_n() >> 4 != tile.func_174877_v().func_177958_n() >> 4 || this.container.func_174877_v().func_177952_p() >> 4 != tile.func_174877_v().func_177952_p() >> 4)) {
            this.chunk.func_76630_e();
            if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe != null && ((LogisticsTileGenericPipe)tile).pipe.transport != null && ((LogisticsTileGenericPipe)tile).pipe.transport.chunk != null) {
                ((LogisticsTileGenericPipe)tile).pipe.transport.chunk.func_76630_e();
            } else {
                this.getWorld().func_175726_f(tile.func_174877_v()).func_76630_e();
            }
        }
    }

    protected CoreUnroutedPipe getPipe() {
        return this.container.pipe;
    }

    protected CoreRoutedPipe getRoutedPipe() {
        if (!this.isRouted) {
            throw new UnsupportedOperationException("Can't use a Transport pipe as a routing pipe");
        }
        return (CoreRoutedPipe)this.container.pipe;
    }

    public void updateEntity() {
        this.moveSolids();
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            if (!this._itemBuffer.isEmpty()) {
                LinkedList<LPTravelingItem.LPTravelingItemServer> toAdd = new LinkedList<LPTravelingItem.LPTravelingItemServer>();
                Iterator<Triplet<ItemIdentifierStack, Pair<Integer, Integer>, LPTravelingItem.LPTravelingItemServer>> iterator2 = this._itemBuffer.iterator();
                while (iterator2.hasNext()) {
                    Triplet<ItemIdentifierStack, Pair<Integer, Integer>, LPTravelingItem.LPTravelingItemServer> next = iterator2.next();
                    int n = (Integer)((Pair)next.getValue2()).getValue1();
                    if (n > 0) {
                        ((Pair)next.getValue2()).setValue1(n - 1);
                        continue;
                    }
                    if (next.getValue3() != null) {
                        if (this.getRoutedPipe().getRouter().hasRoute(next.getValue3().getDestination(), next.getValue3().getTransportMode() == IRoutedItem.TransportMode.Active, next.getValue3().getItemIdentifierStack().getItem()) || (Integer)((Pair)next.getValue2()).getValue2() > 30) {
                            next.getValue3().setBufferCounter((Integer)((Pair)next.getValue2()).getValue2() + 1);
                            toAdd.add(next.getValue3());
                            iterator2.remove();
                            continue;
                        }
                        ((Pair)next.getValue2()).setValue2((Integer)((Pair)next.getValue2()).getValue2() + 1);
                        ((Pair)next.getValue2()).setValue1(40);
                        continue;
                    }
                    LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem((ItemIdentifierStack)next.getValue1());
                    item.setDoNotBuffer(true);
                    item.setBufferCounter((Integer)((Pair)next.getValue2()).getValue2() + 1);
                    toAdd.add(item);
                    iterator2.remove();
                }
                for (LPTravelingItem lPTravelingItem : toAdd) {
                    this.injectItem(lPTravelingItem, EnumFacing.UP);
                }
            }
            this._itemBuffer.sendUpdateToWaters();
        }
    }

    public void dropBuffer() {
        Iterator<Triplet<ItemIdentifierStack, Pair<Integer, Integer>, LPTravelingItem.LPTravelingItemServer>> iterator2 = this._itemBuffer.iterator();
        while (iterator2.hasNext()) {
            ItemIdentifierStack next = (ItemIdentifierStack)iterator2.next().getValue1();
            MainProxy.dropItems(this.getWorld(), next.makeNormalStack(), this.getPipe().getX(), this.getPipe().getY(), this.getPipe().getZ());
            iterator2.remove();
        }
    }

    public int injectItem(LPTravelingItem.LPTravelingItemServer item, EnumFacing inputOrientation) {
        return this.injectItem((LPTravelingItem)item, inputOrientation);
    }

    public float getPipeLength() {
        return 1.0f;
    }

    public double getDistanceWeight() {
        return 1.0;
    }

    public float getYawDiff(LPTravelingItem item) {
        return 0.0f;
    }

    public int injectItem(LPTravelingItem item, EnumFacing inputOrientation) {
        if (item.isCorrupted()) {
            return 0;
        }
        this.getPipe().triggerDebug();
        int originalCount = item.getItemIdentifierStack().getStackSize();
        item.input = inputOrientation;
        if (MainProxy.isServer((IBlockAccess)this.container.func_145831_w())) {
            this.readjustSpeed((LPTravelingItem.LPTravelingItemServer)item);
            ItemRoutingInformation info1 = ((LPTravelingItem.LPTravelingItemServer)item).getInfo().clone();
            RoutingResult result2 = this.resolveDestination((LPTravelingItem.LPTravelingItemServer)item);
            item.output = result2.getFace();
            if (!result2.hasRoute) {
                return 0;
            }
            this.getPipe().debug.log("Injected Item: [" + item.input + ", " + item.output + "] (" + info1);
        } else {
            item.output = null;
        }
        if (item.getPosition() >= this.getPipeLength()) {
            this.reachedEnd(item);
        } else {
            this.items.add(item);
            if (MainProxy.isServer((IBlockAccess)this.container.func_145831_w()) && !this.getPipe().isOpaque() && item.getItemIdentifierStack().getStackSize() > 0) {
                this.sendItemPacket((LPTravelingItem.LPTravelingItemServer)item);
            }
        }
        return originalCount - item.getItemIdentifierStack().getStackSize();
    }

    public int injectItem(IRoutedItem item, EnumFacing inputOrientation) {
        return this.injectItem((LPTravelingItem)SimpleServiceLocator.routedItemHelper.getServerTravelingItem(item), inputOrientation);
    }

    protected void reverseItem(LPTravelingItem.LPTravelingItemServer item) {
        if (item.isCorrupted()) {
            return;
        }
        if (this.getPipe() instanceof IBufferItems) {
            item.getItemIdentifierStack().setStackSize(((IBufferItems)((Object)this.getPipe())).addToBuffer(item.getItemIdentifierStack(), item.getAdditionalTargetInformation()));
            if (item.getItemIdentifierStack().getStackSize() <= 0) {
                return;
            }
        }
        item.id = item.getNextId();
        if (item.getPosition() >= this.getPipeLength()) {
            item.setPosition(item.getPosition() - this.getPipeLength());
        }
        item.input = item.output.func_176734_d();
        this.readjustSpeed(item);
        RoutingResult result2 = this.resolveDestination(item);
        item.output = result2.getFace();
        if (!result2.hasRoute) {
            return;
        }
        if (item.output == null) {
            this.dropItem(item);
            return;
        }
        this.items.unscheduleRemoval(item);
        if (!this.getPipe().isOpaque()) {
            this.sendItemPacket(item);
        }
    }

    public RoutingResult resolveDestination(LPTravelingItem.LPTravelingItemServer data) {
        if (this.isRouted) {
            return this.resolveRoutedDestination(data);
        }
        return this.resolveUnroutedDestination(data);
    }

    public RoutingResult resolveUnroutedDestination(LPTravelingItem.LPTravelingItemServer data) {
        ArrayList<EnumFacing> dirs = new ArrayList<EnumFacing>(Arrays.asList(EnumFacing.field_82609_l));
        dirs.remove(data.input.func_176734_d());
        Iterator iter = dirs.iterator();
        while (iter.hasNext()) {
            EnumFacing dir = (EnumFacing)iter.next();
            DoubleCoordinates pos = CoordinateUtils.add(this.getPipe().getLPPosition(), dir);
            TileEntity tile = pos.getTileEntity((IBlockAccess)this.getWorld());
            if (!SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) {
                iter.remove();
                continue;
            }
            if (!this.canPipeConnect(tile, dir)) {
                iter.remove();
                continue;
            }
            if (!(tile instanceof LogisticsTileGenericPipe) || ((LogisticsTileGenericPipe)tile).canConnect(this.container, dir.func_176734_d(), false)) continue;
            iter.remove();
        }
        if (dirs.isEmpty()) {
            return new RoutingResult(null, false);
        }
        int num = new Random().nextInt(dirs.size());
        return new RoutingResult((EnumFacing)dirs.get(num), true);
    }

    public RoutingResult resolveRoutedDestination(LPTravelingItem.LPTravelingItemServer data) {
        EnumFacing value;
        EnumFacing blocked = null;
        if (data.getDestinationUUID() == null) {
            ItemIdentifierStack stack = data.getItemIdentifierStack();
            ItemRoutingInformation result2 = this.getRoutedPipe().getQueuedForItemStack(stack);
            if (result2 != null) {
                data.setInformation(result2);
                data.getInfo().setItem(stack);
                blocked = data.input.func_176734_d();
            }
        }
        if (data.getItemIdentifierStack() != null) {
            this.getRoutedPipe().relayedItem(data.getItemIdentifierStack().getStackSize());
        }
        if (data.getDestination() >= 0 && !this.getRoutedPipe().getRouter().hasRoute(data.getDestination(), data.getTransportMode() == IRoutedItem.TransportMode.Active, data.getItemIdentifierStack().getItem()) && data.getBufferCounter() < 30) {
            this._itemBuffer.add(new Triplet<ItemIdentifierStack, Pair<Integer, Integer>, LPTravelingItem.LPTravelingItemServer>(data.getItemIdentifierStack(), new Pair<Integer, Integer>(40, data.getBufferCounter()), data));
            return new RoutingResult(null, false);
        }
        if (this.getRoutedPipe().stillNeedReplace() || this.getRoutedPipe().initialInit()) {
            data.setDoNotBuffer(false);
            value = null;
        } else {
            value = this.getRoutedPipe().getRouteLayer().getOrientationForItem(data, blocked);
        }
        if (value == null && MainProxy.isClient((IBlockAccess)this.getWorld())) {
            return new RoutingResult(null, true);
        }
        if (value == null && !data.getDoNotBuffer() && data.getBufferCounter() < 5) {
            this._itemBuffer.add(new Triplet<ItemIdentifierStack, Pair<Integer, Integer>, Object>(data.getItemIdentifierStack(), new Pair<Integer, Integer>(40, data.getBufferCounter()), null));
            return new RoutingResult(null, false);
        }
        if (value != null && !this.getRoutedPipe().getRouter().isRoutedExit(value) && this.isItemUnwanted(data.getItemIdentifierStack())) {
            return new RoutingResult(null, false);
        }
        data.resetDelay();
        return new RoutingResult(value, true);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = nbt.func_150295_c("travelingEntities", 10);
        for (int j = 0; j < nbttaglist.func_74745_c(); ++j) {
            try {
                NBTTagCompound dataTag = nbttaglist.func_150305_b(j);
                LPTravelingItem.LPTravelingItemServer item = new LPTravelingItem.LPTravelingItemServer(dataTag);
                if (item.isCorrupted()) continue;
                this.items.scheduleLoad(item);
                continue;
            }
            catch (Throwable dataTag) {
                // empty catch block
            }
        }
        this._itemBuffer.clear();
        NBTTagList nbttaglist2 = nbt.func_150295_c("buffercontents", 10);
        for (int i = 0; i < nbttaglist2.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist2.func_150305_b(i);
            this._itemBuffer.add(new Triplet<ItemIdentifierStack, Pair<Integer, Integer>, Object>(ItemIdentifierStack.getFromStack(ItemStackLoader.loadAndFixItemStackFromNBT(nbttagcompound1)), new Pair<Integer, Integer>(40, 0), null));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList nbttaglist = new NBTTagList();
        for (LPTravelingItem lPTravelingItem : this.items) {
            if (!(lPTravelingItem instanceof LPTravelingItem.LPTravelingItemServer)) continue;
            NBTTagCompound dataTag = new NBTTagCompound();
            nbttaglist.func_74742_a((NBTBase)dataTag);
            ((LPTravelingItem.LPTravelingItemServer)lPTravelingItem).writeToNBT(dataTag);
        }
        nbt.func_74782_a("travelingEntities", (NBTBase)nbttaglist);
        NBTTagList nbttaglist2 = new NBTTagList();
        for (Pair pair : this._itemBuffer) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            ((ItemIdentifierStack)pair.getValue1()).makeNormalStack().func_77955_b(nbttagcompound1);
            nbttaglist2.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbt.func_74782_a("buffercontents", (NBTBase)nbttaglist2);
    }

    public void readjustSpeed(LPTravelingItem.LPTravelingItemServer item) {
        float defaultBoost;
        switch (item.getTransportMode()) {
            case Default: {
                defaultBoost = 20.0f;
                break;
            }
            case Passive: {
                defaultBoost = 25.0f;
                break;
            }
            case Active: {
                defaultBoost = 30.0f;
                break;
            }
            case Unknown: {
                defaultBoost = 20.0f;
                break;
            }
            default: {
                defaultBoost = 20.0f;
            }
        }
        if (this.isRouted) {
            float multiplyerSpeed = 1.0f + 0.02f * (float)this.getRoutedPipe().getUpgradeManager().getSpeedUpgradeCount();
            float multiplyerPower = 1.0f + 0.03f * (float)this.getRoutedPipe().getUpgradeManager().getSpeedUpgradeCount();
            float add2 = Math.max(item.getSpeed(), 0.01f * defaultBoost * multiplyerPower) - item.getSpeed();
            if (this.getRoutedPipe().useEnergy((int)((double)(add2 * 50.0f) + 0.5))) {
                item.setSpeed(Math.min(Math.max(item.getSpeed(), 0.01f * defaultBoost * multiplyerSpeed), 1.0f));
            }
        }
    }

    protected void handleTileReachedServer(LPTravelingItem.LPTravelingItemServer arrivingItem, TileEntity tile, EnumFacing dir) {
        this.handleTileReachedServer_internal(arrivingItem, tile, dir);
    }

    protected final void handleTileReachedServer_internal(LPTravelingItem.LPTravelingItemServer arrivingItem, TileEntity tile, EnumFacing dir) {
        if (this.getPipe() instanceof PipeItemsFluidSupplier) {
            ((PipeItemsFluidSupplier)this.getPipe()).endReached(arrivingItem, tile);
            if (arrivingItem.getItemIdentifierStack().getStackSize() <= 0) {
                return;
            }
        }
        this.markChunkModified(tile);
        if (arrivingItem.getInfo() != null && arrivingItem.getArrived() && this.isRouted) {
            this.getRoutedPipe().notifyOfItemArival(arrivingItem.getInfo());
        }
        if (this.getPipe() instanceof FluidRoutedPipe && ((FluidRoutedPipe)this.getPipe()).endReached(arrivingItem, tile)) {
            return;
        }
        boolean isSpecialConnectionInformationTransition = false;
        if (SimpleServiceLocator.specialtileconnection.needsInformationTransition(tile)) {
            isSpecialConnectionInformationTransition = true;
            SimpleServiceLocator.specialtileconnection.transmit(tile, arrivingItem);
        }
        if (SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) {
            if (this.passToNextPipe(arrivingItem, tile)) {
                return;
            }
        } else {
            IInventoryUtil util = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(tile, dir.func_176734_d());
            if (util != null && this.isRouted) {
                this.getRoutedPipe().getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
                if (!isSpecialConnectionInformationTransition && this.isItemUnwanted(arrivingItem.getItemIdentifierStack())) {
                    return;
                }
                if (arrivingItem.getTransportMode() != IRoutedItem.TransportMode.Active && !this.getRoutedPipe().getTransportLayer().stillWantItem(arrivingItem)) {
                    this.reverseItem(arrivingItem);
                    return;
                }
                LogisticsModule.ModulePositionType slot = null;
                int positionInt = -1;
                if (arrivingItem.getInfo().targetInfo instanceof PipeLogisticsChassis.ChassiTargetInformation) {
                    positionInt = ((PipeLogisticsChassis.ChassiTargetInformation)arrivingItem.getInfo().targetInfo).getModuleSlot();
                    slot = LogisticsModule.ModulePositionType.SLOT;
                } else if (LogisticsPipes.isDEBUG() && this.container.pipe instanceof PipeLogisticsChassis) {
                    System.out.println(arrivingItem);
                    new RuntimeException("[ItemInsertion] Information weren't ment for a chassi pipe").printStackTrace();
                }
                ISlotUpgradeManager slotManager = this.getRoutedPipe().getUpgradeManager(slot, positionInt);
                if (arrivingItem.getAdditionalTargetInformation() instanceof ITargetSlotInformation) {
                    ITargetSlotInformation information = (ITargetSlotInformation)((Object)arrivingItem.getAdditionalTargetInformation());
                    if (util instanceof ISpecialInsertion) {
                        int slot2 = information.getTargetSlot();
                        int amount = information.getAmount();
                        if (util.getSizeInventory() > slot2) {
                            ItemStack content = util.getStackInSlot(slot2);
                            ItemStack toAdd = arrivingItem.getItemIdentifierStack().makeNormalStack();
                            int amountLeft = Math.max(0, amount - content.func_190916_E());
                            toAdd.func_190920_e(Math.min(toAdd.func_190916_E(), amountLeft));
                            if (toAdd.func_190916_E() > 0 && util.getSizeInventory() > slot2) {
                                int added = ((ISpecialInsertion)((Object)util)).addToSlot(toAdd, slot2);
                                arrivingItem.getItemIdentifierStack().lowerStackSize(added);
                            }
                        }
                        if (information.isLimited()) {
                            if (arrivingItem.getItemIdentifierStack().getStackSize() > 0) {
                                this.reverseItem(arrivingItem);
                            }
                            return;
                        }
                    }
                }
                if (!this.getRoutedPipe().getUpgradeManager().hasCombinedSneakyUpgrade() || slotManager.hasOwnSneakyUpgrade()) {
                    EnumFacing insertion = arrivingItem.output.func_176734_d();
                    if (slotManager.hasSneakyUpgrade()) {
                        insertion = slotManager.getSneakyOrientation();
                    }
                    if (this.insertArrivingItem(arrivingItem, tile, insertion)) {
                        return;
                    }
                } else {
                    EnumFacing[] dirs;
                    for (EnumFacing insertion : dirs = this.getRoutedPipe().getUpgradeManager().getCombinedSneakyOrientation()) {
                        if (insertion == null || !this.insertArrivingItem(arrivingItem, tile, insertion)) continue;
                        return;
                    }
                }
                if (arrivingItem.getItemIdentifierStack().getStackSize() > 0) {
                    this.reverseItem(arrivingItem);
                }
                return;
            }
        }
        this.dropItem(arrivingItem);
    }

    private boolean insertArrivingItem(LPTravelingItem.LPTravelingItemServer arrivingItem, TileEntity tile, EnumFacing insertion) {
        boolean isSplitStack;
        ItemStack added = InventoryHelper.getTransactorFor(tile, insertion).add(arrivingItem.getItemIdentifierStack().makeNormalStack(), insertion, true);
        arrivingItem.getItemIdentifierStack().lowerStackSize(added.func_190916_E());
        if (added.func_190916_E() > 0) {
            arrivingItem.setBufferCounter(0);
        }
        ItemRoutingInformation info = arrivingItem.getInfo();
        boolean bl = isSplitStack = arrivingItem.getItemIdentifierStack().getStackSize() > 0;
        if (isSplitStack) {
            info = info.clone();
        }
        info.getItem().setStackSize(added.func_190916_E());
        this.inventorySystemConnectorHook(info, tile);
        return !isSplitStack;
    }

    protected void handleTileReachedClient(LPTravelingItem.LPTravelingItemClient arrivingItem, TileEntity tile, EnumFacing dir) {
        if (SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) {
            this.passToNextPipe(arrivingItem, tile);
        }
    }

    protected boolean isItemUnwanted(ItemIdentifierStack itemIdentifierStack) {
        if (itemIdentifierStack != null && itemIdentifierStack.makeNormalStack().func_77973_b() instanceof IItemAdvancedExistance) {
            return !((IItemAdvancedExistance)itemIdentifierStack.makeNormalStack().func_77973_b()).canExistInNormalInventory(itemIdentifierStack.makeNormalStack());
        }
        return false;
    }

    protected void inventorySystemConnectorHook(ItemRoutingInformation info, TileEntity tile) {
    }

    public boolean canPipeConnect(TileEntity tile, EnumFacing side) {
        return this.canPipeConnect_internal(tile, side);
    }

    public final boolean canPipeConnect_internal(TileEntity tile, EnumFacing side) {
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe != null && ((LogisticsTileGenericPipe)tile).pipe.isHSTube() && !((LogisticsTileGenericPipe)tile).pipe.actAsNormalPipe()) {
            return false;
        }
        if (this.isRouted) {
            EnumFacing ori;
            if ((tile instanceof ILogisticsPowerProvider || tile instanceof ISubSystemPowerProvider) && (ori = OrientationsUtil.getOrientationOfTilewithTile(this.container, tile)) != null) {
                return !(tile instanceof LogisticsPowerJunctionTileEntity) && !(tile instanceof ISubSystemPowerProvider) || ori.func_176740_k() != EnumFacing.Axis.Y;
            }
            if (SimpleServiceLocator.betterStorageProxy.isBetterStorageCrate(tile) || SimpleServiceLocator.factorizationProxy.isBarral(tile) || SimpleServiceLocator.enderIOProxy.isItemConduit(tile, side.func_176734_d()) || this.getPipe().getUpgradeManager().hasRFPowerSupplierUpgrade() && SimpleServiceLocator.powerProxy.isEnergyReceiver(tile, side.func_176734_d()) || this.getPipe().getUpgradeManager().getIC2PowerLevel() > 0 && SimpleServiceLocator.IC2Proxy.isEnergySink(tile)) {
                return true;
            }
            IInventoryUtil util = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(tile, side.func_176734_d());
            if (util != null) {
                return util.getSizeInventory() > 0;
            }
            return this.isPipeCheck(tile);
        }
        return this.isPipeCheck(tile);
    }

    protected boolean isPipeCheck(TileEntity tile) {
        return SimpleServiceLocator.pipeInformationManager.isItemPipe(tile);
    }

    protected void reachedEnd(LPTravelingItem item) {
        TileEntity tile = this.container.getTile(item.output);
        if (this.items.scheduleRemoval(item)) {
            if (MainProxy.isServer((IBlockAccess)this.container.func_145831_w())) {
                this.handleTileReachedServer((LPTravelingItem.LPTravelingItemServer)item, tile, item.output);
            } else {
                this.handleTileReachedClient((LPTravelingItem.LPTravelingItemClient)item, tile, item.output);
            }
        }
    }

    private void moveSolids() {
        this.items.flush();
        this.items.scheduleAdd();
        for (LPTravelingItem item : this.items) {
            if (item.lastTicked >= MainProxy.getGlobalTick()) continue;
            item.lastTicked = MainProxy.getGlobalTick();
            item.addAge();
            item.setPosition(item.getPosition() + item.getSpeed());
            if (!this.hasReachedEnd(item)) continue;
            if (item.output == null) {
                if (MainProxy.isServer((IBlockAccess)this.container.func_145831_w())) {
                    this.dropItem((LPTravelingItem.LPTravelingItemServer)item);
                }
                this.items.scheduleRemoval(item);
                continue;
            }
            this.reachedEnd(item);
        }
        this.items.removeScheduledItems();
        this.items.addScheduledItems();
    }

    protected boolean passToNextPipe(LPTravelingItem item, TileEntity tile) {
        IPipeInformationProvider information = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(tile);
        if (information != null) {
            item.setPosition(item.getPosition() - this.getPipeLength());
            item.setYaw(item.getYaw() + this.getYawDiff(item));
            return information.acceptItem(item, this.container);
        }
        return false;
    }

    private void dropItem(LPTravelingItem.LPTravelingItemServer item) {
        if (MainProxy.isClient((IBlockAccess)this.container.func_145831_w())) {
            return;
        }
        item.setSpeed(0.05f);
        item.setContainer(this.container);
        EntityItem entity = item.toEntityItem();
        if (entity != null) {
            this.container.func_145831_w().func_72838_d((Entity)entity);
        }
    }

    protected boolean hasReachedEnd(LPTravelingItem item) {
        return item.getPosition() >= (item.output == null ? 0.75f : this.getPipeLength());
    }

    protected void neighborChange() {
    }

    public NonNullList<ItemStack> dropContents() {
        NonNullList list = NonNullList.func_191196_a();
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            for (LPTravelingItem item : this.items) {
                list.add((Object)item.getItemIdentifierStack().makeNormalStack());
            }
        }
        return list;
    }

    public boolean delveIntoUnloadedChunks() {
        return true;
    }

    private void sendItemPacket(LPTravelingItem.LPTravelingItemServer item) {
        if (MainProxy.isAnyoneWatching(this.container.func_174877_v(), this.getWorld().field_73011_w.getDimension())) {
            if (!LPTravelingItem.clientSideKnownIDs.get(item.getId())) {
                MainProxy.sendPacketToAllWatchingChunk(this.container, (ModernPacket)PacketHandler.getPacket(PipeContentPacket.class).setItem(item.getItemIdentifierStack()).setTravelId(item.getId()));
                LPTravelingItem.clientSideKnownIDs.set(item.getId());
            }
            MainProxy.sendPacketToAllWatchingChunk(this.container, (ModernPacket)PacketHandler.getPacket(PipePositionPacket.class).setSpeed(item.getSpeed()).setPosition(item.getPosition()).setInput(item.input).setOutput(item.output).setTravelId(item.getId()).setYaw(item.getYaw()).setTilePos(this.container));
        }
    }

    public void handleItemPositionPacket(int travelId, EnumFacing input, EnumFacing output, float speed, float position, float yaw) {
        WeakReference<LPTravelingItem.LPTravelingItemClient> ref = LPTravelingItem.clientList.get(travelId);
        LPTravelingItem.LPTravelingItemClient item = null;
        if (ref != null) {
            item = (LPTravelingItem.LPTravelingItemClient)ref.get();
        }
        if (item == null) {
            this.sendItemContentRequest(travelId);
            item = new LPTravelingItem.LPTravelingItemClient(travelId, position, input, output, yaw);
            item.setSpeed(speed);
            LPTravelingItem.clientList.put(travelId, new WeakReference<LPTravelingItem.LPTravelingItemClient>(item));
        } else {
            if (item.getContainer() instanceof LogisticsTileGenericPipe) {
                ((LogisticsTileGenericPipe)item.getContainer()).pipe.transport.items.scheduleRemoval(item);
                ((LogisticsTileGenericPipe)item.getContainer()).pipe.transport.items.removeScheduledItems();
            }
            item.updateInformation(input, output, speed, position, yaw);
        }
        item.lastTicked = MainProxy.getGlobalTick();
        if (this.items.get(travelId) == null) {
            this.items.add(item);
        }
    }

    private void sendItemContentRequest(int travelId) {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(PipeContentRequest.class).setInteger(travelId));
    }

    public void sendItem(@Nonnull ItemStack stackToSend) {
        this.injectItem((LPTravelingItem)SimpleServiceLocator.routedItemHelper.createNewTravelItem(stackToSend), EnumFacing.UP);
    }

    public World getWorld() {
        return this.container.func_145831_w();
    }

    public void onNeighborBlockChange() {
    }

    public void onBlockPlaced() {
    }

    public void setTile(LogisticsTileGenericPipe tile) {
        this.container = tile;
    }

    public CoreUnroutedPipe getNextPipe(EnumFacing output) {
        TileEntity tile = this.container.getTile(output);
        if (tile instanceof LogisticsTileGenericPipe) {
            return ((LogisticsTileGenericPipe)tile).pipe;
        }
        return null;
    }

    static class RoutingResult {
        private EnumFacing face;
        private boolean hasRoute;

        public EnumFacing getFace() {
            return this.face;
        }

        public boolean isHasRoute() {
            return this.hasRoute;
        }

        public RoutingResult setFace(EnumFacing face) {
            this.face = face;
            return this;
        }

        public RoutingResult setHasRoute(boolean hasRoute) {
            this.hasRoute = hasRoute;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RoutingResult)) {
                return false;
            }
            RoutingResult other = (RoutingResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            EnumFacing this$face = this.getFace();
            EnumFacing other$face = other.getFace();
            if (this$face == null ? other$face != null : !this$face.equals(other$face)) {
                return false;
            }
            return this.isHasRoute() == other.isHasRoute();
        }

        protected boolean canEqual(Object other) {
            return other instanceof RoutingResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            EnumFacing $face = this.getFace();
            result2 = result2 * 59 + ($face == null ? 43 : $face.hashCode());
            result2 = result2 * 59 + (this.isHasRoute() ? 79 : 97);
            return result2;
        }

        public String toString() {
            return "PipeTransportLogistics.RoutingResult(face=" + this.getFace() + ", hasRoute=" + this.isHasRoute() + ")";
        }

        public RoutingResult(EnumFacing face, boolean hasRoute) {
            this.face = face;
            this.hasRoute = hasRoute;
        }
    }
}

