/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.ticks;

import com.google.common.collect.MapMaker;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import logisticspipes.commands.commands.debug.DebugGuiController;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.pathfinder.changedetection.LPWorldAccess;
import logisticspipes.ticks.HudUpdateTick;
import logisticspipes.utils.FluidIdentifier;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import network.rs485.grow.ServerTickDispatcher;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class LPTickHandler {
    public static int adjChecksDone = 0;
    private static Map<World, LPWorldInfo> worldInfo = new MapMaker().weakKeys().makeMap();

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            FluidIdentifier.initFromForge(true);
            SimpleServiceLocator.clientBufferHandler.clientTick();
            MainProxy.proxy.tickClient();
            DebugGuiController.instance().execClient();
        }
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            HudUpdateTick.tick();
            SimpleServiceLocator.serverBufferHandler.serverTick();
            MainProxy.proxy.tickServer();
            adjChecksDone = 0;
            DebugGuiController.instance().execServer();
            ServerTickDispatcher.INSTANCE.tick();
        }
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side != Side.SERVER) {
            return;
        }
        LPWorldInfo info = LPTickHandler.getWorldInfo(event.world);
        info.worldTick++;
    }

    public static LPWorldInfo getWorldInfo(World world) {
        LPWorldInfo info = worldInfo.get(world);
        if (info == null) {
            info = new LPWorldInfo();
            worldInfo.put(world, info);
            world.func_72954_a((IWorldEventListener)new LPWorldAccess(world, info));
        }
        return info;
    }

    public static class LPWorldInfo {
        private long worldTick = 0L;
        private Set<DoubleCoordinates> updateQueued = new HashSet<DoubleCoordinates>();
        private boolean skipBlockUpdateForWorld = false;

        public LPWorldInfo setUpdateQueued(Set<DoubleCoordinates> updateQueued) {
            this.updateQueued = updateQueued;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LPWorldInfo)) {
                return false;
            }
            LPWorldInfo other = (LPWorldInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWorldTick() != other.getWorldTick()) {
                return false;
            }
            Set<DoubleCoordinates> this$updateQueued = this.getUpdateQueued();
            Set<DoubleCoordinates> other$updateQueued = other.getUpdateQueued();
            if (this$updateQueued == null ? other$updateQueued != null : !((Object)this$updateQueued).equals(other$updateQueued)) {
                return false;
            }
            return this.isSkipBlockUpdateForWorld() == other.isSkipBlockUpdateForWorld();
        }

        protected boolean canEqual(Object other) {
            return other instanceof LPWorldInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result2 = 1;
            long $worldTick = this.getWorldTick();
            result2 = result2 * 59 + (int)($worldTick >>> 32 ^ $worldTick);
            Set<DoubleCoordinates> $updateQueued = this.getUpdateQueued();
            result2 = result2 * 59 + ($updateQueued == null ? 43 : ((Object)$updateQueued).hashCode());
            result2 = result2 * 59 + (this.isSkipBlockUpdateForWorld() ? 79 : 97);
            return result2;
        }

        public String toString() {
            return "LPTickHandler.LPWorldInfo(worldTick=" + this.getWorldTick() + ", updateQueued=" + this.getUpdateQueued() + ", skipBlockUpdateForWorld=" + this.isSkipBlockUpdateForWorld() + ")";
        }

        public long getWorldTick() {
            return this.worldTick;
        }

        private LPWorldInfo setWorldTick(long worldTick) {
            this.worldTick = worldTick;
            return this;
        }

        public Set<DoubleCoordinates> getUpdateQueued() {
            return this.updateQueued;
        }

        public boolean isSkipBlockUpdateForWorld() {
            return this.skipBlockUpdateForWorld;
        }

        public LPWorldInfo setSkipBlockUpdateForWorld(boolean skipBlockUpdateForWorld) {
            this.skipBlockUpdateForWorld = skipBlockUpdateForWorld;
            return this;
        }
    }
}

