/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import java.util.List;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.cofh.subproxies.ICoFHEnergyReceiver;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.connection.LPNeighborTileEntity;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.world.WorldCoordinatesWrapper;

public class PowerSupplierHandler {
    private static final double INTERNAL_RF_BUFFER_MAX = 10000.0;
    private static final double INTERNAL_IC2_BUFFER_MAX = 8192.0;
    private final CoreRoutedPipe pipe;
    private double internalBufferRF = 0.0;
    private double internalBufferIC2 = 0.0;

    public PowerSupplierHandler(CoreRoutedPipe pipe) {
        this.pipe = pipe;
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.internalBufferRF > 0.0) {
            nbttagcompound.func_74780_a("bufferRF", this.internalBufferRF);
        }
        if (this.internalBufferIC2 > 0.0) {
            nbttagcompound.func_74780_a("bufferEU", this.internalBufferIC2);
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.internalBufferRF = nbttagcompound.func_74781_a("bufferRF") instanceof NBTTagFloat ? (double)nbttagcompound.func_74760_g("bufferRF") : nbttagcompound.func_74769_h("bufferRF");
        this.internalBufferRF = nbttagcompound.func_74781_a("bufferEU") instanceof NBTTagFloat ? (double)nbttagcompound.func_74760_g("bufferEU") : nbttagcompound.func_74769_h("bufferEU");
    }

    public void update() {
        if (SimpleServiceLocator.powerProxy.isAvailable() && this.pipe.getUpgradeManager().hasRFPowerSupplierUpgrade() && this.requestRFPower()) {
            return;
        }
        if (SimpleServiceLocator.IC2Proxy.hasIC2() && this.pipe.getUpgradeManager().getIC2PowerLevel() > 0) {
            this.requestICPower();
        }
    }

    private void requestICPower() {
        double d;
        List<LPNeighborTileEntity<TileEntity>> adjacentTileEntities = new WorldCoordinatesWrapper(this.pipe.container).allNeighborTileEntities();
        double globalNeed = 0.0;
        double[] need = new double[adjacentTileEntities.size()];
        int i = 0;
        for (NeighborTileEntity neighborTileEntity : adjacentTileEntities) {
            if (SimpleServiceLocator.IC2Proxy.isEnergySink((TileEntity)neighborTileEntity.getTileEntity()) && this.pipe.canPipeConnect((TileEntity)neighborTileEntity.getTileEntity(), neighborTileEntity.getDirection()) && SimpleServiceLocator.IC2Proxy.acceptsEnergyFrom((TileEntity)neighborTileEntity.getTileEntity(), this.pipe.container, neighborTileEntity.getOurDirection())) {
                need[i] = SimpleServiceLocator.IC2Proxy.demandedEnergyUnits((TileEntity)neighborTileEntity.getTileEntity());
                globalNeed += need[i];
            }
            ++i;
        }
        if (globalNeed != 0.0 && !Double.isNaN(globalNeed)) {
            double fullfillable = Math.min(1.0, this.internalBufferIC2 / globalNeed);
            i = 0;
            for (NeighborTileEntity neighborTileEntity : adjacentTileEntities) {
                if (SimpleServiceLocator.IC2Proxy.isEnergySink((TileEntity)neighborTileEntity.getTileEntity()) && this.pipe.canPipeConnect((TileEntity)neighborTileEntity.getTileEntity(), neighborTileEntity.getDirection()) && SimpleServiceLocator.IC2Proxy.acceptsEnergyFrom((TileEntity)neighborTileEntity.getTileEntity(), this.pipe.container, neighborTileEntity.getOurDirection())) {
                    double d2;
                    if (this.internalBufferIC2 + 1.0 < need[i] * fullfillable) {
                        return;
                    }
                    double toUse = Math.min((double)this.pipe.getUpgradeManager().getIC2PowerLevel(), need[i] * fullfillable);
                    double used = toUse - (d2 = SimpleServiceLocator.IC2Proxy.injectEnergyUnits((TileEntity)neighborTileEntity.getTileEntity(), neighborTileEntity.getOurDirection(), toUse));
                    if (used > 0.0) {
                        this.pipe.container.addLaser(neighborTileEntity.getDirection(), 0.5f, 0xFFFF00, false, true);
                        this.internalBufferIC2 -= used;
                    }
                    if (this.internalBufferIC2 < 0.0) {
                        this.internalBufferIC2 = 0.0;
                        return;
                    }
                }
                ++i;
            }
        }
        List<Pair<ISubSystemPowerProvider, List<IFilter>>> provider = this.pipe.getRouter().getSubSystemPowerProvider();
        double d3 = 0.0;
        block2: for (Pair<ISubSystemPowerProvider, List<IFilter>> pair : provider) {
            for (IFilter iFilter : pair.getValue2()) {
                if (!iFilter.blockPower()) continue;
                continue block2;
            }
            if (pair.getValue1().usePaused() || !pair.getValue1().getBrand().equals("EU")) continue;
            d3 += pair.getValue1().getPowerLevel();
        }
        if (d3 > 0.0 && (d = 8192.0 - this.internalBufferIC2) > 0.0 && this.pipe.useEnergy((int)(d / 10000.0), false)) {
            block4: for (Pair pair : provider) {
                for (IFilter filter3 : (List)pair.getValue2()) {
                    if (!filter3.blockPower()) continue;
                    continue block4;
                }
                if (((ISubSystemPowerProvider)pair.getValue1()).usePaused() || !((ISubSystemPowerProvider)pair.getValue1()).getBrand().equals("EU")) continue;
                double requestamount = d * (((ISubSystemPowerProvider)pair.getValue1()).getPowerLevel() / d3);
                ((ISubSystemPowerProvider)pair.getValue1()).requestPower(this.pipe.getRouterId(), requestamount);
            }
        }
    }

    private boolean requestRFPower() {
        double d;
        List<LPNeighborTileEntity<TileEntity>> adjacentTileEntities = new WorldCoordinatesWrapper(this.pipe.container).allNeighborTileEntities();
        double globalNeed = 0.0;
        double[] need = new double[adjacentTileEntities.size()];
        int i = 0;
        for (NeighborTileEntity neighborTileEntity : adjacentTileEntities) {
            if (SimpleServiceLocator.powerProxy.isEnergyReceiver((TileEntity)neighborTileEntity.getTileEntity(), neighborTileEntity.getOurDirection()) && this.pipe.canPipeConnect((TileEntity)neighborTileEntity.getTileEntity(), neighborTileEntity.getDirection())) {
                ICoFHEnergyReceiver energyReceiver = SimpleServiceLocator.powerProxy.getEnergyReceiver((TileEntity)neighborTileEntity.getTileEntity(), neighborTileEntity.getOurDirection());
                need[i] = energyReceiver.getMaxEnergyStored() - energyReceiver.getEnergyStored();
                globalNeed += need[i];
            }
            ++i;
        }
        if (globalNeed != 0.0 && !Double.isNaN(globalNeed)) {
            double fullfillable = Math.min(1.0, this.internalBufferRF / globalNeed);
            i = 0;
            for (NeighborTileEntity neighborTileEntity : adjacentTileEntities) {
                if (SimpleServiceLocator.powerProxy.isEnergyReceiver((TileEntity)neighborTileEntity.getTileEntity(), neighborTileEntity.getOurDirection()) && this.pipe.canPipeConnect((TileEntity)neighborTileEntity.getTileEntity(), neighborTileEntity.getDirection())) {
                    EnumFacing oppositeDir = neighborTileEntity.getOurDirection();
                    ICoFHEnergyReceiver energyReceiver = SimpleServiceLocator.powerProxy.getEnergyReceiver((TileEntity)neighborTileEntity.getTileEntity(), oppositeDir);
                    if (this.internalBufferRF + 1.0 < need[i] * fullfillable) {
                        return true;
                    }
                    int n = energyReceiver.receiveEnergy(oppositeDir, (int)(need[i] * fullfillable), false);
                    if (n > 0) {
                        this.pipe.container.addLaser(neighborTileEntity.getDirection(), 0.5f, 0xFF0000, false, true);
                        this.internalBufferRF -= (double)n;
                    }
                    if (this.internalBufferRF < 0.0) {
                        this.internalBufferRF = 0.0;
                        return true;
                    }
                }
                ++i;
            }
        }
        List<Pair<ISubSystemPowerProvider, List<IFilter>>> provider = this.pipe.getRouter().getSubSystemPowerProvider();
        double d2 = 0.0;
        block2: for (Pair<ISubSystemPowerProvider, List<IFilter>> pair : provider) {
            for (IFilter iFilter : pair.getValue2()) {
                if (!iFilter.blockPower()) continue;
                continue block2;
            }
            if (pair.getValue1().usePaused() || !pair.getValue1().getBrand().equals("RF")) continue;
            d2 += pair.getValue1().getPowerLevel();
        }
        if (d2 > 0.0 && (d = 10000.0 - this.internalBufferRF) > 0.0 && this.pipe.useEnergy((int)(d / 100.0), false)) {
            block4: for (Pair pair : provider) {
                for (IFilter filter3 : (List)pair.getValue2()) {
                    if (!filter3.blockPower()) continue;
                    continue block4;
                }
                if (((ISubSystemPowerProvider)pair.getValue1()).usePaused() || !((ISubSystemPowerProvider)pair.getValue1()).getBrand().equals("RF")) continue;
                double requestamount = d * (((ISubSystemPowerProvider)pair.getValue1()).getPowerLevel() / d2);
                ((ISubSystemPowerProvider)pair.getValue1()).requestPower(this.pipe.getRouterId(), requestamount);
            }
        }
        return false;
    }

    public void addRFPower(double toSend) {
        this.internalBufferRF += toSend;
    }

    public void addIC2Power(double toSend) {
        this.internalBufferIC2 += toSend;
    }
}

