/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.gui.GuiChassisPipe;
import logisticspipes.gui.hud.HudChassisPipe;
import logisticspipes.interfaces.IBufferItems;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILegacyActiveModule;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.ISendQueueContentRecieiver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.items.ItemModule;
import logisticspipes.logisticspipes.ChassisTransportLayer;
import logisticspipes.logisticspipes.ItemModuleInformationManager;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.modules.ChassisModule;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.hud.HUDStartWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopWatchingPacket;
import logisticspipes.network.packets.pipe.ChassisOrientationPacket;
import logisticspipes.network.packets.pipe.ChassisPipeModuleContent;
import logisticspipes.network.packets.pipe.RequestChassisOrientationPacket;
import logisticspipes.network.packets.pipe.SendQueueContent;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.ModuleUpgradeManager;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.request.ICraftingTemplate;
import logisticspipes.request.IPromise;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.ticks.HudUpdateTick;
import logisticspipes.utils.EnumFacingUtil;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.client.FMLClientHandler;
import network.rs485.logisticspipes.connection.Adjacent;
import network.rs485.logisticspipes.connection.ConnectionType;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.connection.NoAdjacent;
import network.rs485.logisticspipes.connection.SingleAdjacent;
import network.rs485.logisticspipes.module.PipeServiceProviderUtilKt;
import network.rs485.logisticspipes.pipes.IChassisPipe;

@CCType(name="LogisticsChassiePipe")
public abstract class PipeLogisticsChassis
extends CoreRoutedPipe
implements ICraftItems,
IBufferItems,
ISimpleInventoryEventHandler,
ISendRoutedItem,
IProvideItems,
IHeadUpDisplayRendererProvider,
ISendQueueContentRecieiver,
IChassisPipe {
    private final ChassisModule _module;
    private final ItemIdentifierInventory _moduleInventory;
    private final NonNullList<ModuleUpgradeManager> slotUpgradeManagers = NonNullList.func_191196_a();
    private boolean init = false;
    public final LinkedList<ItemIdentifierStack> displayList = new LinkedList();
    public final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private final HudChassisPipe hud;
    @Nullable
    private SingleAdjacent pointedAdjacent = null;
    public final LinkedList<LogisticsOrder> _extras = new LinkedList();

    public PipeLogisticsChassis(Item item) {
        super(item);
        this._moduleInventory = new ItemIdentifierInventory(this.getChassisSize(), "Chassi pipe", 1);
        this._moduleInventory.addListener(this);
        assert (this.slotUpgradeManagers.size() == 0);
        for (int i = 0; i < this.getChassisSize(); ++i) {
            this.addModuleUpgradeManager();
        }
        this._module = new ChassisModule(this.getChassisSize(), this);
        this._module.registerHandler(this, this);
        this.hud = new HudChassisPipe(this, this._moduleInventory);
    }

    @Override
    @Nullable
    public EnumFacing getPointedOrientation() {
        if (this.pointedAdjacent == null) {
            return null;
        }
        return this.pointedAdjacent.getDir();
    }

    @Nonnull
    protected Adjacent getPointedAdjacentOrNoAdjacent() {
        if (this.pointedAdjacent == null) {
            return NoAdjacent.INSTANCE;
        }
        return this.pointedAdjacent;
    }

    @Override
    @Nonnull
    public Adjacent getAvailableAdjacent() {
        return this.getPointedAdjacentOrNoAdjacent();
    }

    @Override
    protected void updateAdjacentCache() {
        super.updateAdjacentCache();
        Adjacent adjacent = this.getAdjacent();
        if (adjacent instanceof SingleAdjacent) {
            this.pointedAdjacent = (SingleAdjacent)adjacent;
        } else {
            SingleAdjacent oldPointedAdjacent = this.pointedAdjacent;
            SingleAdjacent newPointedAdjacent = null;
            if (oldPointedAdjacent != null) {
                newPointedAdjacent = adjacent.optionalGet(oldPointedAdjacent.getDir()).map(connectionType -> new SingleAdjacent(this, oldPointedAdjacent.getDir(), (ConnectionType)((Object)connectionType))).orElse(null);
            }
            if (newPointedAdjacent == null) {
                newPointedAdjacent = adjacent.neighbors().entrySet().stream().findAny().map(connectedNeighbor -> new SingleAdjacent(this, ((NeighborTileEntity)connectedNeighbor.getKey()).getDirection(), (ConnectionType)((Object)((Object)connectedNeighbor.getValue())))).orElse(null);
            }
            this.pointedAdjacent = newPointedAdjacent;
        }
    }

    @Nullable
    private Pair<NeighborTileEntity<TileEntity>, ConnectionType> nextPointedOrientation(@Nullable EnumFacing previousDirection) {
        Map<NeighborTileEntity<TileEntity>, ConnectionType> neighbors = this.getAdjacent().neighbors();
        Stream<NeighborTileEntity> sortedNeighborsStream = neighbors.keySet().stream().sorted(Comparator.comparingInt(n -> n.getDirection().ordinal()));
        if (previousDirection == null) {
            return sortedNeighborsStream.findFirst().map(neighbor -> new Pair((NeighborTileEntity)neighbor, neighbors.get(neighbor))).orElse(null);
        }
        List sortedNeighbors = sortedNeighborsStream.collect(Collectors.toList());
        if (sortedNeighbors.size() == 0) {
            return null;
        }
        Optional<NeighborTileEntity> nextNeighbor = sortedNeighbors.stream().filter(neighbor -> neighbor.getDirection().ordinal() > previousDirection.ordinal()).findFirst();
        return nextNeighbor.map(neighbor -> new Pair((NeighborTileEntity)neighbor, neighbors.get(neighbor))).orElse(new Pair(sortedNeighbors.get(0), neighbors.get(sortedNeighbors.get(0))));
    }

    @Override
    public void nextOrientation() {
        SingleAdjacent pointedAdjacent = this.pointedAdjacent;
        Pair<NeighborTileEntity<TileEntity>, ConnectionType> newNeighbor = pointedAdjacent == null ? this.nextPointedOrientation(null) : this.nextPointedOrientation(pointedAdjacent.getDir());
        ChassisOrientationPacket packet = PacketHandler.getPacket(ChassisOrientationPacket.class);
        if (newNeighbor == null) {
            this.pointedAdjacent = null;
            packet.setDir(null);
        } else {
            this.pointedAdjacent = new SingleAdjacent(this, newNeighbor.getValue1().getDirection(), newNeighbor.getValue2());
            packet.setDir(newNeighbor.getValue1().getDirection());
        }
        MainProxy.sendPacketToAllWatchingChunk(this._module, (ModernPacket)packet.setTilePos(this.container));
        this.refreshRender(true);
    }

    @Override
    public void setPointedOrientation(@Nullable EnumFacing dir) {
        this.pointedAdjacent = dir == null ? null : new SingleAdjacent(this, dir, ConnectionType.UNDEFINED);
    }

    @Override
    @Nonnull
    public IInventory getModuleInventory() {
        return this._moduleInventory;
    }

    @Nonnull
    public ModuleUpgradeManager getModuleUpgradeManager(int slot) {
        return (ModuleUpgradeManager)this.slotUpgradeManagers.get(slot);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_TEXTURE;
    }

    @Override
    public Textures.TextureType getRoutedTexture(EnumFacing connection) {
        if (this.getRouter().isSubPoweredExit(connection)) {
            return Textures.LOGISTICSPIPE_SUBPOWER_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_CHASSI_ROUTED_TEXTURE;
    }

    @Override
    public Textures.TextureType getNonRoutedTexture(EnumFacing connection) {
        if (this.pointedAdjacent != null && connection.equals((Object)this.pointedAdjacent.getDir())) {
            return Textures.LOGISTICSPIPE_CHASSI_DIRECTION_TEXTURE;
        }
        if (this.isPowerProvider(connection)) {
            return Textures.LOGISTICSPIPE_POWERED_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_CHASSI_NOTROUTED_TEXTURE;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        try {
            super.readFromNBT(nbttagcompound);
            this._moduleInventory.readFromNBT(nbttagcompound, "chassi");
            this.InventoryChanged(this._moduleInventory);
            this._module.readFromNBT(nbttagcompound);
            int tmp = nbttagcompound.func_74762_e("Orientation");
            if (tmp != -1) {
                this.setPointedOrientation(EnumFacingUtil.getOrientation(tmp % 6));
            }
            for (int i = 0; i < this.getChassisSize(); ++i) {
                if (i >= this.slotUpgradeManagers.size()) {
                    this.addModuleUpgradeManager();
                }
                ((ModuleUpgradeManager)this.slotUpgradeManagers.get(i)).readFromNBT(nbttagcompound, Integer.toString(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addModuleUpgradeManager() {
        this.slotUpgradeManagers.add((Object)new ModuleUpgradeManager(this, this.upgradeManager));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this._moduleInventory.writeToNBT(nbttagcompound, "chassi");
        this._module.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("Orientation", this.pointedAdjacent == null ? -1 : this.pointedAdjacent.getDir().ordinal());
        for (int i = 0; i < this.getChassisSize(); ++i) {
            ((ModuleUpgradeManager)this.slotUpgradeManagers.get(i)).writeToNBT(nbttagcompound, Integer.toString(i));
        }
    }

    @Override
    public void onAllowedRemoval() {
        this._moduleInventory.removeListener(this);
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            int i;
            for (i = 0; i < this.getChassisSize(); ++i) {
                LogisticsModule x = this.getSubModule(i);
                if (!(x instanceof ILegacyActiveModule)) continue;
                ILegacyActiveModule y = (ILegacyActiveModule)((Object)x);
                y.onBlockRemoval();
            }
            for (i = 0; i < this._moduleInventory.func_70302_i_(); ++i) {
                ItemIdentifierStack ms = this._moduleInventory.getIDStackInSlot(i);
                if (ms == null) continue;
                ItemStack stack = ms.makeNormalStack();
                ItemModuleInformationManager.saveInformation(stack, this.getSubModule(i));
                this._moduleInventory.func_70299_a(i, stack);
            }
            this._moduleInventory.dropContents(this.getWorld(), this.getX(), this.getY(), this.getZ());
            for (i = 0; i < this.getChassisSize(); ++i) {
                this.getModuleUpgradeManager(i).dropUpgrades();
            }
        }
    }

    @Override
    public void itemArrived(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            if (info instanceof ChassiTargetInformation) {
                ChassiTargetInformation target = (ChassiTargetInformation)info;
                LogisticsModule module = this.getSubModule(target.moduleSlot);
                if (module instanceof IRequireReliableTransport) {
                    ((IRequireReliableTransport)((Object)module)).itemArrived(item, info);
                }
            } else if (LogisticsPipes.isDEBUG() && info != null) {
                System.out.println(item);
                new RuntimeException("[ItemArrived] Information weren't ment for a chassi pipe").printStackTrace();
            }
        }
    }

    @Override
    public void itemLost(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            if (info instanceof ChassiTargetInformation) {
                ChassiTargetInformation target = (ChassiTargetInformation)info;
                LogisticsModule module = this.getSubModule(target.moduleSlot);
                if (module instanceof IRequireReliableTransport) {
                    ((IRequireReliableTransport)((Object)module)).itemLost(item, info);
                }
            } else if (LogisticsPipes.isDEBUG()) {
                System.out.println(item);
                new RuntimeException("[ItemLost] Information weren't ment for a chassi pipe").printStackTrace();
            }
        }
    }

    @Override
    public int addToBuffer(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            if (info instanceof ChassiTargetInformation) {
                ChassiTargetInformation target = (ChassiTargetInformation)info;
                LogisticsModule module = this.getSubModule(target.moduleSlot);
                if (module instanceof IBufferItems) {
                    return ((IBufferItems)((Object)module)).addToBuffer(item, info);
                }
            } else if (LogisticsPipes.isDEBUG()) {
                System.out.println(item);
                new RuntimeException("[AddToBuffer] Information weren't ment for a chassi pipe").printStackTrace();
            }
        }
        return item.getStackSize();
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        boolean reInitGui = false;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) {
                if (!this._module.hasModule(i)) continue;
                this._module.removeModule(i);
                reInitGui = true;
                continue;
            }
            if (!(stack.func_77973_b() instanceof ItemModule)) continue;
            LogisticsModule current = this._module.getModule(i);
            LogisticsModule next = ((ItemModule)stack.func_77973_b()).getModuleForItem(stack, this._module.getModule(i), this, this);
            Objects.requireNonNull(next, "getModuleForItem returned null for " + stack.toString());
            next.registerPosition(LogisticsModule.ModulePositionType.SLOT, i);
            next.registerCCEventQueuer(this);
            if (current != next) {
                this._module.installModule(i, next);
                if (!MainProxy.isClient((IBlockAccess)this.getWorld())) {
                    ItemModuleInformationManager.readInformation(stack, next);
                }
            }
            inventory.func_70299_a(i, stack);
        }
        if (reInitGui && MainProxy.isClient((IBlockAccess)this.getWorld()) && FMLClientHandler.instance().getClient().field_71462_r instanceof GuiChassisPipe) {
            FMLClientHandler.instance().getClient().field_71462_r.func_73866_w_();
        }
        if (MainProxy.isServer((IBlockAccess)this.getWorld()) && !this.localModeWatchers.isEmpty()) {
            MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(ChassisPipeModuleContent.class).setIdentList(ItemIdentifierStack.getListFromInventory(this._moduleInventory)).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
        }
    }

    @Override
    public void ignoreDisableUpdateEntity() {
        if (!this.init) {
            this.init = true;
            if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestChassisOrientationPacket.class).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
            }
        }
    }

    @Override
    public final LogisticsModule getLogisticsModule() {
        return this._module;
    }

    @Override
    @Nonnull
    public TransportLayer getTransportLayer() {
        if (this._transportLayer == null) {
            this._transportLayer = new ChassisTransportLayer(this);
        }
        return this._transportLayer;
    }

    private boolean tryInsertingModule(EntityPlayer entityplayer) {
        for (int i = 0; i < this._moduleInventory.func_70302_i_(); ++i) {
            if (this._moduleInventory.getIDStackInSlot(i) != null) continue;
            this._moduleInventory.func_70299_a(i, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77979_a(1));
            this.InventoryChanged(this._moduleInventory);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleClick(EntityPlayer entityplayer, SecuritySettings settings) {
        if (entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
            return false;
        }
        if (entityplayer.func_70093_af() && SimpleServiceLocator.configToolHandler.canWrench(entityplayer, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND), this.container)) {
            if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
                if (settings == null || settings.openGui) {
                    ((PipeLogisticsChassis)this.container.pipe).nextOrientation();
                } else {
                    entityplayer.func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.permissiondenied", new Object[0]));
                }
            }
            SimpleServiceLocator.configToolHandler.wrenchUsed(entityplayer, entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND), this.container);
            return true;
        }
        if (!entityplayer.func_70093_af() && entityplayer.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77973_b() instanceof ItemModule) {
            if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
                if (settings == null || settings.openGui) {
                    return this.tryInsertingModule(entityplayer);
                }
                entityplayer.func_145747_a((ITextComponent)new TextComponentTranslation("lp.chat.permissiondenied", new Object[0]));
            }
            return true;
        }
        return false;
    }

    @Override
    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filters) {
        if (!this.isEnabled()) {
            return;
        }
        for (IFilter filter2 : filters) {
            if (filter2.isBlocked() != filter2.isFilteredItem(tree.getRequestType()) && !filter2.blockProvider()) continue;
            return;
        }
        for (int i = 0; i < this.getChassisSize(); ++i) {
            LogisticsModule x = this.getSubModule(i);
            if (!(x instanceof ILegacyActiveModule)) continue;
            ILegacyActiveModule y = (ILegacyActiveModule)((Object)x);
            y.canProvide(tree, root, filters);
        }
    }

    @Override
    public LogisticsOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        if (!this.isEnabled()) {
            return null;
        }
        for (int i = 0; i < this.getChassisSize(); ++i) {
            ILegacyActiveModule y;
            LogisticsOrder result2;
            LogisticsModule x = this.getSubModule(i);
            if (!(x instanceof ILegacyActiveModule) || (result2 = (y = (ILegacyActiveModule)((Object)x)).fullFill(promise, destination, info)) == null) continue;
            this.spawnParticle(Particles.WhiteParticle, 2);
            return result2;
        }
        return null;
    }

    @Override
    public void getAllItems(Map<ItemIdentifier, Integer> list, List<IFilter> filter2) {
        if (!this.isEnabled()) {
            return;
        }
        for (int i = 0; i < this.getChassisSize(); ++i) {
            LogisticsModule x = this.getSubModule(i);
            if (!(x instanceof ILegacyActiveModule)) continue;
            ILegacyActiveModule y = (ILegacyActiveModule)((Object)x);
            y.getAllItems(list, filter2);
        }
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.hud;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopWatchingPacket.class).setInteger(1).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()));
        this.hud.stopWatching();
    }

    @Override
    public void playerStartWatching(EntityPlayer player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ChassisPipeModuleContent.class).setIdentList(ItemIdentifierStack.getListFromInventory(this._moduleInventory)).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), player);
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SendQueueContent.class).setIdentList(ItemIdentifierStack.getListSendQueue(this._sendQueue)).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(EntityPlayer player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    public void handleModuleItemIdentifierList(Collection<ItemIdentifierStack> _allItems) {
        this._moduleInventory.handleItemIdentifierList(_allItems);
    }

    @Override
    public int sendQueueChanged(boolean force) {
        if (MainProxy.isServer((IBlockAccess)this.getWorld())) {
            if (Configs.MULTI_THREAD_NUMBER > 0 && !force) {
                HudUpdateTick.add(this.getRouter());
            } else if (this.localModeWatchers.size() > 0) {
                LinkedList<ItemIdentifierStack> items = ItemIdentifierStack.getListSendQueue(this._sendQueue);
                MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(SendQueueContent.class).setIdentList(items).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), this.localModeWatchers);
                return items.size();
            }
        }
        return 0;
    }

    @Override
    public void handleSendQueueItemIdentifierList(Collection<ItemIdentifierStack> _allItems) {
        this.displayList.clear();
        this.displayList.addAll(_allItems);
    }

    public ChassisModule getModules() {
        return this._module;
    }

    @Override
    public void setTile(TileEntity tile) {
        super.setTile(tile);
        for (int i = 0; i < this._moduleInventory.func_70302_i_(); ++i) {
            LogisticsModule current = this._module.getModule(i);
            if (current == null) continue;
            current.registerPosition(LogisticsModule.ModulePositionType.SLOT, i);
        }
    }

    @Override
    public int getSourceID() {
        return this.getRouterId();
    }

    @Override
    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemidCollection) {
        LogisticsModule module;
        if (this.getPointedAdjacentOrNoAdjacent().inventories().isEmpty()) {
            return;
        }
        for (int moduleIndex = 0; moduleIndex < this.getChassisSize(); ++moduleIndex) {
            ISlotUpgradeManager upgradeManager;
            IInventoryUtil inv;
            module = this.getSubModule(moduleIndex);
            if (module == null || !module.interestedInAttachedInventory() || (inv = (IInventoryUtil)PipeServiceProviderUtilKt.availableSneakyInventories((IPipeServiceProvider)this, upgradeManager = this.getUpgradeManager(module.getSlot(), module.getPositionInt())).stream().findFirst().orElse(null)) == null) continue;
            Set<ItemIdentifier> items = inv.getItems();
            itemidCollection.addAll(items);
            items.stream().map(ItemIdentifier::getIgnoringNBT).forEach(itemidCollection::add);
            boolean modulesInterestedInUndamged = false;
            for (int i = 0; i < this.getChassisSize(); ++i) {
                if (!this.getSubModule(moduleIndex).interestedInUndamagedID()) continue;
                modulesInterestedInUndamged = true;
                break;
            }
            if (!modulesInterestedInUndamged) break;
            items.stream().map(ItemIdentifier::getUndamaged).forEach(itemidCollection::add);
            break;
        }
        for (int i = 0; i < this.getChassisSize(); ++i) {
            module = this.getSubModule(i);
            if (module == null) continue;
            module.collectSpecificInterests(itemidCollection);
        }
    }

    @Override
    public boolean hasGenericInterests() {
        if (this.getPointedAdjacentOrNoAdjacent().inventories().isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.getChassisSize(); ++i) {
            LogisticsModule x = this.getSubModule(i);
            if (x == null || !x.hasGenericInterests()) continue;
            return true;
        }
        return false;
    }

    @CCCommand(description="Returns the LogisticsModule for the given slot number starting by 1")
    public LogisticsModule getModuleInSlot(Double i) {
        return this.getSubModule((int)(i - 1.0));
    }

    @CCCommand(description="Returns the size of this Chassie pipe")
    public Integer getChassieSize() {
        return this.getChassisSize();
    }

    @Override
    public void registerExtras(IPromise promise) {
        if (!(promise instanceof LogisticsPromise)) {
            throw new UnsupportedOperationException("Extra has to be an item for a chassis pipe");
        }
        ItemIdentifierStack stack = new ItemIdentifierStack(((LogisticsPromise)promise).item, ((LogisticsPromise)promise).numberOfItems);
        this._extras.add(new LogisticsItemOrder(new DictResource(stack, null), null, IOrderInfoProvider.ResourceType.EXTRA, null));
    }

    @Override
    public ICraftingTemplate addCrafting(IResource toCraft) {
        for (int i = 0; i < this.getChassisSize(); ++i) {
            LogisticsModule x = this.getSubModule(i);
            if (!(x instanceof ICraftItems) || !((ICraftItems)((Object)x)).canCraft(toCraft)) continue;
            return ((ICraftItems)((Object)x)).addCrafting(toCraft);
        }
        return null;
    }

    @Override
    public List<ItemIdentifierStack> getCraftedItems() {
        LinkedList<ItemIdentifierStack> craftables = null;
        for (int i = 0; i < this.getChassisSize(); ++i) {
            LogisticsModule x = this.getSubModule(i);
            if (!(x instanceof ICraftItems)) continue;
            if (craftables == null) {
                craftables = new LinkedList<ItemIdentifierStack>();
            }
            craftables.addAll(((ICraftItems)((Object)x)).getCraftedItems());
        }
        return craftables;
    }

    @Override
    public boolean canCraft(IResource toCraft) {
        for (int i = 0; i < this.getChassisSize(); ++i) {
            LogisticsModule x = this.getSubModule(i);
            if (!(x instanceof ICraftItems) || !((ICraftItems)((Object)x)).canCraft(toCraft)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public ISlotUpgradeManager getUpgradeManager(LogisticsModule.ModulePositionType slot, int positionInt) {
        if (slot != LogisticsModule.ModulePositionType.SLOT || positionInt >= this.slotUpgradeManagers.size()) {
            if (LogisticsPipes.isDEBUG()) {
                new UnsupportedOperationException("Position info aren't for a chassis pipe. (" + (Object)((Object)slot) + "/" + positionInt + ")").printStackTrace();
            }
            return super.getUpgradeManager(slot, positionInt);
        }
        return (ISlotUpgradeManager)this.slotUpgradeManagers.get(positionInt);
    }

    @Override
    public int getTodo() {
        return 0;
    }

    @Nullable
    public LogisticsModule getSubModule(int slot) {
        return this._module.getModule(slot);
    }

    public static class ChassiTargetInformation
    implements IAdditionalTargetInformation {
        private final int moduleSlot;

        public ChassiTargetInformation(int slot) {
            this.moduleSlot = slot;
        }

        public int getModuleSlot() {
            return this.moduleSlot;
        }
    }
}

