/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.Objects;
import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.textures.Textures;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PipeItemsSystemDestinationLogistics
extends CoreRoutedPipe {
    public ItemIdentifierInventory inv = new ItemIdentifierInventory(1, "Freq Slot", 1);

    public PipeItemsSystemDestinationLogistics(Item item) {
        super(item);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_DESTINATION_TEXTURE;
    }

    @Override
    public LogisticsModule getLogisticsModule() {
        return null;
    }

    public Object getTargetUUID() {
        ItemIdentifierStack itemident = this.inv.getIDStackInSlot(0);
        if (itemident == null) {
            return null;
        }
        ItemStack stack = itemident.makeNormalStack();
        if (!stack.func_77942_o()) {
            return null;
        }
        if (!Objects.requireNonNull(stack.func_77978_p()).func_74764_b("UUID")) {
            return null;
        }
        this.spawnParticle(Particles.WhiteParticle, 2);
        return UUID.fromString(stack.func_77978_p().func_74779_i("UUID"));
    }

    @Override
    public void onAllowedRemoval() {
        this.dropFreqCard();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound);
    }

    private void dropFreqCard() {
        ItemIdentifierStack itemident = this.inv.getIDStackInSlot(0);
        if (itemident == null) {
            return;
        }
        EntityItem item = new EntityItem(this.getWorld(), (double)this.getX(), (double)this.getY(), (double)this.getZ(), itemident.makeNormalStack());
        this.getWorld().func_72838_d((Entity)item);
        this.inv.clearInventorySlotContents(0);
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 15, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }
}

