/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.connection.LPNeighborTileEntityKt;
import network.rs485.logisticspipes.property.Property;

public class ModuleSatellite
extends LogisticsModule {
    private final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 1, 0, null);

    @Override
    @Nonnull
    public String getLPName() {
        throw new RuntimeException("Cannot get LP name for " + this);
    }

    @Override
    @NotNull
    public List<Property<?>> getProperties() {
        return Collections.emptyList();
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        int itemCount = this.spaceFor(stack, item, includeInTransit);
        if (itemCount > 0) {
            return new SinkReply(this._sinkReply, itemCount);
        }
        return null;
    }

    private int spaceFor(@Nonnull ItemStack stack, ItemIdentifier item, boolean includeInTransit) {
        IPipeServiceProvider service = Objects.requireNonNull(this._service);
        int count2 = service.getAvailableAdjacent().inventories().stream().map(neighbor -> LPNeighborTileEntityKt.sneakyInsertion(neighbor).from(this.getUpgradeManager())).map(LPNeighborTileEntityKt::getInventoryUtil).filter(Objects::nonNull).map(util -> util.roomForItem(stack)).reduce(Integer::sum).orElse(0);
        if (includeInTransit) {
            count2 -= service.countOnRoute(item);
        }
        return count2;
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }
}

