/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import logisticspipes.gui.hud.modules.HUDProviderModule;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ILegacyActiveModule;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logistics.LogisticsManager;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.module.inhand.ProviderModuleInHand;
import logisticspipes.network.guis.module.inpipe.ProviderModuleGuiProvider;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.module.ModuleInventory;
import logisticspipes.network.packets.modules.SneakyModuleDirectionUpdate;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.ServerRouter;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.inventory.IItemIdentifierInventory;
import network.rs485.logisticspipes.inventory.ProviderMode;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.module.SneakyDirection;
import network.rs485.logisticspipes.property.BooleanProperty;
import network.rs485.logisticspipes.property.EnumProperty;
import network.rs485.logisticspipes.property.InventoryProperty;
import network.rs485.logisticspipes.property.NullableEnumProperty;
import network.rs485.logisticspipes.property.Property;

@CCType(name="Provider Module")
public class ModuleProvider
extends LogisticsModule
implements SneakyDirection,
ILegacyActiveModule,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
IModuleInventoryReceive,
Gui {
    public final ArrayList<ItemIdentifierStack> displayList = new ArrayList();
    public final InventoryProperty filterInventory = new InventoryProperty(new ItemIdentifierInventory(9, "Items to provide (or empty for all)", 1), "");
    public final BooleanProperty isActive = new BooleanProperty(false, "isActive");
    public final BooleanProperty isExclusionFilter = new BooleanProperty(false, "filterisexclude");
    public final EnumProperty<ProviderMode> providerMode = new EnumProperty((Enum)ProviderMode.DEFAULT, "extractionMode", (Enum[])ProviderMode.values());
    public final NullableEnumProperty<EnumFacing> sneakyDirection = new NullableEnumProperty(null, "sneakydirection", (Enum[])EnumFacing.values());
    public final ImmutableList<Property<?>> propertyList = ImmutableList.builder().add((Object)this.filterInventory).add((Object)this.isActive).add((Object)this.isExclusionFilter).add(this.providerMode).add(this.sneakyDirection).build();
    private final Map<ItemIdentifier, Integer> displayMap = new TreeMap<ItemIdentifier, Integer>();
    private final ArrayList<ItemIdentifierStack> oldList = new ArrayList();
    private final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    private final IHUDModuleRenderer HUD = new HUDProviderModule(this);

    public static String getName() {
        return "provider";
    }

    @Override
    @Nonnull
    public String getLPName() {
        return ModuleProvider.getName();
    }

    @Override
    @Nonnull
    public List<Property<?>> getProperties() {
        return this.propertyList;
    }

    @Override
    public EnumFacing getSneakyDirection() {
        return (EnumFacing)this.sneakyDirection.getValue();
    }

    @Override
    public void setSneakyDirection(EnumFacing direction) {
        this.sneakyDirection.setValue(direction);
        MainProxy.runOnServer((IBlockAccess)this.getWorld(), () -> () -> MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(SneakyModuleDirectionUpdate.class).setDirection((EnumFacing)this.sneakyDirection.getValue()).setModulePos(this), this.localModeWatchers));
    }

    protected int neededEnergy() {
        return (int)(1.0 * Math.pow(1.1, this.getUpgradeManager().getItemExtractionUpgrade()) * Math.pow(1.2, this.getUpgradeManager().getItemStackExtractionUpgrade()));
    }

    protected int itemsToExtract() {
        return 8 * (int)Math.pow(2.0, this.getUpgradeManager().getItemExtractionUpgrade());
    }

    protected int stacksToExtract() {
        return 1 + this.getUpgradeManager().getItemStackExtractionUpgrade();
    }

    public CoreRoutedPipe.ItemSendMode itemSendMode() {
        return this.getUpgradeManager().getItemExtractionUpgrade() > 0 ? CoreRoutedPipe.ItemSendMode.Fast : CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        return null;
    }

    @Override
    public void tick() {
        int sent;
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return;
        }
        if (service.isNthTick(6)) {
            this.checkUpdate(null);
        }
        int itemsleft = this.itemsToExtract();
        LogisticsItemOrder firstOrder = null;
        LogisticsItemOrder order = null;
        for (int stacksleft = this.stacksToExtract(); itemsleft > 0 && stacksleft > 0 && service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.PROVIDER) && (firstOrder == null || firstOrder != order); --stacksleft, itemsleft -= sent) {
            if (firstOrder == null) {
                firstOrder = order;
            }
            if ((sent = this.sendStack(order.getResource().stack, itemsleft, (order = (LogisticsItemOrder)service.getItemOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.PROVIDER)).getDestination().getRouter().getSimpleID(), order.getInformation())) < 0) break;
            service.spawnParticle(Particles.VioletParticle, 3);
        }
    }

    public boolean filterBlocksItem(ItemIdentifier item) {
        if (this.filterInventory.func_191420_l()) {
            return false;
        }
        boolean isFiltered = this.filterInventory.containsItem(item);
        return (Boolean)this.isExclusionFilter.getValue() == isFiltered;
    }

    @Override
    public void onBlockRemoval() {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return;
        }
        while (service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.PROVIDER)) {
            service.getItemOrderManager().sendFailed();
        }
    }

    @Nonnull
    public Stream<IInventoryUtil> inventoriesWithMode() {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return Stream.empty();
        }
        return service.getAvailableAdjacent().inventories().stream().map(this::getInventoryUtilWithMode).filter(Objects::nonNull);
    }

    @Override
    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filters) {
        ArrayList<ItemIdentifier> possible = new ArrayList<ItemIdentifier>();
        if (tree.getRequestType() instanceof ItemResource) {
            possible.add(((ItemResource)tree.getRequestType()).getItem());
        } else if (tree.getRequestType() instanceof DictResource) {
            possible.addAll(this.inventoriesWithMode().map(IInventoryUtil::getItemsAndCount).flatMap(inventory -> inventory.keySet().stream()).filter(item -> tree.getRequestType().matches((ItemIdentifier)item, IResource.MatchSettings.NORMAL)).collect(Collectors.toList()));
        }
        for (ItemIdentifier item2 : possible) {
            int canProvide = this.getAvailableItemCount(item2);
            canProvide -= root.getAllPromissesFor((IProvideItems)((Object)this._service), item2);
            if ((canProvide = Math.min(canProvide, tree.getMissingAmount())) < 1) {
                return;
            }
            LogisticsPromise promise = new LogisticsPromise(item2, canProvide, (IProvideItems)((Object)this._service), IOrderInfoProvider.ResourceType.PROVIDER);
            tree.addPromise(promise);
        }
    }

    @Override
    public LogisticsOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return null;
        }
        service.spawnParticle(Particles.WhiteParticle, 2);
        return service.getItemOrderManager().addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, IOrderInfoProvider.ResourceType.PROVIDER, info);
    }

    private int getAvailableItemCount(ItemIdentifier item) {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return 0;
        }
        return this.getTotalItemCount(item) - service.getItemOrderManager().totalItemsCountInOrders(item);
    }

    @Override
    public void getAllItems(Map<ItemIdentifier, Integer> items, List<IFilter> filters) {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return;
        }
        items.putAll(this.inventoriesWithMode().map(IInventoryUtil::getItemsAndCount).flatMap(inventory -> inventory.entrySet().stream()).filter(item -> {
            if (items.containsKey(item.getKey())) {
                return false;
            }
            if (this.filterBlocksItem((ItemIdentifier)item.getKey())) {
                return false;
            }
            boolean blockedInFilters = filters.stream().anyMatch(filter2 -> filter2.isBlocked() == filter2.isFilteredItem(((ItemIdentifier)item.getKey()).getUndamaged()) || filter2.blockProvider());
            return !blockedInFilters;
        }).map(item -> new Pair(item.getKey(), (Integer)item.getValue() - service.getItemOrderManager().totalItemsCountInOrders((ItemIdentifier)item.getKey()))).filter(itemIdentAndRemaining -> (Integer)itemIdentAndRemaining.getValue2() > 0).collect(Pair.toMap(Integer::sum)));
    }

    public int sendStack(ItemIdentifierStack stack, int maxCount, int destination, IAdditionalTargetInformation info) {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return -1;
        }
        ItemIdentifier item = stack.getItem();
        Iterator iterator2 = service.getAvailableAdjacent().inventories().stream().flatMap(neighbor -> {
            IInventoryUtil invUtil = this.getInventoryUtilWithMode((NeighborTileEntity<TileEntity>)neighbor);
            if (invUtil == null) {
                return Stream.empty();
            }
            return Stream.of(new Pair<IInventoryUtil, EnumFacing>(invUtil, neighbor.getDirection()));
        }).iterator();
        while (iterator2.hasNext()) {
            Pair current = (Pair)iterator2.next();
            int available = ((IInventoryUtil)current.getValue1()).itemCount(item);
            if (available == 0) continue;
            int wanted = Math.min(available, stack.getStackSize());
            wanted = Math.min(wanted, maxCount);
            wanted = Math.min(wanted, item.getMaxStackSize());
            ServerRouter dRtr = SimpleServiceLocator.routerManager.getServerRouter(destination);
            if (dRtr == null) {
                service.getItemOrderManager().sendFailed();
                return 0;
            }
            SinkReply reply = LogisticsManager.canSink(stack.makeNormalStack(), dRtr, null, true, stack.getItem(), null, true, false);
            boolean defersend = false;
            if (reply != null && reply.maxNumberOfItems < wanted) {
                wanted = reply.maxNumberOfItems;
                if (wanted <= 0) {
                    service.getItemOrderManager().deferSend();
                    return 0;
                }
                defersend = true;
            }
            if (!service.canUseEnergy(wanted * this.neededEnergy())) {
                return -1;
            }
            ItemStack removed = ((IInventoryUtil)current.getValue1()).getMultipleItems(item, wanted);
            if (removed.func_190926_b()) continue;
            int sent = removed.func_190916_E();
            service.useEnergy(sent * this.neededEnergy());
            IRoutedItem routedItem = service.sendStack(removed, destination, this.itemSendMode(), info, (EnumFacing)current.getValue2());
            service.getItemOrderManager().sendSuccessfull(sent, defersend, routedItem);
            return sent;
        }
        service.getItemOrderManager().sendFailed();
        return 0;
    }

    public int getTotalItemCount(ItemIdentifier item) {
        if (this.filterBlocksItem(item)) {
            return 0;
        }
        return this.inventoriesWithMode().map(invUtil -> invUtil.itemCount(item)).reduce(Integer::sum).orElse(0);
    }

    @CCCommand(description="Returns the FilterInventory of this Module")
    public IItemIdentifierInventory getFilterInventory() {
        return this.filterInventory;
    }

    @Override
    @Nonnull
    public List<String> getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add((Boolean)this.isExclusionFilter.getValue() == false ? "Included" : "Excluded");
        list.add("Mode: " + ((ProviderMode)((Object)this.providerMode.getValue())).name());
        list.add("Filter: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    private void checkUpdate(EntityPlayer player) {
        if (this.localModeWatchers.size() == 0 && player == null) {
            return;
        }
        this.displayList.clear();
        this.displayMap.clear();
        this.getAllItems(this.displayMap, new ArrayList<IFilter>(0));
        this.displayList.ensureCapacity(this.displayMap.size());
        this.displayList.addAll(this.displayMap.entrySet().stream().map(item -> new ItemIdentifierStack((ItemIdentifier)item.getKey(), (Integer)item.getValue())).collect(Collectors.toList()));
        if (!this.oldList.equals(this.displayList)) {
            this.oldList.clear();
            this.oldList.ensureCapacity(this.displayList.size());
            this.oldList.addAll(this.displayList);
            MainProxy.sendToPlayerList(PacketHandler.getPacket(ModuleInventory.class).setIdentList(this.displayList).setModulePos(this).setCompressable(true), this.localModeWatchers);
        } else if (player != null) {
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(ModuleInventory.class).setIdentList(this.displayList).setModulePos(this).setCompressable(true), player);
        }
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
        this.checkUpdate(player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return this.HUD;
    }

    @Override
    public void handleInvContent(@Nonnull Collection<ItemIdentifierStack> list) {
        this.displayList.clear();
        this.displayList.addAll(list);
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemidCollection) {
        if (!((Boolean)this.isExclusionFilter.getValue()).booleanValue() && !this.filterInventory.func_191420_l()) {
            itemidCollection.addAll(this.filterInventory.getItemsAndCount().keySet());
        }
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return (Boolean)this.isExclusionFilter.getValue() != false || this.filterInventory.func_191420_l();
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return false;
    }

    @Override
    @Nonnull
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(ProviderModuleGuiProvider.class).setExtractorMode(((ProviderMode)((Object)this.providerMode.getValue())).ordinal()).setExclude((Boolean)this.isExclusionFilter.getValue());
    }

    @Override
    @Nonnull
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(ProviderModuleInHand.class);
    }

    private IInventoryUtil getInventoryUtilWithMode(NeighborTileEntity<TileEntity> neighbor) {
        return SimpleServiceLocator.inventoryUtilFactory.getHidingInventoryUtil(neighbor.getTileEntity(), neighbor.getOurDirection(), (ProviderMode)((Object)this.providerMode.getValue()));
    }
}

