/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logistics;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.items.LogisticsFluidContainer;
import logisticspipes.logistics.ILogisticsManager;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.pipes.PipeItemsProviderLogistics;
import logisticspipes.pipes.PipeItemsRequestLogistics;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.item.ItemStack;

public class LogisticsManager
implements ILogisticsManager {
    private Triplet<Integer, SinkReply, List<IFilter>> getBestReply(@Nonnull ItemStack stack, ItemIdentifier item, @Nonnull IRouter sourceRouter, @Nonnull List<ExitRoute> validDestinations, boolean excludeSource, List<Integer> jamList, Triplet<Integer, SinkReply, List<IFilter>> result2, boolean allowDefault) {
        if (result2 == null) {
            result2 = new Triplet<Object, Object, Object>(null, null, null);
        }
        block0: for (ExitRoute candidateRouter : validDestinations) {
            LinkedList list;
            if (excludeSource && candidateRouter.destination.getId().equals(sourceRouter.getId()) || jamList.contains(candidateRouter.destination.getSimpleID()) || !candidateRouter.containsFlag(PipeRoutingConnectionType.canRouteTo)) continue;
            for (IFilter filter2 : candidateRouter.filters) {
                if (!filter2.blockRouting() && filter2.isBlocked() != filter2.isFilteredItem(item)) continue;
                continue block0;
            }
            SinkReply reply = LogisticsManager.canSink(stack, candidateRouter.destination, sourceRouter, excludeSource, item, (SinkReply)result2.getValue2(), false, allowDefault);
            if (reply == null) continue;
            if (result2.getValue1() == null) {
                result2.setValue1(candidateRouter.destination.getSimpleID());
                result2.setValue2(reply);
                list = new LinkedList();
                result2.setValue3(list);
                continue;
            }
            if (reply.fixedPriority.ordinal() > ((SinkReply)result2.getValue2()).fixedPriority.ordinal()) {
                result2.setValue1(candidateRouter.destination.getSimpleID());
                result2.setValue2(reply);
                list = new LinkedList();
                result2.setValue3(list);
                continue;
            }
            if (reply.fixedPriority != ((SinkReply)result2.getValue2()).fixedPriority || reply.customPriority <= ((SinkReply)result2.getValue2()).customPriority) continue;
            result2.setValue1(candidateRouter.destination.getSimpleID());
            result2.setValue2(reply);
            list = new LinkedList();
            result2.setValue3(list);
        }
        if (result2.getValue1() != null) {
            CoreRoutedPipe pipe = SimpleServiceLocator.routerManager.getServerRouter((Integer)result2.getValue1()).getPipe();
            pipe.useEnergy(((SinkReply)result2.getValue2()).energyUse);
            pipe.spawnParticle(Particles.BlueParticle, 10);
        }
        return result2;
    }

    public static SinkReply canSink(@Nonnull ItemStack stack, @Nonnull IRouter destination, IRouter sourceRouter, boolean excludeSource, ItemIdentifier item, SinkReply result2, boolean activeRequest, boolean allowDefault) {
        return LogisticsManager.canSink(stack, destination, sourceRouter, excludeSource, item, result2, activeRequest, allowDefault, true);
    }

    public static SinkReply canSink(@Nonnull ItemStack stack, @Nonnull IRouter destination, IRouter sourceRouter, boolean excludeSource, ItemIdentifier item, SinkReply result2, boolean activeRequest, boolean allowDefault, boolean forcePassive) {
        LogisticsModule module = destination.getLogisticsModule();
        CoreRoutedPipe crp = destination.getPipe();
        if (module == null) {
            return null;
        }
        if (!module.recievePassive() && !activeRequest) {
            return null;
        }
        if (crp == null || !crp.isEnabled()) {
            return null;
        }
        if (excludeSource && sourceRouter != null && destination.getPipe().isOnSameContainer(sourceRouter.getPipe())) {
            return null;
        }
        SinkReply reply = result2 == null ? module.sinksItem(stack, item, -1, 0, allowDefault, true, forcePassive) : module.sinksItem(stack, item, result2.fixedPriority.ordinal(), result2.customPriority, allowDefault, true, forcePassive);
        if (result2 != null && result2.maxNumberOfItems < 0) {
            return null;
        }
        return reply;
    }

    @Override
    public IRoutedItem assignDestinationFor(IRoutedItem item, int sourceRouterID, boolean excludeSource) {
        Pair<Integer, Integer> bestReply;
        ServerRouter sourceRouter = SimpleServiceLocator.routerManager.getServerRouter(sourceRouterID);
        if (sourceRouter == null) {
            return item;
        }
        item.clearDestination();
        ItemIdentifierStack itemIdStack = item.getItemIdentifierStack();
        if (itemIdStack == null) {
            return item;
        }
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(itemIdStack.getItem());
        ArrayList<ExitRoute> validDestinations = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            ServerRouter r = SimpleServiceLocator.routerManager.getServerRouter(i);
            List<ExitRoute> exits = sourceRouter.getDistanceTo(r);
            if (exits != null) {
                validDestinations.addAll(exits.stream().filter(e -> e.containsFlag(PipeRoutingConnectionType.canRouteTo)).collect(Collectors.toList()));
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        Collections.sort(validDestinations);
        ItemStack stack = itemIdStack.makeNormalStack();
        if (stack.func_77973_b() instanceof LogisticsFluidContainer) {
            bestReply = SimpleServiceLocator.logisticsFluidManager.getBestReply(SimpleServiceLocator.logisticsFluidManager.getFluidFromContainer(itemIdStack), sourceRouter, item.getJamList());
            if (bestReply.getValue1() != null && bestReply.getValue1() != 0) {
                item.setDestination(bestReply.getValue1());
            }
        } else {
            bestReply = this.getBestReply(stack, itemIdStack.getItem(), sourceRouter, validDestinations, excludeSource, item.getJamList(), null, true);
            if (bestReply.getValue1() != null && bestReply.getValue1() != 0) {
                item.setDestination(bestReply.getValue1());
                if (((SinkReply)((Object)bestReply.getValue2())).isPassive) {
                    if (((SinkReply)((Object)bestReply.getValue2())).isDefault) {
                        item.setTransportMode(IRoutedItem.TransportMode.Default);
                    } else {
                        item.setTransportMode(IRoutedItem.TransportMode.Passive);
                    }
                } else {
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                }
                item.setAdditionalTargetInformation(((SinkReply)((Object)bestReply.getValue2())).addInfo);
            }
        }
        return item;
    }

    @Override
    public String getBetterRouterName(IRouter r) {
        PipeItemsCraftingLogistics pipe;
        if (r.getPipe() instanceof PipeItemsCraftingLogistics && (pipe = (PipeItemsCraftingLogistics)r.getPipe()).getCraftedItems() != null) {
            List<ItemIdentifierStack> items = pipe.getCraftedItems();
            if (items.size() == 1) {
                return "Crafter<" + items.get(0).getFriendlyName() + ">";
            }
            return "Crafter< MULTIPLE ITEMS >";
        }
        if (r.getPipe() instanceof PipeItemsProviderLogistics) {
            return "Provider";
        }
        if (r.getPipe() instanceof PipeLogisticsChassis) {
            return "Chassis";
        }
        if (r.getPipe() instanceof PipeItemsRequestLogistics) {
            return "Request";
        }
        return r.getId().toString();
    }

    public HashMap<ItemIdentifier, Integer> getAvailableItems(List<ExitRoute> validDestinations) {
        ArrayList items = new ArrayList(ServerRouter.getBiggestSimpleID());
        for (int i = 0; i < ServerRouter.getBiggestSimpleID(); ++i) {
            items.add(new HashMap());
        }
        BitSet used = new BitSet(ServerRouter.getBiggestSimpleID());
        block1: for (ExitRoute r : validDestinations) {
            if (r == null || !r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || !(r.destination.getPipe() instanceof IProvideItems)) continue;
            for (IFilter filter2 : r.filters) {
                if (!filter2.blockProvider()) continue;
                continue block1;
            }
            IProvideItems iProvideItems = (IProvideItems)((Object)r.destination.getPipe());
            iProvideItems.getAllItems((Map)items.get(r.destination.getSimpleID()), r.filters);
            used.set(r.destination.getSimpleID(), true);
        }
        HashMap<ItemIdentifier, Integer> allAvailableItems = new HashMap<ItemIdentifier, Integer>();
        for (Map map2 : items) {
            for (Map.Entry item : map2.entrySet()) {
                allAvailableItems.merge((ItemIdentifier)item.getKey(), (Integer)item.getValue(), Integer::sum);
            }
        }
        return allAvailableItems;
    }

    @Override
    public LinkedList<ItemIdentifier> getCraftableItems(List<ExitRoute> validDestinations) {
        LinkedList<ItemIdentifier> craftableItems = new LinkedList<ItemIdentifier>();
        BitSet used = new BitSet(ServerRouter.getBiggestSimpleID());
        block0: for (ExitRoute r : validDestinations) {
            if (r == null || !r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || used.get(r.destination.getSimpleID()) || !(r.destination.getPipe() instanceof ICraftItems)) continue;
            for (IFilter filter2 : r.filters) {
                if (!filter2.blockCrafting()) continue;
                continue block0;
            }
            ICraftItems crafter = (ICraftItems)((Object)r.destination.getPipe());
            List<ItemIdentifierStack> craftedItems = crafter.getCraftedItems();
            if (craftedItems != null) {
                block2: for (ItemIdentifierStack craftedItem : craftedItems) {
                    if (craftedItem == null || craftableItems.contains(craftedItem.getItem())) continue;
                    for (IFilter filter3 : r.filters) {
                        if (filter3.isBlocked() != filter3.isFilteredItem(craftedItem.getItem())) continue;
                        continue block2;
                    }
                    craftableItems.add(craftedItem.getItem());
                }
            }
            used.set(r.destination.getSimpleID(), true);
        }
        return craftableItems;
    }

    @Override
    public int getAmountFor(ItemIdentifier itemType, List<ExitRoute> validDestinations) {
        ArrayList items = new ArrayList(ServerRouter.getBiggestSimpleID());
        for (int i = 0; i < ServerRouter.getBiggestSimpleID(); ++i) {
            items.add(new HashMap());
        }
        BitSet used = new BitSet(ServerRouter.getBiggestSimpleID());
        block1: for (ExitRoute r : validDestinations) {
            if (r == null || !r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || !(r.destination.getPipe() instanceof IProvideItems)) continue;
            for (IFilter filter2 : r.filters) {
                if (!filter2.blockProvider()) continue;
                continue block1;
            }
            IProvideItems iProvideItems = (IProvideItems)((Object)r.destination.getPipe());
            iProvideItems.getAllItems((Map)items.get(r.destination.getSimpleID()), r.filters);
            used.set(r.destination.getSimpleID(), true);
        }
        int amount = 0;
        for (Map map2 : items) {
            for (Map.Entry item : map2.entrySet()) {
                if (!((ItemIdentifier)item.getKey()).equals(itemType)) continue;
                amount += ((Integer)item.getValue()).intValue();
            }
        }
        return amount;
    }
}

