/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.kotlinx.serialization.json.internal;

import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.functions.Function1;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.reflect.KClass;
import logisticspipes.kotlinx.serialization.DeserializationStrategy;
import logisticspipes.kotlinx.serialization.KSerializer;
import logisticspipes.kotlinx.serialization.descriptors.PolymorphicKind;
import logisticspipes.kotlinx.serialization.descriptors.PrimitiveKind;
import logisticspipes.kotlinx.serialization.descriptors.SerialDescriptor;
import logisticspipes.kotlinx.serialization.descriptors.SerialKind;
import logisticspipes.kotlinx.serialization.descriptors.StructureKind;
import logisticspipes.kotlinx.serialization.modules.SerializersModuleCollector;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J\u001c\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J.\u0010\u000e\u001a\u00020\b\"\b\b\u0000\u0010\u000f*\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u000f0\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013H\u0016JF\u0010\u0014\u001a\u00020\b\"\b\b\u0000\u0010\u0015*\u00020\u0010\"\b\b\u0001\u0010\u0016*\u0002H\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u00160\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0013H\u0016JO\u0010\u0019\u001a\u00020\b\"\b\b\u0000\u0010\u0015*\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\f2-\u0010\u001a\u001a)\u0012\u0015\u0012\u0013\u0018\u00010\u0005\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u000e\u0012\f\u0012\u0006\b\u0001\u0012\u0002H\u0015\u0018\u00010\u001f0\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Llogisticspipes/kotlinx/serialization/json/internal/PolymorphismValidator;", "Llogisticspipes/kotlinx/serialization/modules/SerializersModuleCollector;", "useArrayPolymorphism", "", "discriminator", "", "(ZLjava/lang/String;)V", "checkDiscriminatorCollisions", "", "descriptor", "Llogisticspipes/kotlinx/serialization/descriptors/SerialDescriptor;", "actualClass", "Llogisticspipes/kotlin/reflect/KClass;", "checkKind", "contextual", "T", "", "kClass", "serializer", "Llogisticspipes/kotlinx/serialization/KSerializer;", "polymorphic", "Base", "Sub", "baseClass", "actualSerializer", "polymorphicDefault", "defaultSerializerProvider", "Llogisticspipes/kotlin/Function1;", "Llogisticspipes/kotlin/ParameterName;", "name", "className", "Llogisticspipes/kotlinx/serialization/DeserializationStrategy;", "logisticspipes.kotlinx-serialization-json"})
public final class PolymorphismValidator
implements SerializersModuleCollector {
    private final boolean useArrayPolymorphism;
    private final String discriminator;

    @Override
    public <T> void contextual(@NotNull KClass<T> kClass, @NotNull KSerializer<T> serializer2) {
        Intrinsics.checkNotNullParameter(kClass, "kClass");
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
    }

    @Override
    public <Base, Sub extends Base> void polymorphic(@NotNull KClass<Base> baseClass, @NotNull KClass<Sub> actualClass, @NotNull KSerializer<Sub> actualSerializer) {
        Intrinsics.checkNotNullParameter(baseClass, "baseClass");
        Intrinsics.checkNotNullParameter(actualClass, "actualClass");
        Intrinsics.checkNotNullParameter(actualSerializer, "actualSerializer");
        SerialDescriptor descriptor2 = actualSerializer.getDescriptor();
        this.checkKind(descriptor2, actualClass);
        if (!this.useArrayPolymorphism) {
            this.checkDiscriminatorCollisions(descriptor2, actualClass);
        }
    }

    private final void checkKind(SerialDescriptor descriptor2, KClass<?> actualClass) {
        SerialKind kind = descriptor2.getKind();
        if (kind instanceof PolymorphicKind || Intrinsics.areEqual(kind, SerialKind.CONTEXTUAL.INSTANCE)) {
            throw (Throwable)new IllegalArgumentException("Serializer for " + actualClass.getSimpleName() + " can't be registered as a subclass for polymorphic serialization " + "because its kind " + kind + " is not concrete. To work with multiple hierarchies, register it as a base class.");
        }
        if (this.useArrayPolymorphism) {
            return;
        }
        if (Intrinsics.areEqual(kind, StructureKind.LIST.INSTANCE) || Intrinsics.areEqual(kind, StructureKind.MAP.INSTANCE) || kind instanceof PrimitiveKind || kind instanceof SerialKind.ENUM) {
            throw (Throwable)new IllegalArgumentException("Serializer for " + actualClass.getSimpleName() + " of kind " + kind + " cannot be serialized polymorphically with class discriminator.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDiscriminatorCollisions(SerialDescriptor descriptor2, KClass<?> actualClass) {
        int n = 0;
        int n2 = descriptor2.getElementsCount();
        while (n < n2) {
            void i;
            String name = descriptor2.getElementName((int)i);
            if (Intrinsics.areEqual(name, this.discriminator)) {
                throw (Throwable)new IllegalArgumentException("Polymorphic serializer for " + actualClass + " has property '" + name + "' that conflicts " + "with JSON class discriminator. You can either change class discriminator in JsonConfiguration, " + "rename property with @SerialName annotation " + "or fall back to array polymorphism");
            }
            ++i;
        }
    }

    @Override
    public <Base> void polymorphicDefault(@NotNull KClass<Base> baseClass, @NotNull Function1<? super String, ? extends DeserializationStrategy<? extends Base>> defaultSerializerProvider) {
        Intrinsics.checkNotNullParameter(baseClass, "baseClass");
        Intrinsics.checkNotNullParameter(defaultSerializerProvider, "defaultSerializerProvider");
    }

    public PolymorphismValidator(boolean useArrayPolymorphism, @NotNull String discriminator) {
        Intrinsics.checkNotNullParameter(discriminator, "discriminator");
        this.useArrayPolymorphism = useArrayPolymorphism;
        this.discriminator = discriminator;
    }
}

